/*
 * Decompiled with CFR 0.152.
 */
package dev.eposs.elementsutils.feature.xpformat;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class FarmingXpTracker {
    private static final List<Long> timestamps = new ArrayList<Long>();
    private static final List<Integer> xpValues = new ArrayList<Integer>();
    private static long lastMessageTime = 0L;
    private static int lastXp = -1;

    public static void update(int currentXp) {
        long now = System.currentTimeMillis();
        if (now - lastMessageTime > 5000L) {
            timestamps.clear();
            xpValues.clear();
            lastXp = currentXp;
        }
        if (currentXp != lastXp) {
            timestamps.add(now);
            xpValues.add(currentXp);
            lastXp = currentXp;
        }
        lastMessageTime = now;
        while (!timestamps.isEmpty() && now - timestamps.getFirst() > 20000L) {
            timestamps.removeFirst();
            xpValues.removeFirst();
        }
    }

    public static float getXpPerSecond() {
        if (xpValues.size() < 2) {
            return 0.0f;
        }
        int deltaXp = xpValues.getLast() - xpValues.getFirst();
        long deltaTime = timestamps.getLast() - timestamps.getFirst();
        if (deltaTime == 0L) {
            return 0.0f;
        }
        return (float)deltaXp / ((float)deltaTime / 1000.0f);
    }

    public static void reset() {
        timestamps.clear();
        xpValues.clear();
        lastXp = -1;
        lastMessageTime = 0L;
    }
}

