/*
 * Decompiled with CFR 0.152.
 */
package dev.eposs.elementsutils.feature.xpformat;

import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class XpFormat {
    private static final Pattern NUMBER_PATTERN = Pattern.compile("\\d{4,}");

    public static String formatNumbersWithDots(String input) {
        return NUMBER_PATTERN.matcher(input).replaceAll(matchResult -> {
            String digits = matchResult.group();
            try {
                long value = Long.parseLong(digits);
                return String.format("%,d", value).replace(',', '.');
            }
            catch (NumberFormatException e) {
                return digits;
            }
        });
    }
}

