/*
 * Decompiled with CFR 0.152.
 */
package dev.eposs.elementsutils.feature.xpmeter;

import dev.eposs.elementsutils.config.ModConfig;
import dev.eposs.elementsutils.mixin.client.InGameHudAccessor;
import dev.eposs.elementsutils.util.Util;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class XpMeter {
    private static MeasurementMode mode = MeasurementMode.XP_TARGET;
    private static boolean measuringInProgress = false;
    private static int startXp = 0;
    private static int currentProgress = 0;
    private static long startTime = 0L;
    private static int noXpTicks = 0;
    private static double displayedElapsedSeconds = 0.0;
    private static double displayedXpPerSecond = 0.0;
    private static long lastDisplayUpdate = 0L;
    private static final Pattern MINING_XP_PATTERN = Pattern.compile("Mining: (\\d[\\d.,]*)");
    private static final String trackedItemName = "Komprimiertes Basalt";
    private static int lastItemCount = 0;
    private static int itemsGainedTotal = 0;

    private static int getTargetXp() {
        return ModConfig.getConfig().xpMeterConfig.measuringXpTarget;
    }

    private static int getTargetTime() {
        return ModConfig.getConfig().xpMeterConfig.measuringTimeTarget * 1000;
    }

    public static boolean isMeasuringInProgress() {
        return measuringInProgress;
    }

    public static float getXpProgress() {
        if (mode == MeasurementMode.XP_TARGET) {
            return Math.min((float)currentProgress / (float)XpMeter.getTargetXp(), 1.0f);
        }
        return Math.min((float)(System.currentTimeMillis() - startTime) / (float)XpMeter.getTargetTime(), 1.0f);
    }

    public static int getCurrentProgress() {
        return currentProgress;
    }

    private static int countItemInInventory(class_310 client) {
        int count = 0;
        if (client.field_1724 != null) {
            for (int i = 0; i < client.field_1724.method_31548().method_5439(); ++i) {
                class_1799 stack = client.field_1724.method_31548().method_5438(i);
                if (stack.method_7960() || !stack.method_7964().getString().equals(trackedItemName)) continue;
                count += stack.method_7947();
            }
        }
        return count;
    }

    public static void startXPMeasurement(class_310 client) {
        if (measuringInProgress) {
            measuringInProgress = false;
            Util.sendChatMessage((class_2561)class_2561.method_43471((String)"elements-utils.message.xpMeter.cancelled"));
            return;
        }
        if (XpMeter.startMeasurement(client)) {
            return;
        }
        mode = MeasurementMode.XP_TARGET;
    }

    public static void startTimeMeasurement(class_310 client) {
        if (measuringInProgress) {
            measuringInProgress = false;
            Util.sendChatMessage((class_2561)class_2561.method_43471((String)"elements-utils.message.xpMeter.cancelled"));
            return;
        }
        if (XpMeter.startMeasurement(client)) {
            return;
        }
        mode = MeasurementMode.TIME_BASED;
    }

    private static boolean startMeasurement(class_310 client) {
        if (client.field_1724 == null || client.field_1687 == null) {
            return true;
        }
        class_2561 overlayMessage = ((InGameHudAccessor)client.field_1705).getOverlayMessage();
        String overlayText = overlayMessage != null ? overlayMessage.getString() : "";
        Matcher matcher = MINING_XP_PATTERN.matcher(overlayText);
        if (!matcher.find()) {
            Util.sendChatMessage((class_2561)class_2561.method_43471((String)"elements-utils.message.xpMeter.startFailed"));
            return true;
        }
        String xpString = matcher.group(1).replaceAll("[.,]", "");
        startXp = Integer.parseInt(xpString);
        startTime = System.currentTimeMillis();
        currentProgress = 0;
        measuringInProgress = true;
        noXpTicks = 0;
        displayedElapsedSeconds = 0.0;
        displayedXpPerSecond = 0.0;
        lastDisplayUpdate = System.currentTimeMillis();
        lastItemCount = XpMeter.countItemInInventory(client);
        itemsGainedTotal = 0;
        return false;
    }

    public static void updateXpMeter(class_310 client) {
        long elapsed;
        if (!measuringInProgress) {
            return;
        }
        class_2561 overlayMessage = ((InGameHudAccessor)client.field_1705).getOverlayMessage();
        String overlayText = overlayMessage != null ? overlayMessage.getString() : "";
        Matcher matcher = MINING_XP_PATTERN.matcher(overlayText);
        if (!matcher.find()) {
            if (++noXpTicks >= 100) {
                Util.sendChatMessage((class_2561)class_2561.method_43471((String)"elements-utils.message.xpMeter.failed"));
                measuringInProgress = false;
            }
            return;
        }
        String xpString = matcher.group(1).replaceAll("[.,]", "");
        int currentXp = Integer.parseInt(xpString);
        currentProgress = currentXp - startXp;
        noXpTicks = 0;
        int currentCount = XpMeter.countItemInInventory(client);
        if (currentCount > lastItemCount) {
            itemsGainedTotal += currentCount - lastItemCount;
        }
        lastItemCount = currentCount;
        if (mode == MeasurementMode.XP_TARGET) {
            if (currentProgress >= XpMeter.getTargetXp()) {
                double elapsed2 = (double)(System.currentTimeMillis() - startTime) / 1000.0;
                double averageXpPerSecond = elapsed2 > 0.0 ? (double)currentProgress / elapsed2 : 0.0;
                Util.sendChatMessage((class_2561)class_2561.method_43470((String)("\u00a73" + XpMeter.getTargetXp() + class_2561.method_43471((String)"elements-utils.message.xpMeter.xpFinished").getString().replace("%s", String.format("%.2f", elapsed2)).replace("%a", String.format("%.2f", averageXpPerSecond)).replace("%i", String.valueOf(itemsGainedTotal)).replace("%c", String.format("%.2f", (double)itemsGainedTotal / 99.0)))));
                measuringInProgress = false;
            }
        } else if (mode == MeasurementMode.TIME_BASED && (elapsed = System.currentTimeMillis() - startTime) >= (long)XpMeter.getTargetTime()) {
            double seconds = (double)elapsed / 1000.0;
            double averageXpPerSecond = seconds > 0.0 ? (double)currentProgress / seconds : 0.0;
            Util.sendChatMessage((class_2561)class_2561.method_43470((String)("\u00a7e" + String.format("%.2f", seconds) + class_2561.method_43471((String)"elements-utils.message.xpMeter.timeFinished").getString().replace("%p", String.valueOf(currentProgress)).replace("%a", String.format("%.2f", averageXpPerSecond)).replace("%i", String.valueOf(itemsGainedTotal)).replace("%c", String.format("%.2f", (double)itemsGainedTotal / 99.0)))));
            measuringInProgress = false;
        }
    }

    public static void render(class_332 context, class_310 client) {
        if (!XpMeter.isMeasuringInProgress()) {
            return;
        }
        long now = System.currentTimeMillis();
        double elapsedSeconds = (double)(now - startTime) / 1000.0;
        double xpPerSecond = elapsedSeconds > 0.0 ? (double)currentProgress / elapsedSeconds : 0.0;
        displayedElapsedSeconds = elapsedSeconds;
        if (now - lastDisplayUpdate > 200L) {
            displayedXpPerSecond = xpPerSecond;
            lastDisplayUpdate = now;
        }
        int width = client.method_22683().method_4486();
        int y = 20;
        String timeText = String.format("%.2f", displayedElapsedSeconds);
        String xpPerSecondText = String.format("%.2f", displayedXpPerSecond);
        String itemsText = " +" + itemsGainedTotal + " " + class_2561.method_43471((String)"elements-utils.message.xpMeter.compressed").getString();
        int barWidth = 200;
        int barHeight = 10;
        int barX = width / 2 - barWidth / 2;
        int filled = (int)((float)barWidth * XpMeter.getXpProgress());
        if (mode == MeasurementMode.XP_TARGET) {
            String textPrefix = class_2561.method_43471((String)"elements-utils.message.xpMeter.xpMode").getString();
            String progressText = XpMeter.getCurrentProgress() + "XP/" + XpMeter.getTargetXp() + "XP";
            String timePrefix = " (";
            String timeSuffix = "\u00a7es \u00a7r| ";
            String textSuffix = "\u00a7bXP/s\u00a7r)";
            int prefixWidth = client.field_1772.method_1727(textPrefix);
            int progressWidth = client.field_1772.method_1727(progressText);
            int timePrefixWidth = client.field_1772.method_1727(timePrefix);
            int timeTextWidth = client.field_1772.method_1727(timeText);
            int timeSuffixWidth = client.field_1772.method_1727(timeSuffix);
            int xpPerSecondWidth = client.field_1772.method_1727(xpPerSecondText);
            int textSuffixWidth = client.field_1772.method_1727(textSuffix);
            int itemsWidth = client.field_1772.method_1727(itemsText);
            int totalWidth = prefixWidth + progressWidth + timePrefixWidth + timeTextWidth + timeSuffixWidth + xpPerSecondWidth + textSuffixWidth + itemsWidth;
            int x = width / 2 - totalWidth / 2;
            context.method_51433(client.field_1772, textPrefix, x, y, -256, true);
            context.method_51433(client.field_1772, progressText, x += prefixWidth, y, -6684775, true);
            context.method_51433(client.field_1772, timePrefix, x += progressWidth, y, 0xFFFFFF, true);
            context.method_51433(client.field_1772, timeText, x += timePrefixWidth, y, -256, true);
            context.method_51433(client.field_1772, timeSuffix, x += timeTextWidth, y, 0xFFFFFF, true);
            XpMeter.drawContext(context, client, y, xpPerSecondText, itemsText, textSuffix, xpPerSecondWidth, textSuffixWidth, x += timeSuffixWidth);
            context.method_25294(barX, y + 15, barX + filled, y + 15 + barHeight, -16711936);
            context.method_25294(barX + filled, y + 15, barX + barWidth, y + 15 + barHeight, -11184811);
        } else if (mode == MeasurementMode.TIME_BASED) {
            String textPrefix = class_2561.method_43471((String)"elements-utils.message.xpMeter.timeMode").getString();
            String xpText = currentProgress + "XP ";
            String timeRatio = String.format("\u00a7r(\u00a7e%.2fs\u00a7r/\u00a7e%.2fs \u00a7r| ", displayedElapsedSeconds, (double)XpMeter.getTargetTime() / 1000.0);
            String textSuffix = "\u00a7bXP/s\u00a7r)";
            int prefixWidth = client.field_1772.method_1727(textPrefix);
            int xpTextWidth = client.field_1772.method_1727(xpText);
            int timeRatioWidth = client.field_1772.method_1727(timeRatio);
            int xpPerSecondWidth = client.field_1772.method_1727(xpPerSecondText);
            int textSuffixWidth = client.field_1772.method_1727(textSuffix);
            int itemsWidth = client.field_1772.method_1727(itemsText);
            int totalWidth = prefixWidth + xpTextWidth + timeRatioWidth + xpPerSecondWidth + textSuffixWidth + itemsWidth;
            int x = width / 2 - totalWidth / 2;
            context.method_51433(client.field_1772, textPrefix, x, y, -16711681, true);
            context.method_51433(client.field_1772, xpText, x += prefixWidth, y, -6684775, true);
            context.method_51433(client.field_1772, timeRatio, x += xpTextWidth, y, -2894893, true);
            XpMeter.drawContext(context, client, y, xpPerSecondText, itemsText, textSuffix, xpPerSecondWidth, textSuffixWidth, x += timeRatioWidth);
            context.method_25294(barX, y + 15, barX + filled, y + 15 + barHeight, -16711681);
            context.method_25294(barX + filled, y + 15, barX + barWidth, y + 15 + barHeight, -11184811);
        }
    }

    private static void drawContext(class_332 context, class_310 client, int y, String xpPerSecondText, String itemsText, String textSuffix, int xpPerSecondWidth, int textSuffixWidth, int x) {
        context.method_51433(client.field_1772, xpPerSecondText, x, y, -16711681, true);
        context.method_51433(client.field_1772, textSuffix, x += xpPerSecondWidth, y, 0xFFFFFF, true);
        context.method_51433(client.field_1772, itemsText, x += textSuffixWidth, y, -2894893, true);
    }

    @Environment(value=EnvType.CLIENT)
    public static enum MeasurementMode {
        XP_TARGET,
        TIME_BASED;

    }
}

