/*
 * Decompiled with CFR 0.152.
 */
package dev.eposs.elementsutils.mixin.client;

import dev.eposs.elementsutils.config.ModConfig;
import dev.eposs.elementsutils.feature.pet.PetDisplay;
import dev.eposs.elementsutils.feature.xpformat.FarmingXpTracker;
import dev.eposs.elementsutils.feature.xpformat.XpFormat;
import dev.eposs.elementsutils.util.Util;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_9779;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_329.class})
public abstract class InGameHudMixin {
    @Shadow
    private class_2561 field_2018;
    @Shadow
    private int field_2041;

    @Inject(at={@At(value="HEAD")}, method={"renderOverlayMessage"})
    private void renderOverlayMessage(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        if (this.field_2018 != null && this.field_2041 > 0) {
            PetDisplay.updatePetXP(this.field_2018, false);
        }
    }

    @Inject(method={"setOverlayMessage"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSetOverlayMessage(class_2561 message, boolean tinted, CallbackInfo ci) {
        int xpIndex;
        if (message == null) {
            return;
        }
        String original = message.getString();
        String formatted = ModConfig.getConfig().playerXPConfig.enabled ? XpFormat.formatNumbersWithDots(original) : original;
        class_2583 overlayStyle = message.method_10866();
        ModConfig.KnownColor overlayColor = ModConfig.getConfig().playerXPConfig.overlayMessageColor;
        if (overlayColor != null && formatted.contains("XP")) {
            overlayStyle = overlayStyle.method_36139(overlayColor.color);
        }
        class_5250 xpPerSecText = null;
        class_2583 xpPerSecStyle = class_2583.field_24360;
        Matcher matcher = Pattern.compile("^[^:]+: ([\\d,.]+)/[\\d,.]+ XP").matcher(original);
        if (matcher.find()) {
            int farmingXp = Integer.parseInt(matcher.group(1).replace(".", "").replace(",", ""));
            FarmingXpTracker.update(farmingXp);
            if (ModConfig.getConfig().playerXPConfig.showXpPerSecond) {
                float xpPerSec = FarmingXpTracker.getXpPerSecond();
                ModConfig.KnownColor color = ModConfig.getConfig().playerXPConfig.xpPerSecondColor;
                if (color != null) {
                    xpPerSecStyle = xpPerSecStyle.method_36139(color.color);
                }
                xpPerSecText = class_2561.method_43470((String)String.format("%.2fXP/s", Float.valueOf(xpPerSec))).method_10862(xpPerSecStyle);
            }
        }
        if (ModConfig.getConfig().playerXPConfig.hideMaxPetXP) {
            if (original.matches(".*Pet: [\\d,.]+/-1 XP$")) {
                PetDisplay.setPetMaxLevel();
            }
            original = original.replaceFirst("\\s*\\p{So}?\\s*Pet: [\\d,.]+/-1 XP$", "");
            String string = formatted = ModConfig.getConfig().playerXPConfig.enabled ? XpFormat.formatNumbersWithDots(original) : original;
        }
        if (xpPerSecText != null && (xpIndex = formatted.indexOf("XP")) != -1) {
            String beforeXp = formatted.substring(0, xpIndex + 2);
            String afterXp = formatted.substring(xpIndex + 2);
            this.field_2018 = class_2561.method_43470((String)beforeXp).method_10862(overlayStyle).method_10852((class_2561)class_2561.method_43470((String)" (").method_10862(xpPerSecStyle)).method_10852((class_2561)xpPerSecText).method_10852((class_2561)class_2561.method_43470((String)")").method_10862(xpPerSecStyle)).method_10852((class_2561)class_2561.method_43470((String)afterXp).method_10862(overlayStyle));
            this.field_2041 = 60;
            ci.cancel();
            return;
        }
        this.field_2018 = class_2561.method_43470((String)formatted).method_10862(overlayStyle);
        this.field_2041 = 60;
        ci.cancel();
    }

    @ModifyArg(method={"renderOverlayMessage"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;drawTextWithBackground(Lnet/minecraft/client/font/TextRenderer;Lnet/minecraft/text/Text;IIII)I"), index=3)
    private int modifyOverlayMessageY(int originalY) {
        int yOffset = ModConfig.getConfig().playerXPConfig.overlayMessageYOffset;
        return originalY + yOffset;
    }

    @ModifyArg(method={"renderExperienceLevel"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;drawText(Lnet/minecraft/client/font/TextRenderer;Ljava/lang/String;IIIZ)I"), index=1)
    private String modifyLevelText(String original) {
        if (!ModConfig.getConfig().playerLevelConfig.enabled) {
            return original;
        }
        try {
            int level = Integer.parseInt(original);
            return Util.formatLevel(level);
        }
        catch (Exception e) {
            return original;
        }
    }

    @ModifyArg(method={"renderExperienceLevel"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;drawText(Lnet/minecraft/client/font/TextRenderer;Ljava/lang/String;IIIZ)I"), index=4)
    private int modifyLevelColor(int originalColor) {
        if (ModConfig.getConfig().playerLevelConfig.formattedPlayerLevelColor == null) {
            return originalColor;
        }
        if (originalColor == 0) {
            return originalColor;
        }
        return ModConfig.getConfig().playerLevelConfig.formattedPlayerLevelColor.color;
    }
}

