/*
 * Decompiled with CFR 0.152.
 */
package dev.eposs.elementsutils.rendering;

import dev.eposs.elementsutils.config.ModConfig;
import dev.eposs.elementsutils.rendering.Position;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;

@Environment(value=EnvType.CLIENT)
public class ScreenPositioning {
    public static int PET_WIDTH = 64;
    public static final int PET_HEIGHT = 32;
    public static final int IMAGE_SIZE = 16;
    public static final int GAP = 4;

    public static Position getMoonPhasePosition(class_1041 window) {
        ModConfig.Position displayPosition = ModConfig.getConfig().displayPosition;
        int xOffset = 0;
        int yOffset = 0;
        if (ModConfig.getConfig().showTimeDisplay) {
            xOffset += 20;
        }
        if (ModConfig.getConfig().showPetDisplay) {
            yOffset += 36;
        }
        return ScreenPositioning.getPosition(window, displayPosition, xOffset, yOffset);
    }

    public static Position getTimePosition(class_1041 window) {
        ModConfig.Position displayPosition = ModConfig.getConfig().displayPosition;
        int xOffset = 0;
        int yOffset = 0;
        if (ModConfig.getConfig().showPetDisplay) {
            yOffset += 36;
        }
        return ScreenPositioning.getPosition(window, displayPosition, xOffset, yOffset);
    }

    public static Position getPetPosition(class_1041 window) {
        ModConfig.Position displayPosition = ModConfig.getConfig().displayPosition;
        int xOffset = window.method_4486() - PET_WIDTH;
        int yOffset = window.method_4502() - 32;
        switch (displayPosition) {
            case TOP_LEFT: {
                return new Position(0, 0);
            }
            case TOP_RIGHT: {
                return new Position(xOffset, 0);
            }
            case BOTTOM_LEFT: {
                return new Position(0, yOffset);
            }
            case BOTTOM_RIGHT: {
                return new Position(xOffset, yOffset);
            }
        }
        return new Position(0, 0);
    }

    private static Position getPosition(class_1041 window, ModConfig.Position displayPosition, int xOffset, int yOffset) {
        switch (displayPosition) {
            case TOP_LEFT: {
                return new Position(xOffset, yOffset);
            }
            case TOP_RIGHT: {
                return new Position(window.method_4486() - 16 - xOffset, yOffset);
            }
            case BOTTOM_LEFT: {
                return new Position(xOffset, window.method_4502() - 16 - yOffset);
            }
            case BOTTOM_RIGHT: {
                return new Position(window.method_4486() - 16 - xOffset, window.method_4502() - 16 - yOffset);
            }
        }
        return new Position(0, 0);
    }
}

