/*
 * Decompiled with CFR 0.152.
 */
package dev.eposs.elementsutils.util;

import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class TimerUtil {
    public static final DateTimeFormatter ABSOLUTE_TIME_FORMATTER = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm");

    @Nullable
    public static ZonedDateTime parseTime(String time) {
        if (time == null || time.isEmpty()) {
            return null;
        }
        ZonedDateTime zonedDateTime = ZonedDateTime.parse(time);
        return zonedDateTime.isBefore(ZonedDateTime.ofInstant(Instant.EPOCH, zonedDateTime.getZone())) ? null : zonedDateTime;
    }

    public static Duration getDuration(ZonedDateTime time) {
        return Duration.between(time, ZonedDateTime.now());
    }

    @NotNull
    public static String toRelativeTime(@NotNull Duration duration) {
        String timeString;
        long days = duration.toDays();
        duration = duration.minusDays(days);
        long hours = duration.toHours();
        duration = duration.minusHours(hours);
        long minutes = duration.toMinutes();
        StringBuilder sb = new StringBuilder();
        if (days > 0L) {
            sb.append(days).append("d ");
        }
        if (hours > 0L) {
            sb.append(hours).append("h ");
        }
        if (minutes > 0L) {
            sb.append(minutes).append("m ");
        }
        if ((timeString = sb.toString().trim()).isEmpty()) {
            timeString = "0m";
        }
        return timeString;
    }

    public static class_5250 optionalFormattedText(class_5250 text, boolean enabled, class_124 format) {
        return enabled ? text.method_27692(format) : text;
    }

    public static void drawText(class_310 client, class_332 context, int line, class_2561 text, boolean outline) {
        Objects.requireNonNull(client.field_1772);
        int lineHeight = 9 + 3;
        context.method_51439(client.field_1772, text, 4, client.method_22683().method_4502() / 2 - lineHeight * 3 + lineHeight * line, -1, outline);
    }
}

