/*
 * Decompiled with CFR 0.152.
 */
package com.flooferland.ttvoice.speech;

import com.flooferland.ttvoice.TextToVoiceClient;
import com.flooferland.ttvoice.data.ModState;
import com.flooferland.ttvoice.data.TextToVoiceConfig;
import com.flooferland.ttvoice.speech.EspeakSpeaker;
import com.flooferland.ttvoice.speech.ISpeaker;
import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Mixer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u00002\u00020\u0001:\u0004/012B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J!\u0010\u0015\u001a\u00020\u00062\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00060\u0012\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0018\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000f\u0010\u001e\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u0019\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010 \u001a\u0004\b!\u0010\"R\u001c\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000e0#8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b$\u0010%R(\u0010&\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00060\u00120#8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b&\u0010%R\u0018\u0010'\u001a\u0004\u0018\u00010\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b'\u0010(R$\u0010)\u001a\u0004\u0018\u00010\t8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.\u00a8\u00063"}, d2={"Lcom/flooferland/ttvoice/speech/SpeechThread;", "Ljava/lang/Thread;", "Lcom/flooferland/ttvoice/speech/ISpeaker$WorldContext;", "context", "<init>", "(Lcom/flooferland/ttvoice/speech/ISpeaker$WorldContext;)V", "", "run", "()V", "", "text", "Lcom/flooferland/ttvoice/speech/ISpeaker$Status;", "speak", "(Ljava/lang/String;)Lcom/flooferland/ttvoice/speech/ISpeaker$Status;", "Lcom/flooferland/ttvoice/speech/SpeechThread$ICommand;", "command", "send", "(Lcom/flooferland/ttvoice/speech/SpeechThread$ICommand;)V", "Lkotlin/Function1;", "Lcom/flooferland/ttvoice/speech/ISpeaker$Status$Failure;", "callback", "onError", "(Lkotlin/jvm/functions/Function1;)V", "", "isSpeaking", "()Ljava/lang/Boolean;", "error", "emitError", "(Lcom/flooferland/ttvoice/speech/ISpeaker$Status$Failure;)V", "Lcom/flooferland/ttvoice/speech/ISpeaker;", "spawnBackend", "()Lcom/flooferland/ttvoice/speech/ISpeaker;", "Lcom/flooferland/ttvoice/speech/ISpeaker$WorldContext;", "getContext", "()Lcom/flooferland/ttvoice/speech/ISpeaker$WorldContext;", "Ljava/util/concurrent/LinkedBlockingQueue;", "queue", "Ljava/util/concurrent/LinkedBlockingQueue;", "errorQueue", "speaker", "Lcom/flooferland/ttvoice/speech/ISpeaker;", "defaultVoice", "Ljava/lang/String;", "getDefaultVoice", "()Ljava/lang/String;", "setDefaultVoice", "(Ljava/lang/String;)V", "ICommand", "SpeakCommand", "ShutUpCommand", "StopThreadCommand", "ttvoice-1.21.1_client"})
@Environment(value=EnvType.CLIENT)
@SourceDebugExtension(value={"SMAP\nSpeechThread.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpeechThread.kt\ncom/flooferland/ttvoice/speech/SpeechThread\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,118:1\n1#2:119\n*E\n"})
public final class SpeechThread
extends Thread {
    @Nullable
    private final ISpeaker.WorldContext context;
    @NotNull
    private LinkedBlockingQueue<ICommand> queue;
    @NotNull
    private LinkedBlockingQueue<Function1<ISpeaker.Status.Failure, Unit>> errorQueue;
    @Nullable
    private ISpeaker speaker;
    @Nullable
    private String defaultVoice;

    public SpeechThread(@Nullable ISpeaker.WorldContext context) {
        this.context = context;
        this.queue = new LinkedBlockingQueue();
        this.errorQueue = new LinkedBlockingQueue();
    }

    @Nullable
    public final ISpeaker.WorldContext getContext() {
        return this.context;
    }

    @Nullable
    public final String getDefaultVoice() {
        return this.defaultVoice;
    }

    public final void setDefaultVoice(@Nullable String string) {
        this.defaultVoice = string;
    }

    @Override
    public void run() {
        block9: {
            Object object;
            Object backend = this.spawnBackend().load-IoAF18A(this.context);
            Object object2 = backend;
            if (Result.isSuccess-impl((Object)object2)) {
                ISpeaker backend2 = (ISpeaker)object2;
                boolean bl = false;
                this.speaker = backend2;
                if (this.speaker instanceof EspeakSpeaker) {
                    ISpeaker iSpeaker = this.speaker;
                    Intrinsics.checkNotNull((Object)iSpeaker, (String)"null cannot be cast to non-null type com.flooferland.ttvoice.speech.EspeakSpeaker");
                    this.defaultVoice = ((EspeakSpeaker)iSpeaker).getDefaultVoice();
                }
            }
            object2 = backend;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                object = throwable;
                Throwable err = object;
                boolean bl = false;
                this.emitError(new ISpeaker.Status.Failure(ISpeaker.StatusType.Internal, err.toString()));
                return;
            }
            while (true) {
                ICommand task;
                if ((object = (task = this.queue.take())) instanceof SpeakCommand) {
                    ISpeaker.Status status;
                    if (((SpeakCommand)task).getMonophonic()) {
                        ISpeaker iSpeaker = this.speaker;
                        if (iSpeaker != null) {
                            iSpeaker.shutUp();
                        }
                    }
                    if (!((status = this.speak(((SpeakCommand)task).getText())) instanceof ISpeaker.Status.Failure)) continue;
                    this.emitError((ISpeaker.Status.Failure)status);
                    continue;
                }
                if (object instanceof ShutUpCommand) {
                    ISpeaker iSpeaker = this.speaker;
                    if (iSpeaker != null) {
                        iSpeaker.shutUp();
                    }
                    continue;
                }
                if (object instanceof StopThreadCommand) break;
            }
            ISpeaker iSpeaker = this.speaker;
            if (iSpeaker == null) break block9;
            iSpeaker.unload();
        }
    }

    private final ISpeaker.Status speak(String text) {
        Object result;
        Object $this$speak_u24lambda_u241;
        if (ModState.INSTANCE.getConfig().getGeneral().getRouteThroughDevice()) {
            int selectedMixer = -1;
            Mixer.Info[] allMixers = AudioSystem.getMixerInfo();
            int n = allMixers.length;
            for (int i = 0; i < n; ++i) {
                if (i != ModState.INSTANCE.getConfig().getAudio().getDevice()) continue;
                selectedMixer = i;
                break;
            }
            if (selectedMixer == -1) {
                return new ISpeaker.Status.Failure(ISpeaker.StatusType.NoOutputDevice, "Selected mixer doesn't exist");
            }
        }
        TextToVoiceConfig.GeneralConfig it = ModState.INSTANCE.getConfig().getGeneral();
        boolean bl = false;
        if (!(it.getRouteThroughVoiceChat() || it.getRouteThroughDevice())) {
            return new ISpeaker.Status.Failure(ISpeaker.StatusType.NoOutputDevice, "No output set. Make sure to route through at least one output in the mod config");
        }
        if (this.speaker == null) {
            return new ISpeaker.Status.Failure(ISpeaker.StatusType.Internal, "No speaker was never initialized (speaker == null)");
        }
        Object object = this;
        try {
            $this$speak_u24lambda_u241 = object;
            boolean bl2 = false;
            ISpeaker iSpeaker = ((SpeechThread)$this$speak_u24lambda_u241).speaker;
            $this$speak_u24lambda_u241 = Result.constructor-impl((Object)(iSpeaker != null ? iSpeaker.speak(text) : null));
        }
        catch (Throwable bl2) {
            $this$speak_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
        }
        object = result = $this$speak_u24lambda_u241;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Object err = $this$speak_u24lambda_u241 = throwable;
            boolean bl3 = false;
            return new ISpeaker.Status.Failure(ISpeaker.StatusType.Internal, String.valueOf(((Throwable)err).getMessage()));
        }
        object = result;
        if (Result.isSuccess-impl((Object)object)) {
            ISpeaker.Status info = (ISpeaker.Status)object;
            boolean bl4 = false;
            return new ISpeaker.Status.Success();
        }
        return new ISpeaker.Status.Failure(ISpeaker.StatusType.Internal, "Unknown; Did not succeed");
    }

    public final void send(@NotNull ICommand command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        this.queue.add(command);
    }

    public final void onError(@NotNull Function1<? super ISpeaker.Status.Failure, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.errorQueue.add(callback);
    }

    @Nullable
    public final Boolean isSpeaking() {
        ISpeaker iSpeaker = this.speaker;
        return iSpeaker != null ? Boolean.valueOf(iSpeaker.isSpeaking()) : null;
    }

    private final void emitError(ISpeaker.Status.Failure error) {
        if (!((Collection)this.errorQueue).isEmpty()) {
            Function1<ISpeaker.Status.Failure, Unit> callback = this.errorQueue.take();
            callback.invoke((Object)error);
            TextToVoiceClient.Companion.getLOGGER().error("Error " + error.getType() + " in speech thread: " + error.getContext());
        }
    }

    private final ISpeaker spawnBackend() {
        if (WhenMappings.$EnumSwitchMapping$0[ModState.INSTANCE.getConfig().getAudio().getTtsBackend().ordinal()] != 1) {
            throw new NoWhenBranchMatchedException();
        }
        return new EspeakSpeaker();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\bf\u0018\u00002\u00020\u0001\u00a8\u0006\u0002\u00c0\u0006\u0003"}, d2={"Lcom/flooferland/ttvoice/speech/SpeechThread$ICommand;", "", "ttvoice-1.21.1_client"})
    @Environment(value=EnvType.CLIENT)
    public static interface ICommand {
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/flooferland/ttvoice/speech/SpeechThread$ShutUpCommand;", "Lcom/flooferland/ttvoice/speech/SpeechThread$ICommand;", "<init>", "()V", "ttvoice-1.21.1_client"})
    @Environment(value=EnvType.CLIENT)
    public static final class ShutUpCommand
    implements ICommand {
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ$\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0010\u001a\u00020\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\tR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0016\u001a\u0004\b\u0017\u0010\tR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0018\u001a\u0004\b\u0019\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/flooferland/ttvoice/speech/SpeechThread$SpeakCommand;", "Lcom/flooferland/ttvoice/speech/SpeechThread$ICommand;", "", "text", "", "monophonic", "<init>", "(Ljava/lang/String;Z)V", "component1", "()Ljava/lang/String;", "component2", "()Z", "copy", "(Ljava/lang/String;Z)Lcom/flooferland/ttvoice/speech/SpeechThread$SpeakCommand;", "", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/lang/String;", "getText", "Z", "getMonophonic", "ttvoice-1.21.1_client"})
    @Environment(value=EnvType.CLIENT)
    public static final class SpeakCommand
    implements ICommand {
        @NotNull
        private final String text;
        private final boolean monophonic;

        public SpeakCommand(@NotNull String text, boolean monophonic) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.text = text;
            this.monophonic = monophonic;
        }

        public /* synthetic */ SpeakCommand(String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = false;
            }
            this(string, bl);
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        public final boolean getMonophonic() {
            return this.monophonic;
        }

        @NotNull
        public final String component1() {
            return this.text;
        }

        public final boolean component2() {
            return this.monophonic;
        }

        @NotNull
        public final SpeakCommand copy(@NotNull String text, boolean monophonic) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return new SpeakCommand(text, monophonic);
        }

        public static /* synthetic */ SpeakCommand copy$default(SpeakCommand speakCommand, String string, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = speakCommand.text;
            }
            if ((n & 2) != 0) {
                bl = speakCommand.monophonic;
            }
            return speakCommand.copy(string, bl);
        }

        @NotNull
        public String toString() {
            return "SpeakCommand(text=" + this.text + ", monophonic=" + this.monophonic + ")";
        }

        public int hashCode() {
            int result = this.text.hashCode();
            result = result * 31 + Boolean.hashCode(this.monophonic);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SpeakCommand)) {
                return false;
            }
            SpeakCommand speakCommand = (SpeakCommand)other;
            if (!Intrinsics.areEqual((Object)this.text, (Object)speakCommand.text)) {
                return false;
            }
            return this.monophonic == speakCommand.monophonic;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/flooferland/ttvoice/speech/SpeechThread$StopThreadCommand;", "Lcom/flooferland/ttvoice/speech/SpeechThread$ICommand;", "<init>", "()V", "ttvoice-1.21.1_client"})
    @Environment(value=EnvType.CLIENT)
    public static final class StopThreadCommand
    implements ICommand {
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    @Environment(value=EnvType.CLIENT)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TextToVoiceConfig.TTSBackend.values().length];
            try {
                nArray[TextToVoiceConfig.TTSBackend.Espeak.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

