/*
 * Decompiled with CFR 0.152.
 */
package com.flooferland.ttvoice.data;

import com.flooferland.ttvoice.speech.EspeakSpeaker;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0017\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u000b\u0018\u00002\u00020\u0001:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000b\u0010\fR(\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\"\u0010\u0016\u001a\u00020\u00158\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\"\u0010\u001c\u001a\u00020\u00158\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u0017\u001a\u0004\b\u001d\u0010\u0019\"\u0004\b\u001e\u0010\u001b\u00a8\u0006 "}, d2={"Lcom/flooferland/ttvoice/data/AudioScheduler;", "", "<init>", "()V", "", "frame", "", "pushFrame", "([S)V", "next", "()[S", "padFrame", "([S)[S", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "Lcom/flooferland/ttvoice/data/AudioScheduler$TimedFrame;", "queue", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "getQueue", "()Ljava/util/concurrent/ConcurrentLinkedDeque;", "setQueue", "(Ljava/util/concurrent/ConcurrentLinkedDeque;)V", "", "lastFrameTime", "J", "getLastFrameTime", "()J", "setLastFrameTime", "(J)V", "frameIndex", "getFrameIndex", "setFrameIndex", "TimedFrame", "ttvoice_client"})
@Environment(value=EnvType.CLIENT)
@SourceDebugExtension(value={"SMAP\nAudioScheduler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AudioScheduler.kt\ncom/flooferland/ttvoice/data/AudioScheduler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n1#2:67\n295#3,2:68\n*S KotlinDebug\n*F\n+ 1 AudioScheduler.kt\ncom/flooferland/ttvoice/data/AudioScheduler\n*L\n37#1:68,2\n*E\n"})
public final class AudioScheduler {
    @NotNull
    private ConcurrentLinkedDeque<TimedFrame> queue = new ConcurrentLinkedDeque();
    private long lastFrameTime;
    private long frameIndex;

    @NotNull
    public final ConcurrentLinkedDeque<TimedFrame> getQueue() {
        return this.queue;
    }

    public final void setQueue(@NotNull ConcurrentLinkedDeque<TimedFrame> concurrentLinkedDeque) {
        Intrinsics.checkNotNullParameter(concurrentLinkedDeque, (String)"<set-?>");
        this.queue = concurrentLinkedDeque;
    }

    public final long getLastFrameTime() {
        return this.lastFrameTime;
    }

    public final void setLastFrameTime(long l) {
        this.lastFrameTime = l;
    }

    public final long getFrameIndex() {
        return this.frameIndex;
    }

    public final void setFrameIndex(long l) {
        this.frameIndex = l;
    }

    public final synchronized void pushFrame(@NotNull short[] frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        short[] paddedFrame = frame.length != 960 ? this.padFrame(frame) : frame;
        this.queue.add(new TimedFrame(paddedFrame, System.nanoTime(), null, 4, null));
        while (this.queue.size() > 50) {
            this.queue.pollFirst();
        }
    }

    @Nullable
    public final synchronized short[] next() {
        Object v0;
        long now;
        block4: {
            now = System.nanoTime();
            EspeakSpeaker.Companion companion = EspeakSpeaker.Companion;
            long l = this.lastFrameTime;
            boolean bl = false;
            int n = 19;
            long expectedTime = l + (long)n;
            if (this.lastFrameTime > 0L && now < expectedTime) {
                return null;
            }
            Iterable $this$firstOrNull$iv = this.queue;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                TimedFrame it = (TimedFrame)element$iv;
                boolean bl2 = false;
                if (!(!it.getConsumed().get())) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        TimedFrame frame = v0;
        if (frame != null) {
            frame.getConsumed().set(true);
            this.lastFrameTime = now;
            long l = this.frameIndex;
            this.frameIndex = l + 1L;
            while (!((Collection)this.queue).isEmpty()) {
                Object object = this.queue.peekFirst();
                boolean bl = object != null && (object = ((TimedFrame)object).getConsumed()) != null ? ((AtomicBoolean)object).get() : false;
                if (!bl) break;
                this.queue.pollFirst();
            }
            return frame.getFrame();
        }
        return null;
    }

    private final short[] padFrame(short[] frame) {
        if (frame.length == 960) {
            return frame;
        }
        short[] output = new short[960];
        double ratio = (double)frame.length / 960.0;
        int n = output.length;
        for (int i = 0; i < n; ++i) {
            int sourceIndex = (int)((double)i * ratio);
            output[i] = sourceIndex < frame.length ? frame[sourceIndex] : (short)0;
        }
        return output;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0017\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ.\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010\u0014\u001a\u00020\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0017\u001a\u00020\u0016H\u00d6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u001a\u001a\u00020\u0019H\u00d6\u0001\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001c\u001a\u0004\b\u001d\u0010\u000bR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001e\u001a\u0004\b\u001f\u0010\rR\"\u0010\u0007\u001a\u00020\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0007\u0010 \u001a\u0004\b!\u0010\u000f\"\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Lcom/flooferland/ttvoice/data/AudioScheduler$TimedFrame;", "", "", "frame", "", "timestampNs", "Ljava/util/concurrent/atomic/AtomicBoolean;", "consumed", "<init>", "([SJLjava/util/concurrent/atomic/AtomicBoolean;)V", "component1", "()[S", "component2", "()J", "component3", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "copy", "([SJLjava/util/concurrent/atomic/AtomicBoolean;)Lcom/flooferland/ttvoice/data/AudioScheduler$TimedFrame;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "[S", "getFrame", "J", "getTimestampNs", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getConsumed", "setConsumed", "(Ljava/util/concurrent/atomic/AtomicBoolean;)V", "ttvoice_client"})
    @Environment(value=EnvType.CLIENT)
    public static final class TimedFrame {
        @NotNull
        private final short[] frame;
        private final long timestampNs;
        @NotNull
        private AtomicBoolean consumed;

        public TimedFrame(@NotNull short[] frame, long timestampNs, @NotNull AtomicBoolean consumed) {
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            Intrinsics.checkNotNullParameter((Object)consumed, (String)"consumed");
            this.frame = frame;
            this.timestampNs = timestampNs;
            this.consumed = consumed;
        }

        public /* synthetic */ TimedFrame(short[] sArray, long l, AtomicBoolean atomicBoolean, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                atomicBoolean = new AtomicBoolean(false);
            }
            this(sArray, l, atomicBoolean);
        }

        @NotNull
        public final short[] getFrame() {
            return this.frame;
        }

        public final long getTimestampNs() {
            return this.timestampNs;
        }

        @NotNull
        public final AtomicBoolean getConsumed() {
            return this.consumed;
        }

        public final void setConsumed(@NotNull AtomicBoolean atomicBoolean) {
            Intrinsics.checkNotNullParameter((Object)atomicBoolean, (String)"<set-?>");
            this.consumed = atomicBoolean;
        }

        @NotNull
        public final short[] component1() {
            return this.frame;
        }

        public final long component2() {
            return this.timestampNs;
        }

        @NotNull
        public final AtomicBoolean component3() {
            return this.consumed;
        }

        @NotNull
        public final TimedFrame copy(@NotNull short[] frame, long timestampNs, @NotNull AtomicBoolean consumed) {
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            Intrinsics.checkNotNullParameter((Object)consumed, (String)"consumed");
            return new TimedFrame(frame, timestampNs, consumed);
        }

        public static /* synthetic */ TimedFrame copy$default(TimedFrame timedFrame, short[] sArray, long l, AtomicBoolean atomicBoolean, int n, Object object) {
            if ((n & 1) != 0) {
                sArray = timedFrame.frame;
            }
            if ((n & 2) != 0) {
                l = timedFrame.timestampNs;
            }
            if ((n & 4) != 0) {
                atomicBoolean = timedFrame.consumed;
            }
            return timedFrame.copy(sArray, l, atomicBoolean);
        }

        @NotNull
        public String toString() {
            return "TimedFrame(frame=" + Arrays.toString(this.frame) + ", timestampNs=" + this.timestampNs + ", consumed=" + this.consumed + ")";
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.frame);
            result = result * 31 + Long.hashCode(this.timestampNs);
            result = result * 31 + this.consumed.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TimedFrame)) {
                return false;
            }
            TimedFrame timedFrame = (TimedFrame)other;
            if (!Intrinsics.areEqual((Object)this.frame, (Object)timedFrame.frame)) {
                return false;
            }
            if (this.timestampNs != timedFrame.timestampNs) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.consumed, (Object)timedFrame.consumed);
        }
    }
}

