/*
 * Decompiled with CFR 0.152.
 */
package com.flooferland.ttvoice.speech;

import com.flooferland.espeak.Espeak;
import com.flooferland.ttvoice.TextToVoiceClient;
import com.flooferland.ttvoice.data.ModState;
import com.flooferland.ttvoice.screen.ConfigScreen;
import com.flooferland.ttvoice.screen.SelectDeviceScreen;
import com.flooferland.ttvoice.speech.ISpeaker;
import com.flooferland.ttvoice.speech.SpeechThread;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\u0006J\u0017\u0010\u000b\u001a\u00020\n2\b\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\r\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u0003J\u001f\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0011\u0010\u0012J\r\u0010\u0013\u001a\u00020\n\u00a2\u0006\u0004\b\u0013\u0010\u0003J\u0013\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J\r\u0010\u0018\u001a\u00020\n\u00a2\u0006\u0004\b\u0018\u0010\u0003J\r\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0019\u0010\u0006J\r\u0010\u001a\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001a\u0010\u0006J\u0019\u0010\u001c\u001a\u00020\n2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001e\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u0018\u0010!\u001a\u0004\u0018\u00010 8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010\"\u00a8\u0006#"}, d2={"Lcom/flooferland/ttvoice/speech/SpeechUtil;", "", "<init>", "()V", "", "isInitialized", "()Z", "isNotInitialized", "Lcom/flooferland/ttvoice/speech/ISpeaker$WorldContext;", "context", "", "load", "(Lcom/flooferland/ttvoice/speech/ISpeaker$WorldContext;)V", "unload", "", "text", "monophonic", "speak", "(Ljava/lang/String;Z)V", "shutUp", "", "Lcom/flooferland/espeak/Espeak$Voice;", "getVoices", "()Ljava/util/List;", "playTest", "isTestingArmed", "isSpeaking", "id", "updateVoice", "(Ljava/lang/String;)V", "getVoice", "()Lcom/flooferland/espeak/Espeak$Voice;", "Lcom/flooferland/ttvoice/speech/SpeechThread;", "thread", "Lcom/flooferland/ttvoice/speech/SpeechThread;", "ttvoice_client"})
@Environment(value=EnvType.CLIENT)
public final class SpeechUtil {
    @NotNull
    public static final SpeechUtil INSTANCE = new SpeechUtil();
    @Nullable
    private static SpeechThread thread;

    private SpeechUtil() {
    }

    public final boolean isInitialized() {
        return thread != null;
    }

    public final boolean isNotInitialized() {
        return thread == null;
    }

    public final void load(@Nullable ISpeaker.WorldContext context) {
        block1: {
            if (this.isInitialized()) {
                return;
            }
            SpeechThread speechThread = thread = new SpeechThread(context);
            if (speechThread == null) break block1;
            speechThread.start();
        }
    }

    public final void unload() {
        SpeechThread speechThread = thread;
        if (speechThread != null) {
            speechThread.send(new SpeechThread.StopThreadCommand());
        }
        thread = null;
    }

    public final void speak(@NotNull String text, boolean monophonic) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            if (thread == null) {
                TextToVoiceClient.Companion.getLOGGER().warn("speak was called, but the audio thread was not created");
                return;
            }
            SpeechThread speechThread = thread;
            if (speechThread != null) {
                speechThread.send(new SpeechThread.SpeakCommand(text, monophonic));
            }
            SpeechThread speechThread2 = thread;
            if (speechThread2 == null) break block2;
            speechThread2.onError((Function1<? super ISpeaker.Status.Failure, Unit>)((Function1)SpeechUtil::speak$lambda$0));
        }
    }

    public static /* synthetic */ void speak$default(SpeechUtil speechUtil, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        speechUtil.speak(string, bl);
    }

    public final void shutUp() {
        block0: {
            SpeechThread speechThread = thread;
            if (speechThread == null) break block0;
            speechThread.send(new SpeechThread.ShutUpCommand());
        }
    }

    @NotNull
    public final List<Espeak.Voice> getVoices() {
        if (this.isNotInitialized()) {
            TextToVoiceClient.Companion.getLOGGER().warn("getVoices called but eSpeak was not initialized. Returning an empty array");
            return CollectionsKt.emptyList();
        }
        return Espeak.INSTANCE.listVoices();
    }

    public final void playTest() {
        if (!this.isTestingArmed()) {
            TextToVoiceClient.Companion.getLOGGER().warn("playTest was called, but audio testing was not armed");
            return;
        }
        this.speak("Audio test", true);
    }

    public final boolean isTestingArmed() {
        class_437 screen = class_310.method_1551().field_1755;
        return screen instanceof SelectDeviceScreen || screen instanceof ConfigScreen;
    }

    public final boolean isSpeaking() {
        Object object = thread;
        return object != null && (object = ((SpeechThread)object).isSpeaking()) != null ? (Boolean)object : false;
    }

    public final void updateVoice(@Nullable String id) {
        String voice;
        String string = id;
        if (string == null) {
            SpeechThread speechThread = thread;
            string = speechThread != null ? speechThread.getDefaultVoice() : null;
        }
        if ((voice = string) != null) {
            Espeak.INSTANCE.setVoice(voice);
        } else {
            TextToVoiceClient.Companion.getLOGGER().warn("Unable to get a new voice to update with");
        }
    }

    public static /* synthetic */ void updateVoice$default(SpeechUtil speechUtil, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = ModState.INSTANCE.getConfig().getVoice().getEspeak().getName();
        }
        speechUtil.updateVoice(string);
    }

    @Nullable
    public final Espeak.Voice getVoice() {
        return Espeak.INSTANCE.getVoice();
    }

    private static final Unit speak$lambda$0(ISpeaker.Status.Failure err) {
        block0: {
            class_746 player;
            Intrinsics.checkNotNullParameter((Object)err, (String)"err");
            class_746 class_7462 = player = class_310.method_1551().field_1724;
            if (class_7462 == null) break block0;
            class_7462.method_7353((class_2561)class_2561.method_43470((String)("Text-To-Voice Error " + err.getType() + ":\n    " + err.getContext())).method_27692(class_124.field_1061), false);
        }
        return Unit.INSTANCE;
    }
}

