/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.block;

import de.mrjulsen.paw.block.abstractions.AbstractCantileverBlock;
import de.mrjulsen.paw.block.property.EInsulatorType;
import de.mrjulsen.paw.blockentity.CantileverBlockEntity;
import de.mrjulsen.paw.item.CantileverBlockItem;
import de.mrjulsen.paw.registry.ModBlocks;
import de.mrjulsen.wires.item.CustomData;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class CantileverBlock
extends AbstractCantileverBlock {
    private final EInsulatorType insulatorType;

    public CantileverBlock(BlockBehaviour.Properties properties, EInsulatorType insulatorType) {
        super(properties.m_60910_());
        this.insulatorType = insulatorType;
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)ModBlocks.CANTILEVER_ITEMS.get((Object)this.insulatorType));
    }

    public EInsulatorType getInsulatorType() {
        return this.insulatorType;
    }

    @Override
    public Vec3 defaultWireAttachPoint(Level level, BlockPos pos, BlockState state, CustomData customData, int index) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CantileverBlockEntity) {
            CantileverBlockEntity be = (CantileverBlockEntity)blockEntity;
            int idx = 0;
            if (customData.hasPoint(index)) {
                idx = customData.getCustomDataForPoint(index).m_128451_("CantileverIndex");
            }
            CantileverBlockEntity.CantileverData data = be.getCantileverData()[idx];
            float size = data.width();
            float height = data.catenaryHeight();
            float xOffset = data.z();
            return switch (be.getRegistrationArmType()) {
                case AbstractCantileverBlock.ECantileverRegistrationArmType.OUTER -> new Vec3((double)(xOffset - 0.5f), (double)(-height), (double)(0.25f - size));
                case AbstractCantileverBlock.ECantileverRegistrationArmType.INNER -> new Vec3((double)(xOffset - 0.5f), (double)(-height), (double)(0.75f - size));
                default -> new Vec3((double)(xOffset - 0.5f), (double)(-height), (double)(0.5f - size));
            };
        }
        return Vec3.f_82478_;
    }

    @Override
    public Vec3 tensionWireAttachPoint(Level level, BlockPos pos, BlockState state, CustomData customData, int index) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CantileverBlockEntity) {
            CantileverBlockEntity be = (CantileverBlockEntity)blockEntity;
            int idx = 0;
            if (customData.hasPoint(index)) {
                idx = customData.getCustomDataForPoint(index).m_128451_("CantileverIndex");
            }
            CantileverBlockEntity.CantileverData data = be.getCantileverData()[idx];
            float size = data.width();
            float height = 0.6875f + data.frontYOffset();
            float xOffset = data.z();
            return switch (be.getRegistrationArmType()) {
                case AbstractCantileverBlock.ECantileverRegistrationArmType.OUTER -> new Vec3((double)(xOffset - 0.5f), (double)height, (double)(0.5f - size));
                case AbstractCantileverBlock.ECantileverRegistrationArmType.INNER -> new Vec3((double)(xOffset - 0.5f), (double)height, (double)(0.5f - size));
                default -> new Vec3((double)(xOffset - 0.5f), (double)height, (double)(0.5f - size));
            };
        }
        return Vec3.f_82478_;
    }

    @Override
    public boolean onAttachWireTo(Level level, BlockPos pos, BlockState state, Player player, Optional<UseOnContext> hit, CompoundTag pointData, int index) {
        return true;
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        return !useContext.m_7078_() && useContext.m_43722_().m_41720_() instanceof CantileverBlockItem ? true : super.m_6864_(state, useContext);
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = context.m_43725_().m_8055_(context.m_8083_());
        return blockstate.m_60713_((Block)this) ? blockstate : super.m_5573_(context);
    }
}

