/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.block;

import com.tterrag.registrate.util.entry.BlockEntry;
import de.mrjulsen.mcdragonlib.config.ECachingPriority;
import de.mrjulsen.mcdragonlib.data.MapCache;
import de.mrjulsen.paw.block.CantileverBracketVerticalBlock;
import de.mrjulsen.paw.block.abstractions.AbstractRotatedConnectableBlock;
import de.mrjulsen.paw.block.abstractions.IWeatheringBlock;
import de.mrjulsen.paw.block.extended.BlockPlaceContextExtension;
import de.mrjulsen.paw.registry.ModBlocks;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class CantileverBracketBaseBlock<T extends CantileverBracketBaseBlock<T>>
extends AbstractRotatedConnectableBlock
implements IWeatheringBlock<T> {
    private final MapCache<VoxelShape, BlockState, ShapeContext> shapeContext = new MapCache(c -> this.makeShape((ShapeContext)c), state -> Objects.hash(state.m_61148_().values().toArray(Object[]::new)), ECachingPriority.ALWAYS);
    protected final IWeatheringBlock.WeatherState weatherState;
    protected final Supplier<T> nextOxidationState;

    public CantileverBracketBaseBlock(BlockBehaviour.Properties properties, IWeatheringBlock.WeatherState weatherState, Supplier<T> nextOxidationState) {
        super(properties);
        this.weatherState = weatherState;
        this.nextOxidationState = nextOxidationState;
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)((BlockEntry)ModBlocks.CANTILEVER_BRACKET.get((Object)this.weatherState)).get());
    }

    protected VoxelShape makeShape(ShapeContext c) {
        double stretch = 16.0 * (1.0 / Math.cos(Math.abs(Math.toRadians(this.getRelativeYRotation(c.state())))) - 1.0);
        double halfStretch = stretch / 2.0;
        return switch ((Direction)c.state().m_61143_((Property)FACING)) {
            case Direction.SOUTH -> Block.m_49796_((double)6.0, (double)6.0, (double)(0.0 - halfStretch), (double)10.0, (double)10.0, (double)(16.0 + halfStretch));
            case Direction.WEST -> Block.m_49796_((double)(0.0 - halfStretch), (double)6.0, (double)6.0, (double)(16.0 + halfStretch), (double)10.0, (double)10.0);
            case Direction.EAST -> Block.m_49796_((double)(0.0 - halfStretch), (double)6.0, (double)6.0, (double)(16.0 + halfStretch), (double)10.0, (double)10.0);
            default -> Block.m_49796_((double)6.0, (double)6.0, (double)(0.0 - halfStretch), (double)10.0, (double)10.0, (double)(16.0 + halfStretch));
        };
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPlaceContextExtension ctxExt = (BlockPlaceContextExtension)context;
        BlockState state = super.m_5573_(context);
        BlockState clickedOnState = ctxExt.getPlacedOnState();
        Direction clickedFace = context.m_43719_();
        if ((clickedOnState.m_60734_() instanceof CantileverBracketBaseBlock || clickedOnState.m_60734_() instanceof CantileverBracketVerticalBlock) && clickedFace.m_122434_().m_122478_()) {
            state = (BlockState)((BlockState)((BlockState)((BlockEntry)ModBlocks.CANTILEVER_BRACKET_VERTICAL.get((Object)this.weatherState)).getDefaultState().m_61124_((Property)CantileverBracketVerticalBlock.DIRECTION, (Comparable)clickedFace)).m_61124_((Property)FACING, (Comparable)((Direction)clickedOnState.m_61143_((Property)FACING)))).m_61124_((Property)ROTATION, (Comparable)((Integer)clickedOnState.m_61143_((Property)ROTATION)));
        }
        return state;
    }

    @Override
    protected boolean canConnect(Level level, BlockState state, BlockPos pos, BlockState otherState, BlockPos otherPos) {
        return otherState.m_60734_() instanceof CantileverBracketBaseBlock;
    }

    @Override
    public VoxelShape getBaseShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.shapeContext.get((Object)new ShapeContext(level, pos, state, context), (Object)state);
    }

    @Override
    public Direction.Axis transformOnAxis(BlockState state) {
        return ((Direction)state.m_61143_((Property)FACING)).m_122434_();
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        this.m_220947_(state, level, pos, random);
    }

    public boolean m_6724_(BlockState state) {
        return this.getNext(state.m_60734_()).isPresent();
    }

    public IWeatheringBlock.WeatherState getAge() {
        return this.weatherState;
    }

    @Override
    public Supplier<T> getNextState() {
        return this.nextOxidationState;
    }

    protected record ShapeContext(BlockGetter level, BlockPos pos, BlockState state, CollisionContext context) {
    }
}

