/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.block;

import de.mrjulsen.mcdragonlib.data.MapCache;
import de.mrjulsen.paw.block.abstractions.AbstractMultipartPostBlock;
import de.mrjulsen.paw.block.abstractions.IHorizontalExtensionConnectable;
import de.mrjulsen.paw.block.abstractions.IWeatheringBlock;
import de.mrjulsen.paw.block.property.EPostPart;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FlatLatticeMastBlock
extends AbstractMultipartPostBlock
implements IWeatheringBlock<FlatLatticeMastBlock> {
    protected static final VoxelShape SHAPE_Z = Block.m_49796_((double)6.0, (double)0.0, (double)4.0, (double)10.0, (double)16.0, (double)12.0);
    protected static final VoxelShape SHAPE_X = Block.m_49796_((double)4.0, (double)0.0, (double)6.0, (double)12.0, (double)16.0, (double)10.0);
    protected static final VoxelShape SHAPE_FOUNDATION_Z = Block.m_49796_((double)4.0, (double)-4.0, (double)2.0, (double)12.0, (double)4.0, (double)14.0);
    protected static final VoxelShape SHAPE_FOUNDATION_X = Block.m_49796_((double)2.0, (double)-4.0, (double)4.0, (double)14.0, (double)4.0, (double)12.0);
    private final IWeatheringBlock.WeatherState weatherState;
    private final Supplier<FlatLatticeMastBlock> nextOxidationState;
    protected static final MapCache<VoxelShape, ShapeKey, ShapeKey> shapeCache = new MapCache(key -> {
        VoxelShape shape;
        VoxelShape voxelShape = shape = key.direction().m_122434_() == Direction.Axis.Z ? SHAPE_Z : SHAPE_X;
        if (key.isFoundation()) {
            shape = key.direction().m_122434_() == Direction.Axis.Z ? Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPE_FOUNDATION_Z) : Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPE_FOUNDATION_X);
        }
        return shape;
    }, ShapeKey::hashCode);

    public FlatLatticeMastBlock(BlockBehaviour.Properties properties, IWeatheringBlock.WeatherState weatherState, Supplier<FlatLatticeMastBlock> nextOxidationState) {
        super(properties.m_284180_(MapColor.f_283906_));
        this.weatherState = weatherState;
        this.nextOxidationState = nextOxidationState;
    }

    @Override
    public VoxelShape getBaseShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        ShapeKey key = new ShapeKey((Direction)state.m_61143_((Property)FACING), state.m_61143_((Property)PART) == EPostPart.BOTTOM);
        return (VoxelShape)shapeCache.get((Object)key, (Object)key);
    }

    @Override
    public IHorizontalExtensionConnectable.EPostType postConnectionType(LevelReader level, BlockState state, BlockPos pos, BlockState cantileverState, BlockPos cantileverPos) {
        return IHorizontalExtensionConnectable.EPostType.WALL;
    }

    @Override
    public boolean canCantileverConnect(BlockAndTintGetter level, BlockPos pos, BlockState state, Direction direction) {
        return direction.m_122434_() == ((Direction)state.m_61143_((Property)FACING)).m_122434_();
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        this.m_220947_(state, level, pos, random);
    }

    public boolean m_6724_(BlockState state) {
        return this.getNext(state.m_60734_()).isPresent();
    }

    public IWeatheringBlock.WeatherState getAge() {
        return this.weatherState;
    }

    @Override
    public Supplier<FlatLatticeMastBlock> getNextState() {
        return this.nextOxidationState;
    }

    protected record ShapeKey(Direction direction, boolean isFoundation) {
        @Override
        public final int hashCode() {
            return Objects.hash(this.direction(), this.isFoundation());
        }

        @Override
        public final boolean equals(Object other) {
            if (other instanceof ShapeKey) {
                ShapeKey o = (ShapeKey)other;
                return this.direction() == o.direction() && this.isFoundation() == o.isFoundation();
            }
            return false;
        }
    }
}

