/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.block;

import de.mrjulsen.mcdragonlib.config.ECachingPriority;
import de.mrjulsen.mcdragonlib.data.MapCache;
import de.mrjulsen.paw.block.AbstractPlaceableInsulatorBlock;
import de.mrjulsen.paw.block.PowerLineBracketBlock;
import de.mrjulsen.paw.util.ModMath;
import de.mrjulsen.wires.item.CustomData;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class InsulatorBlock
extends AbstractPlaceableInsulatorBlock {
    public static final EnumProperty<Half> HALF = BlockStateProperties.f_61402_;
    private static final VoxelShape SHAPE_BOTTOM = Block.m_49796_((double)5.0, (double)2.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape SHAPE_TOP = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0);
    private final MapCache<VoxelShape, TransformationShapeKeyExtension, TransformationShapeKeyExtension> shapesCache = new MapCache(key -> {
        VoxelShape baseShape = key.half() == Half.TOP ? SHAPE_TOP : SHAPE_BOTTOM;
        Direction direction = key.direction();
        VoxelShape result = ModMath.rotateShape(baseShape, Direction.Axis.Y, (int)direction.m_122424_().m_122435_());
        return result;
    }, TransformationShapeKeyExtension::hashCode, ECachingPriority.ALWAYS);

    public InsulatorBlock(BlockBehaviour.Properties properties) {
        super(properties.m_284180_(MapColor.f_283906_).m_60955_());
        this.m_49959_((BlockState)this.m_49966_().m_61124_(HALF, (Comparable)Half.TOP));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{HALF});
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos clickPos = context.m_8083_();
        Level level = context.m_43725_();
        BlockState state = super.m_5573_(context);
        BlockPos abovePos = clickPos.m_7494_();
        BlockState aboveState = level.m_8055_(abovePos);
        BlockPos belowPos = clickPos.m_7495_();
        BlockState belowState = level.m_8055_(belowPos);
        state = aboveState.m_60734_() instanceof PowerLineBracketBlock ? (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)MULTIPART_SEGMENT, (Comparable)((Integer)aboveState.m_61143_((Property)MULTIPART_SEGMENT)))).m_61124_((Property)FACING, (Comparable)((Direction)aboveState.m_61143_((Property)FACING)))).m_61124_((Property)ROTATION, (Comparable)((Integer)aboveState.m_61143_((Property)ROTATION)))).m_61124_(HALF, (Comparable)Half.BOTTOM) : (belowState.m_60734_() instanceof PowerLineBracketBlock ? (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)MULTIPART_SEGMENT, (Comparable)((Integer)belowState.m_61143_((Property)MULTIPART_SEGMENT)))).m_61124_((Property)FACING, (Comparable)((Direction)belowState.m_61143_((Property)FACING)))).m_61124_((Property)ROTATION, (Comparable)((Integer)belowState.m_61143_((Property)ROTATION)))).m_61124_(HALF, (Comparable)Half.TOP) : (BlockState)state.m_61124_(HALF, (Comparable)(context.m_43719_() == Direction.UP ? Half.TOP : Half.BOTTOM)));
        return state;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos abovePos = pos.m_7494_();
        BlockState aboveState = level.m_8055_(abovePos);
        BlockPos belowPos = pos.m_7495_();
        BlockState belowState = level.m_8055_(belowPos);
        return switch ((Half)state.m_61143_(HALF)) {
            case Half.TOP -> {
                if (InsulatorBlock.m_49863_((LevelReader)level, (BlockPos)belowPos, (Direction)Direction.UP) || belowState.m_60734_() instanceof PowerLineBracketBlock && belowState.m_61143_(PowerLineBracketBlock.HALF) == Half.TOP) {
                    yield true;
                }
                yield false;
            }
            default -> InsulatorBlock.m_49863_((LevelReader)level, (BlockPos)abovePos, (Direction)Direction.DOWN) || aboveState.m_60734_() instanceof PowerLineBracketBlock && aboveState.m_61143_(PowerLineBracketBlock.HALF) == Half.BOTTOM;
        };
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        return !this.m_7898_(state, (LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    @Override
    public VoxelShape getBaseShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        TransformationShapeKeyExtension key = new TransformationShapeKeyExtension((Direction)state.m_61143_((Property)FACING), InsulatorBlock.normalizedPropertyRotationIndex(state), (Half)state.m_61143_(HALF), state);
        return (VoxelShape)this.shapesCache.get((Object)key, (Object)key);
    }

    @Override
    public Vec3 defaultWireAttachPoint(Level level, BlockPos pos, BlockState state, CustomData itemData, int index) {
        return state.m_61143_(HALF) == Half.TOP ? new Vec3(0.0, 0.625, 0.0) : new Vec3(0.0, 0.1875, 0.0);
    }

    protected record TransformationShapeKeyExtension(Direction direction, int rotation, Half half, BlockState state) {
        @Override
        public final boolean equals(Object other) {
            if (other instanceof TransformationShapeKeyExtension) {
                TransformationShapeKeyExtension o = (TransformationShapeKeyExtension)other;
                return this.direction().equals((Object)o.direction()) && this.rotation() == o.rotation() && this.half() == o.half();
            }
            return false;
        }

        @Override
        public final int hashCode() {
            return Objects.hash(this.direction(), this.rotation(), this.half());
        }
    }
}

