/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.block;

import de.mrjulsen.mcdragonlib.config.ECachingPriority;
import de.mrjulsen.mcdragonlib.data.MapCache;
import de.mrjulsen.paw.block.abstractions.AbstractRotatedConnectableBlock;
import de.mrjulsen.paw.block.abstractions.IHorizontalExtensionConnectable;
import de.mrjulsen.paw.block.abstractions.IRotatableBlock;
import de.mrjulsen.paw.block.abstractions.IWeatheringBlock;
import de.mrjulsen.paw.block.extended.BlockPlaceContextExtension;
import de.mrjulsen.paw.data.BlockModificationData;
import de.mrjulsen.paw.util.ModMath;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PowerLineBracketBlock
extends AbstractRotatedConnectableBlock
implements IWeatheringBlock<PowerLineBracketBlock> {
    private static final VoxelShape DEFAULT_SHAPE = Block.m_49796_((double)6.5, (double)0.0, (double)0.0, (double)9.5, (double)3.0, (double)16.0);
    private static final Map<ShapeKey, VoxelShape> BASE_SHAPES = Map.ofEntries(Map.entry(new ShapeKey(IHorizontalExtensionConnectable.EPostType.FENCE, EConnectionType.ON_POST), Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)3.0, (double)11.0)), Map.entry(new ShapeKey(IHorizontalExtensionConnectable.EPostType.FENCE, EConnectionType.ON_POST_EXTENSION), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)5.0, (double)0.0, (double)16.0, (double)11.0, (double)3.0, (double)21.0), (VoxelShape)Block.m_49796_((double)6.5, (double)0.0, (double)0.0, (double)9.5, (double)3.0, (double)16.0))), Map.entry(new ShapeKey(IHorizontalExtensionConnectable.EPostType.FENCE, EConnectionType.AT_POST), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)5.0, (double)0.0, (double)16.0, (double)11.0, (double)3.0, (double)21.0), (VoxelShape)Block.m_49796_((double)6.5, (double)0.0, (double)0.0, (double)9.5, (double)3.0, (double)16.0))), Map.entry(new ShapeKey(IHorizontalExtensionConnectable.EPostType.WALL, EConnectionType.ON_POST), Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)3.0, (double)12.0)), Map.entry(new ShapeKey(IHorizontalExtensionConnectable.EPostType.WALL, EConnectionType.ON_POST_EXTENSION), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)3.0, (double)20.0), (VoxelShape)Block.m_49796_((double)6.5, (double)0.0, (double)0.0, (double)9.5, (double)3.0, (double)12.0))), Map.entry(new ShapeKey(IHorizontalExtensionConnectable.EPostType.WALL, EConnectionType.AT_POST), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)3.0, (double)20.0), (VoxelShape)Block.m_49796_((double)6.5, (double)0.0, (double)0.0, (double)9.5, (double)3.0, (double)12.0))), Map.entry(new ShapeKey(IHorizontalExtensionConnectable.EPostType.LATTICE, EConnectionType.ON_POST), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0)), Map.entry(new ShapeKey(IHorizontalExtensionConnectable.EPostType.LATTICE, EConnectionType.ON_POST_EXTENSION), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)5.0, (double)14.0, (double)3.0, (double)18.0), (VoxelShape)Block.m_49796_((double)6.5, (double)0.0, (double)0.0, (double)9.5, (double)3.0, (double)5.0))), Map.entry(new ShapeKey(IHorizontalExtensionConnectable.EPostType.LATTICE, EConnectionType.AT_POST), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)5.0, (double)14.0, (double)3.0, (double)18.0), (VoxelShape)Block.m_49796_((double)6.5, (double)0.0, (double)0.0, (double)9.5, (double)3.0, (double)5.0))));
    private static final MapCache<VoxelShape, TransformationShapeKey, TransformationShapeKey> shapesCache = new MapCache(key -> {
        double d;
        VoxelShape baseShape = key.shapeKey().postType() == IHorizontalExtensionConnectable.EPostType.NONE || key.shapeKey().connectionType() == EConnectionType.NONE ? DEFAULT_SHAPE : BASE_SHAPES.get(key.shapeKey());
        Direction direction = key.direction();
        VoxelShape shape = ModMath.rotateShape(baseShape, Direction.Axis.Y, (int)direction.m_122424_().m_122435_());
        Direction.Axis axis = direction.m_122434_();
        Block patt0$temp = key.state().m_60734_();
        if (patt0$temp instanceof IRotatableBlock) {
            IRotatableBlock rot = (IRotatableBlock)patt0$temp;
            d = rot.getScaleForRotation(key.state());
        } else {
            d = 1.0;
        }
        shape = ModMath.scaleShape(shape, axis, d, 0.5);
        if (key.half() == Half.TOP) {
            shape = ModMath.moveShape(shape, new Vec3(0.0, 0.8125, 0.0));
        }
        return shape;
    }, TransformationShapeKey::hashCode, ECachingPriority.ALWAYS);
    public static final EnumProperty<EConnectionType> CONNECTION_TYPE = EnumProperty.m_61587_((String)"connection_type", EConnectionType.class);
    public static final EnumProperty<IHorizontalExtensionConnectable.EPostType> POST_TYPE = EnumProperty.m_61587_((String)"post_type", IHorizontalExtensionConnectable.EPostType.class);
    public static final EnumProperty<Half> HALF = BlockStateProperties.f_61402_;
    private final IWeatheringBlock.WeatherState weatherState;
    private final Supplier<PowerLineBracketBlock> nextOxidationState;

    public PowerLineBracketBlock(BlockBehaviour.Properties properties, IWeatheringBlock.WeatherState weatherState, Supplier<PowerLineBracketBlock> nextOxidationState) {
        super(properties.m_60955_());
        this.weatherState = weatherState;
        this.nextOxidationState = nextOxidationState;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(POST_TYPE, (Comparable)((Object)IHorizontalExtensionConnectable.EPostType.NONE))).m_61124_(CONNECTION_TYPE, (Comparable)((Object)EConnectionType.NONE))).m_61124_(HALF, (Comparable)Half.BOTTOM));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{CONNECTION_TYPE, POST_TYPE, HALF});
    }

    @Override
    public VoxelShape getBaseShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        TransformationShapeKey key = new TransformationShapeKey(new ShapeKey((IHorizontalExtensionConnectable.EPostType)((Object)state.m_61143_(POST_TYPE)), (EConnectionType)((Object)state.m_61143_(CONNECTION_TYPE))), (Direction)state.m_61143_((Property)FACING), PowerLineBracketBlock.normalizedPropertyRotationIndex(state), (Half)state.m_61143_(HALF), state);
        return (VoxelShape)shapesCache.get((Object)key, (Object)key);
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPlaceContextExtension contextExt = (BlockPlaceContextExtension)context;
        Level level = context.m_43725_();
        BlockState state = super.m_5573_(context);
        BlockPos pos = context.m_8083_();
        BlockState supportState = contextExt.getPlacedOnState();
        BlockPos supportPos = contextExt.getPlacedOnPos();
        Direction clickedFace = context.m_43719_();
        if (supportState.m_60734_() instanceof PowerLineBracketBlock && ((Direction)supportState.m_61143_((Property)FACING)).m_122434_() == clickedFace.m_122434_()) {
            if (supportState.m_61143_(CONNECTION_TYPE) == EConnectionType.ON_POST) {
                state = (BlockState)state.m_61124_(CONNECTION_TYPE, (Comparable)((Object)EConnectionType.ON_POST_EXTENSION));
            }
            state = (BlockState)((BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)clickedFace)).m_61124_(POST_TYPE, (Comparable)((Object)((IHorizontalExtensionConnectable.EPostType)((Object)supportState.m_61143_(POST_TYPE)))))).m_61124_(HALF, (Comparable)((Half)supportState.m_61143_(HALF)));
        } else {
            Block block = supportState.m_60734_();
            if (block instanceof IHorizontalExtensionConnectable) {
                IHorizontalExtensionConnectable connection = (IHorizontalExtensionConnectable)block;
                state = (BlockState)((BlockState)((BlockState)state.m_61124_(POST_TYPE, (Comparable)((Object)connection.postConnectionType((LevelReader)level, supportState, supportPos, state, pos)))).m_61124_((Property)ROTATION, (Comparable)((Integer)supportState.m_61143_((Property)ROTATION)))).m_61124_(HALF, (Comparable)(context.m_43720_().f_82480_ - (double)pos.m_123342_() > 0.5 ? Half.TOP : Half.BOTTOM));
                if (clickedFace == Direction.UP) {
                    state = (BlockState)((BlockState)state.m_61124_(CONNECTION_TYPE, (Comparable)((Object)EConnectionType.ON_POST))).m_61124_((Property)FACING, (Comparable)((Direction)supportState.m_61143_((Property)FACING)));
                } else if (clickedFace.m_122434_().m_122479_()) {
                    int rotationValue = Math.abs(PowerLineBracketBlock.normalizedPropertyRotationIndex(supportState));
                    state = (BlockState)((BlockState)((BlockState)state.m_61124_(CONNECTION_TYPE, (Comparable)((Object)EConnectionType.AT_POST))).m_61124_((Property)FACING, (Comparable)clickedFace)).m_61124_((Property)MULTIPART_SEGMENT, (Comparable)Integer.valueOf(rotationValue > 0 && rotationValue < 2 ? 2 : 1));
                }
            }
        }
        return state;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        return this.m_7898_(state, (LevelReader)level, currentPos) ? state : Blocks.f_50016_.m_49966_();
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos supportPos = switch (((EConnectionType)((Object)state.m_61143_(CONNECTION_TYPE))).ordinal()) {
            case 1 -> pos.m_7495_();
            default -> this.relativeTo((BlockAndTintGetter)level, state, pos, ((Direction)state.m_61143_((Property)FACING)).m_122424_());
        };
        BlockState supportState = level.m_8055_(supportPos);
        return supportState.m_60734_() instanceof PowerLineBracketBlock && ((Direction)supportState.m_61143_((Property)FACING)).m_122434_() == ((Direction)state.m_61143_((Property)FACING)).m_122434_() || supportState.m_60734_() instanceof IHorizontalExtensionConnectable;
    }

    @Override
    public BlockModificationData onPlaceOnOtherRotatedBlock(BlockModificationData currentModification, BlockPlaceContext context, BlockState clickedState, BlockPos clickedBlockPos) {
        boolean oppositeFacing;
        Direction clickedFace = context.m_43719_();
        int rot = PowerLineBracketBlock.normalizedPropertyRotationIndex(clickedState);
        boolean bl = oppositeFacing = clickedState.m_60734_() instanceof PowerLineBracketBlock && clickedState.m_61143_(CONNECTION_TYPE) == EConnectionType.ON_POST && ((Direction)clickedState.m_61143_((Property)FACING)).m_122424_() == clickedFace && rot < 2;
        if (oppositeFacing) {
            if (rot < 0) {
                return new BlockModificationData(context.m_8083_().m_121945_(clickedFace.m_122427_()), clickedFace);
            }
            return null;
        }
        return super.onPlaceOnOtherRotatedBlock(currentModification, context, clickedState, clickedBlockPos);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        this.m_220947_(state, level, pos, random);
    }

    public boolean m_6724_(BlockState state) {
        return this.getNext(state.m_60734_()).isPresent();
    }

    public IWeatheringBlock.WeatherState getAge() {
        return this.weatherState;
    }

    @Override
    public Supplier<PowerLineBracketBlock> getNextState() {
        return this.nextOxidationState;
    }

    public static enum EConnectionType implements StringRepresentable
    {
        NONE("none"),
        ON_POST("on_post"),
        ON_POST_EXTENSION("on_post_extension"),
        AT_POST("at_post");

        String name;

        private EConnectionType(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }

    private record TransformationShapeKey(ShapeKey shapeKey, Direction direction, int rotation, Half half, BlockState state) {
        @Override
        public final boolean equals(Object other) {
            if (other instanceof TransformationShapeKey) {
                TransformationShapeKey o = (TransformationShapeKey)other;
                return this.shapeKey().equals(o.shapeKey()) && this.direction().equals((Object)o.direction()) && this.rotation() == o.rotation() && this.half() == o.half();
            }
            return false;
        }

        @Override
        public final int hashCode() {
            return Objects.hash(this.shapeKey(), this.direction(), this.rotation(), this.half());
        }
    }

    private record ShapeKey(IHorizontalExtensionConnectable.EPostType postType, EConnectionType connectionType) {
        @Override
        public final int hashCode() {
            return Objects.hash(new Object[]{this.postType(), this.connectionType()});
        }
    }
}

