/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.block;

import de.mrjulsen.mcdragonlib.config.ECachingPriority;
import de.mrjulsen.mcdragonlib.data.MapCache;
import de.mrjulsen.paw.block.abstractions.AbstractSupportedRotatableWireConnectorBlock;
import de.mrjulsen.paw.block.abstractions.ICatenaryWireConnector;
import de.mrjulsen.paw.block.abstractions.IMultiblock;
import de.mrjulsen.paw.block.extended.BlockPlaceContextExtension;
import de.mrjulsen.paw.block.property.ECantileverConnectionType;
import de.mrjulsen.paw.blockentity.IMultiblockBlockEntity;
import de.mrjulsen.paw.blockentity.MultiblockWireConnectorBlockEntity;
import de.mrjulsen.paw.registry.ModBlockEntities;
import de.mrjulsen.paw.registry.ModBlocks;
import de.mrjulsen.paw.util.ModMath;
import de.mrjulsen.wires.graph.data.provider.CantileverConnectorDataProvider;
import de.mrjulsen.wires.graph.data.provider.ConnectorDataProvider;
import de.mrjulsen.wires.item.CustomData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Vector3f;

public class TensioningDeviceBlock
extends AbstractSupportedRotatableWireConnectorBlock<MultiblockWireConnectorBlockEntity>
implements ICatenaryWireConnector,
IMultiblock {
    public static final int HEIGHT = 7;
    public static final BooleanProperty HELPER = BooleanProperty.m_61465_((String)"helper");
    public static final EnumProperty<ECantileverConnectionType> CONNECTION = EnumProperty.m_61587_((String)"connection", ECantileverConnectionType.class);
    private static final VoxelShape DEFAULT_SHAPE = Block.m_49796_((double)0.5, (double)0.0, (double)-0.25, (double)15.5, (double)16.0, (double)16.0);
    private static final MapCache<VoxelShape, BlockState, BlockState> shapesCache = new MapCache(state -> {
        VoxelShape baseShape = ModMath.moveShape(DEFAULT_SHAPE, new Vec3(0.0, 0.0, (double)(0.0625f * ((float)(16 - ((ECantileverConnectionType)((Object)((Object)state.m_61143_(CONNECTION)))).getIndex()) / 2.0f))));
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        VoxelShape shape = ModMath.rotateShape(baseShape, Direction.Axis.Y, (int)direction.m_122424_().m_122435_());
        return shape;
    }, Object::hashCode, ECachingPriority.ALWAYS);

    public TensioningDeviceBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)HELPER, (Comparable)Boolean.valueOf(false))).m_61124_(CONNECTION, (Comparable)((Object)ECantileverConnectionType.PX16)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{CONNECTION, HELPER});
    }

    @Override
    public RenderShape m_7514_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)HELPER) != false ? RenderShape.INVISIBLE : RenderShape.MODEL;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPlaceContextExtension ext = (BlockPlaceContextExtension)context;
        Level level = context.m_43725_();
        BlockPos.MutableBlockPos refPos = new BlockPos.MutableBlockPos(ext.getPlacedOnPos().m_123341_(), ext.getPlacedOnPos().m_123342_(), ext.getPlacedOnPos().m_123343_());
        BlockState refState = ext.getPlacedOnState();
        ECantileverConnectionType refConnectionType = ECantileverConnectionType.getFirstForState(refState).orElse(ECantileverConnectionType.PX16);
        for (int i = 1; i < 7; ++i) {
            refPos.m_122184_(0, -1, 0);
            BlockState supportState = level.m_8055_((BlockPos)refPos);
            ECantileverConnectionType connectionType = ECantileverConnectionType.getFirstForState(supportState).orElse(ECantileverConnectionType.PX16);
            if (refState.m_60734_() != supportState.m_60734_() && (refConnectionType != connectionType || refConnectionType == ECantileverConnectionType.PX16 && !supportState.m_60783_((BlockGetter)level, (BlockPos)refPos, context.m_43719_()))) {
                return null;
            }
            BlockPos p = context.m_8083_().m_5484_(Direction.DOWN, i);
            if (level.m_8055_(p).m_60629_(context) && !level.m_151570_(p)) continue;
            return null;
        }
        return (BlockState)super.m_5573_(context).m_61124_(CONNECTION, (Comparable)((Object)ECantileverConnectionType.getFirstForState(ext.getPlacedOnState()).orElse(ECantileverConnectionType.PX16)));
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockPos.MutableBlockPos refPos = new BlockPos.MutableBlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        for (int i = 1; i < 7; ++i) {
            refPos.m_122184_(0, -1, 0);
            level.m_6933_((BlockPos)refPos, (BlockState)state.m_61124_((Property)HELPER, (Comparable)Boolean.valueOf(true)), 0, 0);
            BlockEntity blockEntity = level.m_7702_((BlockPos)refPos);
            if (!(blockEntity instanceof MultiblockWireConnectorBlockEntity)) continue;
            MultiblockWireConnectorBlockEntity be = (MultiblockWireConnectorBlockEntity)blockEntity;
            be.setOffset(1, i, 1);
        }
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        return this.m_7898_(state, (LevelReader)level, currentPos) ? super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos) : Blocks.f_50016_.m_49966_();
    }

    @Override
    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IMultiblockBlockEntity) {
            IMultiblockBlockEntity b;
            BlockEntity blockEntity2;
            boolean b2;
            IMultiblockBlockEntity b3;
            BlockEntity blockEntity3;
            IMultiblockBlockEntity be = (IMultiblockBlockEntity)blockEntity;
            int yOffset = be.getYOffset();
            BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            mPos.m_122184_(0, 1, 0);
            boolean b1 = yOffset <= 0 || level.m_8055_((BlockPos)mPos).m_60713_((Block)this) && (blockEntity3 = level.m_7702_((BlockPos)mPos)) instanceof IMultiblockBlockEntity && (b3 = (IMultiblockBlockEntity)blockEntity3).getYOffset() == yOffset - 1;
            mPos.m_122184_(0, -2, 0);
            boolean bl = b2 = yOffset >= 6 || level.m_8055_((BlockPos)mPos).m_60713_((Block)this) && (blockEntity2 = level.m_7702_((BlockPos)mPos)) instanceof IMultiblockBlockEntity && (b = (IMultiblockBlockEntity)blockEntity2).getYOffset() == yOffset + 1;
            if (!b1 || !b2) {
                return false;
            }
            mPos.m_122184_(0, 1, 0);
            BlockPos refPos = this.getSupportBlockPos((BlockGetter)level, (BlockPos)mPos, state);
            BlockState refState = level.m_8055_(refPos);
            ECantileverConnectionType refConnectionType = ECantileverConnectionType.getFirstForState(refState).orElse(ECantileverConnectionType.PX16);
            for (int i = yOffset; i < 6; ++i) {
                mPos.m_122184_(0, -1, 0);
                BlockPos supportPos = this.getSupportBlockPos((BlockGetter)level, (BlockPos)mPos, state);
                BlockState supportState = level.m_8055_(supportPos);
                ECantileverConnectionType connectionType = ECantileverConnectionType.getFirstForState(supportState).orElse(ECantileverConnectionType.PX16);
                if (refState.m_60734_() == supportState.m_60734_() || refConnectionType == connectionType && (refConnectionType != ECantileverConnectionType.PX16 || supportState.m_60783_((BlockGetter)level, supportPos, ((Direction)state.m_61143_((Property)FACING)).m_122424_()))) continue;
                return false;
            }
        }
        return super.m_7898_(state, level, pos);
    }

    @Override
    protected TagKey<Block> getSupportBlockTag() {
        return ModBlocks.TAG_TENSIONING_DEVICE_CONNECTABLE;
    }

    @Override
    public VoxelShape getBaseShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (VoxelShape)shapesCache.get((Object)state, (Object)state);
    }

    @Override
    public Vec3 defaultWireAttachPoint(Level level, BlockPos pos, BlockState state, CustomData itemData, int index) {
        return new Vec3(-0.28125, 0.015625, (double)(0.015625f + 0.0625f * ((float)(16 - ((ECantileverConnectionType)((Object)state.m_61143_(CONNECTION))).getIndex()) / 2.0f)));
    }

    @Override
    public Vec3 tensionWireAttachPoint(Level level, BlockPos pos, BlockState state, CustomData itemData, int index) {
        return new Vec3(0.28125, 0.640625, (double)(0.015625f + 0.0625f * ((float)(16 - ((ECantileverConnectionType)((Object)state.m_61143_(CONNECTION))).getIndex()) / 2.0f)));
    }

    @Override
    public ConnectorDataProvider getConnectorData(Level level, BlockPos pos, CustomData customData, int connectionPointIndex) {
        Vector3f contactAttachPoint = this.transformWireAttachPoint(level, pos, level.m_8055_(pos), customData, connectionPointIndex, this::defaultWireAttachPoint).m_252839_();
        Vector3f tensionattachPoint = this.transformWireAttachPoint(level, pos, level.m_8055_(pos), customData, connectionPointIndex, this::tensionWireAttachPoint).m_252839_();
        CompoundTag customNbt = customData.getCommonData();
        customNbt.m_128379_("SuperTightened", true);
        customData.setCommonData(customNbt);
        return new CantileverConnectorDataProvider(contactAttachPoint, tensionattachPoint);
    }

    @Override
    public Vec2 getRotationPivotPoint(BlockState state) {
        return new Vec2(0.0f, 1.0f);
    }

    @Override
    public Vec3 multiblockSize() {
        return new Vec3(1.0, 7.0, 1.0);
    }

    @Override
    public boolean canConnectWire(LevelReader level, BlockPos pos, BlockState state) {
        return (Boolean)state.m_61143_((Property)HELPER) == false;
    }

    public Class<MultiblockWireConnectorBlockEntity> getBlockEntityClass() {
        return MultiblockWireConnectorBlockEntity.class;
    }

    public BlockEntityType<? extends MultiblockWireConnectorBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModBlockEntities.MULTIBLOCK_WIRE_CONNECTOR_BLOCK_ENTITY.get();
    }
}

