/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.block.abstractions;

import de.mrjulsen.mcdragonlib.core.ITranslatableEnum;
import de.mrjulsen.paw.block.abstractions.AbstractSupportedRotatableWireConnectorBlock;
import de.mrjulsen.paw.block.abstractions.ICantileverConnectableBlock;
import de.mrjulsen.paw.block.abstractions.ICatenaryWireConnector;
import de.mrjulsen.paw.blockentity.CantileverBlockEntity;
import de.mrjulsen.paw.client.gui.ModGuiIcons;
import de.mrjulsen.paw.client.gui.widgets.IIconRepresentable;
import de.mrjulsen.paw.registry.ModBlockEntities;
import de.mrjulsen.paw.registry.ModBlocks;
import de.mrjulsen.wires.graph.data.provider.CantileverConnectorDataProvider;
import de.mrjulsen.wires.graph.data.provider.ConnectorDataProvider;
import de.mrjulsen.wires.item.CustomData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Vector3f;

public abstract class AbstractCantileverBlock
extends AbstractSupportedRotatableWireConnectorBlock<CantileverBlockEntity>
implements ICatenaryWireConnector {
    public static final float MIN_WIDTH = 1.5f;
    public static final float MAX_WIDTH = 6.5f;
    public static final float MIN_HEIGHT = 0.0f;
    public static final float MAX_HEIGHT = 3.0f;
    public static final byte MAX_CANTILEVERS = 3;

    public static Constraints calculate(float width, float height, float armHeight) {
        SliderConstraints widthConstraints = new SliderConstraints(1.5f, 6.5f, 1.0f);
        float minHeight = 0.0f;
        if (width >= 3.0f) {
            int offset = (int)Math.floor((width - 1.0f) / 2.0f);
            minHeight = Math.max(minHeight, (float)offset * 0.5f);
        }
        if (width <= 1.5f && armHeight == 0.0f) {
            minHeight = Math.max(minHeight, 0.5f);
        }
        float maxHeight = 3.0f;
        float minArmHeight = 0.0f;
        if (height >= 2.0f) {
            minArmHeight = Math.max(minArmHeight, 1.0f);
        } else if (height >= 1.0f) {
            minArmHeight = Math.max(minArmHeight, 0.5f);
        }
        if (width <= 1.5f && height == 0.0f) {
            minArmHeight = Math.max(minArmHeight, 0.5f);
        }
        float maxArmHeight = Math.min(3.0f, Math.max(1.0f, height));
        float stepHeight = 0.5f;
        float stepArm = 0.5f;
        if (width <= 1.5f && height == 0.5f) {
            stepArm = 1.0f;
        }
        SliderConstraints heightConstraints = new SliderConstraints(minHeight, maxHeight, stepHeight);
        SliderConstraints armHeightConstraints = new SliderConstraints(minArmHeight, maxArmHeight, stepArm);
        boolean b = width > 1.5f;
        return new Constraints(widthConstraints, heightConstraints, armHeightConstraints, b);
    }

    public static byte additionalCantileversCheck(float width, float height, float catenaryHeight) {
        if (width <= 2.0f) {
            return 1;
        }
        if (catenaryHeight < 0.5f) {
            return 2;
        }
        return 3;
    }

    public AbstractCantileverBlock(BlockBehaviour.Properties properties) {
        super(properties.m_284180_(MapColor.f_283906_).m_60955_());
    }

    public Class<CantileverBlockEntity> getBlockEntityClass() {
        return CantileverBlockEntity.class;
    }

    @Override
    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        ICantileverConnectableBlock c;
        Block block;
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos relativePos = this.getSupportBlockPos((BlockGetter)level, pos, state);
        BlockState supportState = level.m_8055_(relativePos);
        return super.m_7898_(state, level, pos) && (!((block = supportState.m_60734_()) instanceof ICantileverConnectableBlock) || (c = (ICantileverConnectableBlock)block).canCantileverConnect((BlockAndTintGetter)level, relativePos, supportState, direction));
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder params) {
        BlockEntity blockEntity = (BlockEntity)params.m_287159_(LootContextParams.f_81462_);
        if (blockEntity instanceof CantileverBlockEntity) {
            CantileverBlockEntity be = (CantileverBlockEntity)blockEntity;
            byte count = be.getCantileversCount();
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (byte i = 0; i < count; i = (byte)(i + 1)) {
                items.addAll(super.m_49635_(state, params));
            }
            return items;
        }
        return super.m_49635_(state, params);
    }

    @Override
    protected TagKey<Block> getSupportBlockTag() {
        return ModBlocks.TAG_CANTILEVER_CONNECTABLE;
    }

    @Override
    public VoxelShape getBaseShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        double stretch = 16.0 * (1.0 / Math.cos(Math.abs(Math.toRadians(this.getRelativeYRotation(state)))) - 1.0);
        double a = 6.0;
        double b = 10.0;
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.SOUTH -> Block.m_49796_((double)a, (double)0.0, (double)0.0, (double)b, (double)16.0, (double)(16.0 + stretch));
            case Direction.WEST -> Block.m_49796_((double)(-stretch), (double)0.0, (double)a, (double)16.0, (double)16.0, (double)b);
            case Direction.EAST -> Block.m_49796_((double)0.0, (double)0.0, (double)a, (double)(16.0 + stretch), (double)16.0, (double)b);
            default -> Block.m_49796_((double)a, (double)0.0, (double)(-stretch), (double)b, (double)16.0, (double)16.0);
        };
    }

    @Override
    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public BlockEntityType<? extends CantileverBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModBlockEntities.CANTILEVER_BLOCK_ENTITY.get();
    }

    @Override
    public Vec2 getRotationPivotPoint(BlockState state) {
        return new Vec2(0.0f, 1.0f);
    }

    @Override
    public ConnectorDataProvider getConnectorData(Level level, BlockPos pos, CustomData customData, int connectionPointIndex) {
        Vector3f contactAttachPoint = this.transformWireAttachPoint(level, pos, level.m_8055_(pos), customData, connectionPointIndex, this::defaultWireAttachPoint).m_252839_();
        Vector3f tensionattachPoint = this.transformWireAttachPoint(level, pos, level.m_8055_(pos), customData, connectionPointIndex, this::tensionWireAttachPoint).m_252839_();
        return new CantileverConnectorDataProvider(contactAttachPoint, tensionattachPoint);
    }

    public record SliderConstraints(float min, float max, float step) {
    }

    public record Constraints(SliderConstraints width, SliderConstraints height, SliderConstraints armHeight, boolean registrationArmsAllowed) {
    }

    public static enum ECantileverInsulatorsPlacement implements StringRepresentable,
    IIconRepresentable,
    ITranslatableEnum
    {
        BACK("back", ModGuiIcons.CANTILEVER_INSULATOR_BACK, 0.0f),
        FRONT("front", ModGuiIcons.CANTILEVER_INSULATOR_FRONT, 0.8f);

        final String name;
        final ModGuiIcons icon;
        final float offsetFac;

        private ECantileverInsulatorsPlacement(String name, ModGuiIcons icon, float offsetFac) {
            this.name = name;
            this.icon = icon;
            this.offsetFac = offsetFac;
        }

        public static ECantileverInsulatorsPlacement getByName(String name) {
            return Arrays.stream(ECantileverInsulatorsPlacement.values()).filter(x -> x.m_7912_().equals(name)).findFirst().orElse(BACK);
        }

        @Override
        public ModGuiIcons getIcon() {
            return this.icon;
        }

        public float getPlacementOffsetFac() {
            return this.offsetFac;
        }

        public String m_7912_() {
            return this.name;
        }

        public String getEnumName() {
            return "insulator_placement";
        }

        public String getEnumValueName() {
            return this.name;
        }

        public static ECantileverInsulatorsPlacement def() {
            return BACK;
        }
    }

    public static enum ECantileverRegistrationArmType implements StringRepresentable,
    IIconRepresentable,
    ITranslatableEnum
    {
        CENTER("center", ModGuiIcons.CANTILEVER_CENTER, 0.0f, 0.0f),
        INNER("inner", ModGuiIcons.CANTILEVER_INNER, -0.25f, 1.0f),
        OUTER("outer", ModGuiIcons.CANTILEVER_OUTER, 0.25f, 0.0f);

        final String name;
        final ModGuiIcons icon;
        final float offset;
        final float registrationArmExtend;

        private ECantileverRegistrationArmType(String name, ModGuiIcons icon, float offset, float registrationArmExtend) {
            this.name = name;
            this.icon = icon;
            this.offset = offset;
            this.registrationArmExtend = registrationArmExtend;
        }

        public static ECantileverRegistrationArmType getByName(String name) {
            return Arrays.stream(ECantileverRegistrationArmType.values()).filter(x -> x.m_7912_().equals(name)).findFirst().orElse(CENTER);
        }

        @Override
        public ModGuiIcons getIcon() {
            return this.icon;
        }

        public float getOffset() {
            return this.offset;
        }

        public String m_7912_() {
            return this.name;
        }

        public String getEnumName() {
            return "cantilever_registration_arm";
        }

        public String getEnumValueName() {
            return this.name;
        }

        public static ECantileverRegistrationArmType def() {
            return CENTER;
        }

        public ECantileverRegistrationArmType opposite() {
            return switch (this.ordinal()) {
                case 1 -> OUTER;
                case 2 -> INNER;
                default -> this;
            };
        }
    }
}

