/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.block.abstractions;

import de.mrjulsen.mcdragonlib.util.MathUtils;
import de.mrjulsen.paw.block.abstractions.IRotatableBlock;
import de.mrjulsen.paw.util.ModMath;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class AbstractRotatableBlock
extends Block
implements IRotatableBlock {
    protected static final float EPSILON = 1.0E-6f;
    public static final int ROTATIONS = 2;
    public static final int ROTATION_OFFSET = 1;
    public static final int MAX_ROTATION_INDEX = 2;
    public static final int MIN_ROTATION_INDEX = -2;
    public static final int ROTATION_STEPS_PER_SIDE = 4;
    public static final int TOTAL_ROTATION_STEPS = 16;
    public static final int PROPERTY_MAX_ROTATION_INDEX = 3;
    public static final int PROPERTY_BASE_ROTATION_INDEX = 1;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final IntegerProperty ROTATION = IntegerProperty.m_61631_((String)"rotation", (int)0, (int)3);
    private final Map<Integer, ShapeCacheEntry> shapes = new ConcurrentHashMap<Integer, ShapeCacheEntry>();

    public AbstractRotatableBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(1)));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BlockHitResult checkClickedFace(Level level, Player player, BlockHitResult hit) {
        BlockPos pos = hit.m_82425_();
        BlockState state = level.m_8055_(pos);
        Direction targetDir = hit.m_82434_();
        if (targetDir.m_122434_() != Direction.Axis.Y) {
            Vec2[] points = this.getCubeCorners(state, (BlockGetter)level, pos, null);
            for (int i = 0; i < points.length; ++i) {
                Vec2 pointA = points[i];
                Vec2 pointB = points[(i + 1) % points.length];
                Direction dir = switch (i) {
                    case 1 -> Direction.EAST;
                    case 2 -> Direction.SOUTH;
                    case 3 -> Direction.WEST;
                    default -> Direction.NORTH;
                };
                float minX = Math.min(pointA.f_82470_, pointB.f_82470_);
                float minZ = Math.min(pointA.f_82471_, pointB.f_82471_);
                float maxX = Math.max(pointA.f_82470_, pointB.f_82470_);
                float maxZ = Math.max(pointA.f_82471_, pointB.f_82471_);
                Vec3 clicked = hit.m_82450_().m_82546_(MathUtils.blockPosToVec3((BlockPos)pos));
                if (!(clicked.f_82479_ >= (double)minX) || !(clicked.f_82479_ <= (double)maxX) || !(clicked.f_82481_ >= (double)minZ) || !(clicked.f_82481_ <= (double)maxZ)) continue;
                targetDir = dir;
                break;
            }
        }
        return hit.m_82432_(targetDir);
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{FACING, ROTATION});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_43719_();
        BlockPos clickPos = context.m_8083_().m_121945_(direction.m_122424_());
        Level level = context.m_43725_();
        BlockState clickedState = level.m_8055_(clickPos);
        BlockState state = super.m_49966_();
        if (clickedState.m_60734_() instanceof AbstractRotatableBlock && direction.m_122434_() == Direction.Axis.Y) {
            state = (BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)((Direction)clickedState.m_61143_((Property)FACING)))).m_61124_((Property)ROTATION, (Comparable)((Integer)clickedState.m_61143_((Property)ROTATION)));
        } else {
            int rot = Mth.m_14107_((double)((double)((180.0f + context.m_7074_()) * 16.0f / 360.0f) + 0.5)) & 0xF;
            int steps = 4;
            Direction dir = Direction.m_122407_((int)((rot + 2) / 4));
            state = (BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)dir)).m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(3 - (rot + 2) % 4));
        }
        return state;
    }

    private ShapeCacheEntry getShapeData(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shapes.computeIfAbsent(this.shapeHash(level, pos, state), x -> this.calcShape(state, level, pos, context));
    }

    protected int shapeHash(BlockGetter level, BlockPos pos, BlockState state) {
        return state.hashCode();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getShapeData(state, level, pos, context).shape();
    }

    @Override
    public VoxelShape getBaseShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.m_83144_();
    }

    public Vec2[] getCubeCorners(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getShapeData(state, level, pos, context).corners();
    }

    @Override
    public float getRelativeYRotation(BlockState state) {
        return AbstractRotatableBlock.rotationOf(AbstractRotatableBlock.propertyIndexToRotIndex((Integer)state.m_61143_((Property)ROTATION)));
    }

    @Override
    public float getYRotation(BlockState state) {
        return this.rotationOfFacingDirection(state) + this.getRelativeYRotation(state);
    }

    public float rotationOfFacingDirection(BlockState state) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.EAST -> 270.0f;
            case Direction.SOUTH -> 180.0f;
            case Direction.WEST -> 90.0f;
            default -> 0.0f;
        };
    }

    @Override
    public Vec2 rotatedPivotPoint(BlockState state) {
        return ModMath.rotateY(this.getRotationPivotPoint(state), this.rotationOfFacingDirection(state)).m_165908_(0.5f);
    }

    private ShapeCacheEntry calcShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape base = this.getBaseShape(state, level, pos, context);
        float angle = -this.getRelativeYRotation(state);
        Vec2 pivot = this.rotatedPivotPoint(state);
        Vec2 offset = this.getOffset(state);
        List aabbs = base.m_83299_();
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
        Vec2[] finalCorners = new Vec2[]{};
        for (AABB aabb : aabbs) {
            Vec2[] corners = AbstractRotatableBlock.rotateCorners(angle, 0.0625f, pivot, aabb, offset);
            if (finalCorners.length <= 0) {
                finalCorners = corners;
            }
            List<Vec2[]> rectangles = AbstractRotatableBlock.approximateSquare(corners, angle, 0.0625f);
            for (Vec2[] rect : rectangles) {
                shapes.add(Block.m_49796_((double)(rect[0].f_82470_ * 16.0f), (double)(aabb.f_82289_ * 16.0), (double)(rect[0].f_82471_ * 16.0f), (double)((rect[1].f_82470_ + 0.0625f) * 16.0f), (double)(aabb.f_82292_ * 16.0), (double)(rect[1].f_82471_ * 16.0f)));
            }
        }
        return new ShapeCacheEntry(Shapes.m_83124_((VoxelShape)Shapes.m_83040_(), (VoxelShape[])((VoxelShape[])shapes.toArray(VoxelShape[]::new))).m_83296_(), finalCorners);
    }

    public static Vec2[] rotateCorners(float angle, float minSize, Vec2 pivotPoint, AABB src, Vec2 offset) {
        Vec2[] square = new Vec2[]{new Vec2((float)src.f_82288_, (float)src.f_82290_), new Vec2((float)src.f_82291_, (float)src.f_82290_), new Vec2((float)src.f_82291_, (float)src.f_82293_), new Vec2((float)src.f_82288_, (float)src.f_82293_)};
        float radians = (float)Math.toRadians(angle);
        Vec2[] rotatedSquare = new Vec2[4];
        for (int i = 0; i < 4; ++i) {
            Vec2 v = square[i];
            if (Math.abs(angle) > 1.0E-6f) {
                v = AbstractRotatableBlock.rotatePointAroundPivot(v, pivotPoint, radians);
            }
            rotatedSquare[i] = v = v.m_165910_(offset);
        }
        return rotatedSquare;
    }

    public static List<Vec2[]> approximateSquare(Vec2[] rotatedCorners, float angle, float minSize) {
        float minX = Float.MAX_VALUE;
        float minY = Float.MAX_VALUE;
        float maxX = Float.MIN_VALUE;
        float maxY = Float.MIN_VALUE;
        for (Vec2 point : rotatedCorners) {
            if (point.f_82470_ < minX) {
                minX = point.f_82470_;
            }
            if (point.f_82471_ < minY) {
                minY = point.f_82471_;
            }
            if (point.f_82470_ > maxX) {
                maxX = point.f_82470_;
            }
            if (!(point.f_82471_ > maxY)) continue;
            maxY = point.f_82471_;
        }
        ArrayList<Vec2[]> rectangles = new ArrayList<Vec2[]>();
        if (Math.abs(angle) < 1.0E-6f) {
            rectangles.add(new Vec2[]{new Vec2(minX, minY), new Vec2(maxX, maxY)});
            return rectangles;
        }
        for (float x = minX; x < maxX; x += minSize) {
            for (float y = minY; y < maxY; y += minSize) {
                Vec2 rectBottomLeft = new Vec2(x, y);
                Vec2 rectTopRight = new Vec2(x + minSize, y + minSize);
                if (!AbstractRotatableBlock.isRectangleIntersectingPolygon(rotatedCorners, rectBottomLeft, rectTopRight)) continue;
                rectangles.add(new Vec2[]{rectBottomLeft, new Vec2(rectBottomLeft.f_82470_, rectTopRight.f_82471_), rectTopRight, new Vec2(rectTopRight.f_82470_, rectBottomLeft.f_82471_)});
            }
        }
        return rectangles;
    }

    private static Vec2 rotatePointAroundPivot(Vec2 point, Vec2 pivot, float radians) {
        float translatedX = point.f_82470_ - pivot.f_82470_;
        float translatedY = point.f_82471_ - pivot.f_82471_;
        float cos = (float)Math.cos(radians);
        float sin = (float)Math.sin(radians);
        float rotatedX = translatedX * cos - translatedY * sin;
        float rotatedY = translatedX * sin + translatedY * cos;
        return new Vec2(rotatedX + pivot.f_82470_, rotatedY + pivot.f_82471_);
    }

    private static boolean isRectangleIntersectingPolygon(Vec2[] polygon, Vec2 rectBottomLeft, Vec2 rectTopRight) {
        Vec2[] rectPoints;
        for (Vec2 point : rectPoints = new Vec2[]{rectBottomLeft, new Vec2(rectBottomLeft.f_82470_, rectTopRight.f_82471_), rectTopRight, new Vec2(rectTopRight.f_82470_, rectBottomLeft.f_82471_)}) {
            if (!AbstractRotatableBlock.isPointInPolygon(polygon, point)) continue;
            return true;
        }
        for (int i = 0; i < polygon.length; ++i) {
            Vec2 p1 = polygon[i];
            Vec2 p2 = polygon[(i + 1) % polygon.length];
            for (int j = 0; j < rectPoints.length; ++j) {
                Vec2 r1 = rectPoints[j];
                Vec2 r2 = rectPoints[(j + 1) % rectPoints.length];
                if (!AbstractRotatableBlock.doLinesIntersect(p1, p2, r1, r2)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean doLinesIntersect(Vec2 p1, Vec2 p2, Vec2 q1, Vec2 q2) {
        float o1 = AbstractRotatableBlock.orientation(p1, p2, q1);
        float o2 = AbstractRotatableBlock.orientation(p1, p2, q2);
        float o3 = AbstractRotatableBlock.orientation(q1, q2, p1);
        float o4 = AbstractRotatableBlock.orientation(q1, q2, p2);
        return o1 != o2 && o3 != o4;
    }

    private static float orientation(Vec2 p, Vec2 q, Vec2 r) {
        float val = (q.f_82471_ - p.f_82471_) * (r.f_82470_ - q.f_82470_) - (q.f_82470_ - p.f_82470_) * (r.f_82471_ - q.f_82471_);
        if (Math.abs(val) < 1.0E-6f) {
            return 0.0f;
        }
        return val > 0.0f ? 1.0f : 2.0f;
    }

    private static boolean isPointInPolygon(Vec2[] polygon, Vec2 point) {
        int crossings = 0;
        for (int i = 0; i < polygon.length; ++i) {
            float t;
            boolean cond2;
            Vec2 v1 = polygon[i];
            Vec2 v2 = polygon[(i + 1) % polygon.length];
            boolean cond1 = v1.f_82471_ <= point.f_82471_ + 1.0E-6f && point.f_82471_ + 1.0E-6f < v2.f_82471_;
            boolean bl = cond2 = v2.f_82471_ <= point.f_82471_ + 1.0E-6f && point.f_82471_ + 1.0E-6f < v1.f_82471_;
            if (!cond1 && !cond2 || !(point.f_82470_ < v1.f_82470_ + (t = (point.f_82471_ - v1.f_82471_) / (v2.f_82471_ - v1.f_82471_)) * (v2.f_82470_ - v1.f_82470_))) continue;
            ++crossings;
        }
        return crossings % 2 != 0;
    }

    public static Vec2[] getRotatedSquare(float angle, Vec2 pivotPoint, AABB src) {
        Vec2[] square = new Vec2[]{new Vec2((float)src.f_82288_, (float)src.f_82290_), new Vec2((float)src.f_82291_, (float)src.f_82290_), new Vec2((float)src.f_82291_, (float)src.f_82293_), new Vec2((float)src.f_82288_, (float)src.f_82293_)};
        float radians = (float)Math.toRadians(angle);
        Vec2[] rotatedSquare = new Vec2[4];
        for (int i = 0; i < 4; ++i) {
            rotatedSquare[i] = AbstractRotatableBlock.rotatePointAroundPivot(square[i], pivotPoint, radians);
        }
        return rotatedSquare;
    }

    protected static final float m(int rotIdx) {
        return (float)rotIdx / 2.0f;
    }

    protected static final int propertyIndexToRotIndex(int prop) {
        return prop - 1;
    }

    protected static final float rotationOf(int rotationIndex) {
        return (float)Math.toDegrees(Math.atan(AbstractRotatableBlock.m(rotationIndex)));
    }

    protected static final int normalizedPropertyRotationIndex(BlockState state) {
        int prop = (Integer)state.m_61143_((Property)ROTATION);
        return prop - 1;
    }

    protected BlockPos relativeTo(BlockAndTintGetter level, BlockState state, BlockPos pos, Direction direction) {
        BlockPos result = pos.m_121945_(direction);
        if (level.m_8055_(pos).m_60713_(state.m_60734_()) && AbstractRotatableBlock.normalizedPropertyRotationIndex(state) >= 2) {
            result = result.m_121945_(direction.m_122428_());
        }
        return result;
    }

    protected BlockPos getSupportBlockPos(BlockGetter level, BlockPos pos, BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos relativePos = pos.m_121945_(direction.m_122424_());
        if (level.m_8055_(pos).m_60734_() instanceof AbstractRotatableBlock && this.getRelativeYRotation(state) > 30.0f) {
            relativePos = relativePos.m_121945_(direction.m_122427_());
        }
        return relativePos;
    }

    private record ShapeCacheEntry(VoxelShape shape, Vec2[] corners) {
    }
}

