/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.block.abstractions;

import de.mrjulsen.mcdragonlib.config.ECachingPriority;
import de.mrjulsen.mcdragonlib.data.MapCache;
import de.mrjulsen.mcdragonlib.util.MathUtils;
import de.mrjulsen.paw.block.abstractions.AbstractRotatableBlock;
import de.mrjulsen.paw.block.extended.BlockPlaceContextExtension;
import de.mrjulsen.paw.data.BlockModificationData;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec2;

public abstract class AbstractRotatedConnectableBlock
extends AbstractRotatableBlock {
    public static final int DEFAULT_SEGMENT = 1;
    public static final IntegerProperty MULTIPART_SEGMENT = AbstractRotatedConnectableBlock.createMultipartSegmentsProperty();
    private final MapCache<Vec2, BlockState, BlockState> offsetCache = AbstractRotatedConnectableBlock.createOffsetCache();

    public AbstractRotatedConnectableBlock(BlockBehaviour.Properties properties) {
        super(properties.m_284180_(MapColor.f_283906_));
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)MULTIPART_SEGMENT, (Comparable)Integer.valueOf(1)));
    }

    public static MapCache<Vec2, BlockState, BlockState> createOffsetCache() {
        return new MapCache(c -> {
            int rawRotationIndex = AbstractRotatedConnectableBlock.normalizedPropertyRotationIndex(c);
            int rotationIndex = Math.abs(rawRotationIndex) + 1;
            int currentPart = (Integer)c.m_61143_((Property)MULTIPART_SEGMENT);
            float multiplier = 1.0f / (float)rotationIndex * (float)(MathUtils.clamp((int)currentPart, (int)1, (int)rotationIndex) - 1);
            return switch ((Direction)c.m_61143_((Property)FACING)) {
                case Direction.WEST -> new Vec2(0.0f, 1.0f).m_165903_(multiplier);
                case Direction.EAST -> new Vec2(0.0f, -1.0f).m_165903_(multiplier);
                case Direction.SOUTH -> new Vec2(1.0f, 0.0f).m_165903_(multiplier);
                default -> new Vec2(-1.0f, 0.0f).m_165903_(multiplier);
            };
        }, state -> Objects.hash(state.m_61148_().values().toArray(Object[]::new)), ECachingPriority.ALWAYS);
    }

    public static IntegerProperty createMultipartSegmentsProperty() {
        return IntegerProperty.m_61631_((String)"multipart_segment", (int)1, (int)2);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{MULTIPART_SEGMENT});
    }

    protected int maxSegments(BlockState state) {
        int rotationIndex = Math.abs(AbstractRotatedConnectableBlock.normalizedPropertyRotationIndex(state)) + 1;
        if (rotationIndex >= 3) {
            rotationIndex = 1;
        }
        return rotationIndex;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPlaceContextExtension ctxExt = (BlockPlaceContextExtension)context;
        BlockState state = super.m_5573_(context);
        BlockState clickedOnState = ctxExt.getPlacedOnState();
        Direction clickedFace = context.m_43719_();
        if (this.canConnect(context.m_43725_(), state, context.m_8083_(), clickedOnState, ctxExt.getPlacedOnPos()) && ((Direction)clickedOnState.m_61143_((Property)FACING)).m_122434_() == clickedFace.m_122434_()) {
            int rotationIndex = this.maxSegments(clickedOnState);
            state = (BlockState)((BlockState)((BlockState)state.m_61124_((Property)MULTIPART_SEGMENT, (Comparable)Integer.valueOf(clickedFace == clickedOnState.m_61143_((Property)FACING) ? (Integer)clickedOnState.m_61143_((Property)MULTIPART_SEGMENT) % rotationIndex + 1 : Math.abs(((Integer)clickedOnState.m_61143_((Property)MULTIPART_SEGMENT) - 2) % rotationIndex) + 1))).m_61124_((Property)FACING, (Comparable)((Direction)clickedOnState.m_61143_((Property)FACING)))).m_61124_((Property)ROTATION, (Comparable)((Integer)clickedOnState.m_61143_((Property)ROTATION)));
        }
        return state;
    }

    protected boolean canConnect(Level level, BlockState state, BlockPos pos, BlockState otherState, BlockPos otherPos) {
        return state.m_60713_(otherState.m_60734_());
    }

    @Override
    public Vec2 getOffset(BlockState state) {
        return (Vec2)this.offsetCache.get((Object)state, (Object)state);
    }

    @Override
    public Direction.Axis transformOnAxis(BlockState state) {
        return ((Direction)state.m_61143_((Property)FACING)).m_122434_();
    }

    @Override
    public BlockModificationData onPlaceOnRotatedBlock(BlockPlaceContext context, BlockState clickedState, BlockPos clickedBlockPos) {
        boolean clickedOnFront;
        BlockModificationData value = super.onPlaceOnRotatedBlock(context, clickedState, clickedBlockPos);
        int rotationValue = AbstractRotatedConnectableBlock.normalizedPropertyRotationIndex(clickedState);
        Direction clickedFace = context.m_43719_();
        boolean bl = clickedOnFront = clickedFace == clickedState.m_61143_((Property)FACING);
        if (value == null && clickedFace != null && rotationValue != 0 && (Integer)clickedState.m_61143_((Property)MULTIPART_SEGMENT) == 1 + (clickedOnFront ^ rotationValue < 0 ? 1 : 0) && clickedFace.m_122434_() == this.transformOnAxis(clickedState)) {
            return new BlockModificationData(context.m_8083_().m_121945_(rotationValue > 0 ? clickedFace.m_122428_() : clickedFace.m_122427_()), clickedFace);
        }
        return value;
    }

    @Override
    public BlockModificationData onPlaceOnOtherRotatedBlock(BlockModificationData currentModification, BlockPlaceContext context, BlockState clickedState, BlockPos clickedBlockPos) {
        int rotationValue = AbstractRotatedConnectableBlock.normalizedPropertyRotationIndex(clickedState);
        Direction clickedFace = context.m_43719_();
        if (clickedFace != null && rotationValue < 0 && !(clickedState.m_60734_() instanceof AbstractRotatedConnectableBlock)) {
            return new BlockModificationData(context.m_8083_().m_121945_(clickedFace.m_122427_()), clickedFace);
        }
        return currentModification;
    }

    @Override
    protected BlockPos relativeTo(BlockAndTintGetter level, BlockState state, BlockPos pos, Direction direction) {
        BlockPos result = pos.m_121945_(direction);
        if (level.m_8055_(pos).m_60713_(state.m_60734_())) {
            int rot = AbstractRotatedConnectableBlock.normalizedPropertyRotationIndex(state);
            if (rot >= 2) {
                result = result.m_121945_(direction.m_122428_());
            } else if (rot > 0 && (Integer)state.m_61143_((Property)MULTIPART_SEGMENT) == 1) {
                result = result.m_121945_(direction.m_122428_());
            } else if (rot < 0 && (Integer)state.m_61143_((Property)MULTIPART_SEGMENT) == 2) {
                result = result.m_121945_(direction.m_122427_());
            }
        }
        return result;
    }

    public static final class BasicRotatedConnectableBlock
    extends AbstractRotatedConnectableBlock {
        public BasicRotatedConnectableBlock(BlockBehaviour.Properties properties) {
            super(properties);
        }
    }
}

