/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.block.abstractions;

import de.mrjulsen.paw.block.abstractions.AbstractRotatableBlock;
import de.mrjulsen.paw.block.abstractions.AbstractRotatableWireConnectorBlock;
import de.mrjulsen.paw.block.extended.BlockPlaceContextExtension;
import de.mrjulsen.wires.block.WireConnectorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec2;

public abstract class AbstractSupportedRotatableWireConnectorBlock<T extends WireConnectorBlockEntity>
extends AbstractRotatableWireConnectorBlock<T> {
    public AbstractSupportedRotatableWireConnectorBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPlaceContextExtension ctxExt = (BlockPlaceContextExtension)context;
        Direction direction = context.m_43719_();
        BlockPos clickPos = context.m_8083_().m_121945_(direction.m_122424_());
        Level level = context.m_43725_();
        BlockState clickedState = level.m_8055_(clickPos);
        BlockState state = super.m_49966_();
        Direction targetDir = direction;
        int targetRotationIdx = 1;
        if (direction.m_122434_() != Direction.Axis.Y && clickedState.m_60734_() instanceof AbstractRotatableBlock) {
            targetDir = direction;
            targetRotationIdx = (Integer)clickedState.m_61143_((Property)ROTATION);
        } else if (direction.m_122434_() != Direction.Axis.Y && this.canBePlacedAt((LevelReader)level, clickPos, clickedState, ctxExt.getPlacedOnPos(), ctxExt.getPlacedOnState(), context.m_43719_())) {
            targetDir = context.m_43719_();
            targetRotationIdx = 1;
        } else {
            Direction dir;
            int rot = Mth.m_14107_((double)((double)((180.0f + context.m_7074_()) * 16.0f / 360.0f) + 0.5)) & 0xF;
            int steps = 4;
            targetDir = dir = Direction.m_122407_((int)((rot + 2) / 4));
            targetRotationIdx = 3 - (rot + 2) % 4;
        }
        state = (BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)targetDir)).m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(targetRotationIdx));
        return state;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        return this.m_7898_(state, (LevelReader)level, currentPos) ? super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos) : Blocks.f_50016_.m_49966_();
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockState supportState;
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos relativePos = this.getSupportingBlockPos(state, level, pos);
        return this.canBePlacedAt(level, pos, state, relativePos, supportState = level.m_8055_(relativePos), direction.m_122424_()) && (supportState.m_60734_() instanceof AbstractRotatableBlock ? (int)this.getRelativeYRotation(supportState) : 0) == (int)this.getRelativeYRotation(state);
    }

    @Override
    public Vec2 getOffset(BlockState state) {
        if ((Integer)state.m_61143_((Property)ROTATION) < 3) {
            return new Vec2(0.0f, 0.0f);
        }
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.WEST -> new Vec2(0.0f, -1.0f);
            case Direction.EAST -> new Vec2(0.0f, 1.0f);
            case Direction.SOUTH -> new Vec2(-1.0f, 0.0f);
            default -> new Vec2(1.0f, 0.0f);
        };
    }

    public BlockPos getSupportingBlockPos(BlockState selfState, LevelReader level, BlockPos selfPos) {
        return this.getSupportBlockPos((BlockGetter)level, selfPos, selfState);
    }

    protected boolean allowSturdyFaceConnections() {
        return true;
    }

    protected boolean canBePlacedAt(LevelReader level, BlockPos pos, BlockState state, BlockPos otherPos, BlockState otherState, Direction direction) {
        return otherState.m_204336_(this.getSupportBlockTag()) || this.allowSturdyFaceConnections() && otherState.m_60783_((BlockGetter)level, otherPos, direction);
    }

    protected abstract TagKey<Block> getSupportBlockTag();
}

