/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.block.abstractions;

import de.mrjulsen.paw.data.BlockModificationData;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public interface IRotatableBlock {
    public float getRelativeYRotation(BlockState var1);

    public float getYRotation(BlockState var1);

    @Nullable
    default public Direction.Axis transformOnAxis(BlockState state) {
        return null;
    }

    default public Vec2 getRotationPivotPoint(BlockState state) {
        return Vec2.f_82462_;
    }

    default public Vec2 rotatedPivotPoint(BlockState state) {
        return this.getRotationPivotPoint(state);
    }

    public VoxelShape getBaseShape(BlockState var1, BlockGetter var2, BlockPos var3, CollisionContext var4);

    @OnlyIn(value=Dist.CLIENT)
    public BlockHitResult checkClickedFace(Level var1, Player var2, BlockHitResult var3);

    default public Vec2 getOffset(BlockState state) {
        return Vec2.f_82462_;
    }

    default public double getScaleForRotation(BlockState state) {
        return 1.0 / Math.cos(Math.abs(Math.toRadians(this.getRelativeYRotation(state))));
    }

    @Nullable
    default public BlockModificationData onPlaceOnRotatedBlock(BlockPlaceContext context, BlockState clickedState, BlockPos clickedBlockPos) {
        if (this.getRelativeYRotation(clickedState) > 40.0f && this.getRelativeYRotation(clickedState) < 50.0f) {
            return new BlockModificationData(context.m_8083_().m_121945_(context.m_43719_().m_122428_()), context.m_43719_());
        }
        return null;
    }

    @Nullable
    default public BlockModificationData onPlaceOnOtherRotatedBlock(@Nullable BlockModificationData currentModification, BlockPlaceContext context, BlockState clickedState, BlockPos clickedBlockPos) {
        return currentModification;
    }
}

