/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.block.abstractions;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChangeOverTimeBlock;
import net.minecraft.world.level.block.state.BlockState;

public interface IWeatheringBlock<T extends Block>
extends ChangeOverTimeBlock<WeatherState> {
    public Supplier<T> getNextState();

    default public Optional<T> getNext(Block block) {
        return Optional.ofNullable(this.getNextState() == null ? null : (Block)this.getNextState().get());
    }

    default public Optional<BlockState> m_142123_(BlockState state) {
        return this.getNext(state.m_60734_()).map(arg2 -> arg2.m_152465_(state));
    }

    default public float m_142377_() {
        return this.m_142297_() == WeatherState.UNAFFECTED ? 0.3f : 0.4f;
    }

    public static enum WeatherState {
        UNAFFECTED("", true),
        EXPOSED("exposed", true),
        WEATHERED("weathered", true),
        OXIDIZED("oxidized", true),
        GALVANIZED("galvanized", false);

        final String name;
        final boolean canOxidize;
        static final WeatherState[] oxidationStates;

        private WeatherState(String name, boolean canOxidize) {
            this.name = name;
            this.canOxidize = canOxidize;
        }

        public String getname() {
            return this.name;
        }

        public static WeatherState[] oxidationStates() {
            return oxidationStates;
        }

        static {
            oxidationStates = (WeatherState[])Arrays.stream(WeatherState.values()).filter(x -> x.canOxidize).toArray(WeatherState[]::new);
        }
    }
}

