/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.block.model;

import com.mojang.math.Axis;
import de.mrjulsen.mcdragonlib.client.model.ModelContext;
import de.mrjulsen.mcdragonlib.client.model.mesh.DLModel;
import de.mrjulsen.mcdragonlib.client.model.mesh.Face;
import de.mrjulsen.mcdragonlib.client.model.mesh.Mesh;
import de.mrjulsen.paw.block.abstractions.IConicalShape;
import de.mrjulsen.paw.block.abstractions.IRotatableBlock;
import de.mrjulsen.paw.client.model.ETransformationType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec2;
import org.joml.Vector3f;

public abstract class AbstractRotatableBlockModel
extends DLModel {
    protected abstract Mesh getBaseMesh(DLModel.ModelType var1, BakedModel var2, BlockState var3, RandomSource var4, ModelContext var5);

    protected Mesh getMesh(DLModel.ModelType type, BakedModel originalModel, BlockState state, RandomSource random, ModelContext context) {
        Mesh mesh = this.getBaseMesh(type, originalModel, state, random, context);
        Block block = state.m_60734_();
        if (block instanceof IRotatableBlock) {
            Block face3;
            IRotatableBlock rot = (IRotatableBlock)block;
            Vec2 pivot2D = rot.getRotationPivotPoint(state);
            Vector3f pivot = new Vector3f(pivot2D.f_82470_ + 0.5f, 0.0f, pivot2D.f_82471_ + 0.5f);
            Direction.Axis axis = rot.transformOnAxis(state);
            float scaleFactor = (float)rot.getScaleForRotation(state);
            ETransformationType typeFlag = ETransformationType.NONE;
            for (Face face2 : mesh.getFaces()) {
                typeFlag = ETransformationType.getByIndex(face2.getTintIndex());
                if (axis == null || !typeFlag.isScale()) continue;
                Vector3f scaleVec = switch (axis) {
                    case Direction.Axis.X -> new Vector3f(scaleFactor, 1.0f, 1.0f);
                    case Direction.Axis.Z -> new Vector3f(1.0f, 1.0f, scaleFactor);
                    default -> new Vector3f(1.0f, 1.0f, 1.0f);
                };
                face2.scale(scaleVec, pivot);
            }
            float angleRadians = (float)Math.toRadians(rot.getRelativeYRotation(state));
            float h = 1.0f / (float)Math.cos(angleRadians);
            Direction facing = (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            for (Block face3 : mesh.getFaces()) {
                typeFlag = ETransformationType.getByIndex(face3.getTintIndex());
                if (axis == null || typeFlag != ETransformationType.TRANSLATE) continue;
                switch (axis) {
                    case X: {
                        face3.translate((float)facing.m_122421_().m_122540_() * (1.0f - h), 0.0f, 0.0f);
                        break;
                    }
                    case Z: {
                        face3.translate(0.0f, 0.0f, (float)facing.m_122421_().m_122540_() * (1.0f - h));
                        break;
                    }
                }
            }
            face3 = state.m_60734_();
            if (face3 instanceof IConicalShape) {
                IConicalShape cone = (IConicalShape)face3;
                Vec2 coneTarget = cone.coneTarget(state);
                Vec2 coneOffset = cone.coneOffset(state);
                mesh.getTransformableElements().forEach(v -> {
                    Vector3f pos = v.getPos();
                    double sX = -Math.signum(pos.x - coneTarget.f_82470_);
                    double sZ = -Math.signum(pos.z - coneTarget.f_82471_);
                    pos.add((float)(sX * (double)pos.y * (double)coneOffset.f_82470_), 0.0f, (float)(sZ * (double)pos.y * (double)coneOffset.f_82471_));
                });
            }
            mesh.rotate(Axis.f_252436_.m_252977_(rot.getRelativeYRotation(state)), pivot);
            Vec2 offset = rot.getOffset(state);
            mesh.translate(offset.f_82470_, 0.0f, offset.f_82471_);
        }
        mesh.cleanUp();
        return mesh;
    }
}

