/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.block.model;

import com.mojang.math.Axis;
import de.mrjulsen.mcdragonlib.client.model.ModelContext;
import de.mrjulsen.mcdragonlib.client.model.mesh.BasicMesh;
import de.mrjulsen.mcdragonlib.client.model.mesh.CornerType;
import de.mrjulsen.mcdragonlib.client.model.mesh.CubeMesh;
import de.mrjulsen.mcdragonlib.client.model.mesh.DLModel;
import de.mrjulsen.mcdragonlib.client.model.mesh.Edge;
import de.mrjulsen.mcdragonlib.client.model.mesh.EdgeType;
import de.mrjulsen.mcdragonlib.client.model.mesh.Face;
import de.mrjulsen.mcdragonlib.client.model.mesh.FaceVertex;
import de.mrjulsen.mcdragonlib.client.model.mesh.Mesh;
import de.mrjulsen.mcdragonlib.client.model.mesh.Vertex;
import de.mrjulsen.mcdragonlib.util.MathUtils;
import de.mrjulsen.paw.block.CantileverBlock;
import de.mrjulsen.paw.block.abstractions.AbstractCantileverBlock;
import de.mrjulsen.paw.block.property.ECantileverMastConnection;
import de.mrjulsen.paw.block.property.EInsulatorType;
import de.mrjulsen.paw.blockentity.CantileverBlockEntity;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec2;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CantileverModel
extends DLModel {
    protected Mesh getMesh(DLModel.ModelType type, BakedModel originalModel, BlockState state, RandomSource random, ModelContext context) {
        CantileverBlockEntity.CantileverData[] cantileverDataArray;
        ECantileverMastConnection mastConnection;
        float width = context.has(CantileverBlockEntity.PROPERTY_WIDTH) ? ((Float)context.get(CantileverBlockEntity.PROPERTY_WIDTH)).floatValue() : 2.5f;
        float height = context.has(CantileverBlockEntity.PROPERTY_HEIGHT) ? ((Float)context.get(CantileverBlockEntity.PROPERTY_HEIGHT)).floatValue() : 1.5f;
        AbstractCantileverBlock.ECantileverInsulatorsPlacement insulatorPlacement = context.has(CantileverBlockEntity.PROPERTY_INSULATOR_PLACEMENT) ? (AbstractCantileverBlock.ECantileverInsulatorsPlacement)context.get(CantileverBlockEntity.PROPERTY_INSULATOR_PLACEMENT) : AbstractCantileverBlock.ECantileverInsulatorsPlacement.BACK;
        AbstractCantileverBlock.ECantileverRegistrationArmType registrationArmType = context.has(CantileverBlockEntity.PROPERTY_REGISTRATION_ARM) ? (AbstractCantileverBlock.ECantileverRegistrationArmType)context.get(CantileverBlockEntity.PROPERTY_REGISTRATION_ARM) : AbstractCantileverBlock.ECantileverRegistrationArmType.CENTER;
        float catenaryHeight = context.has(CantileverBlockEntity.PROPERTY_CATENARY_HEIGHT) ? ((Float)context.get(CantileverBlockEntity.PROPERTY_CATENARY_HEIGHT)).floatValue() : 1.0f;
        boolean showBracing = context.has(CantileverBlockEntity.PROPERTY_SHOW_BRACING) ? (Boolean)context.get(CantileverBlockEntity.PROPERTY_SHOW_BRACING) : false;
        ECantileverMastConnection eCantileverMastConnection = mastConnection = context.has(CantileverBlockEntity.PROPERTY_MAST_CONNECTION_TYPE) ? (ECantileverMastConnection)((Object)context.get(CantileverBlockEntity.PROPERTY_MAST_CONNECTION_TYPE)) : ECantileverMastConnection.NONE;
        if (context.has(CantileverBlockEntity.PROPERTY_SUB_CANTILEVER_SETTINGS)) {
            cantileverDataArray = (CantileverBlockEntity.CantileverData[])context.get(CantileverBlockEntity.PROPERTY_SUB_CANTILEVER_SETTINGS);
        } else {
            CantileverBlockEntity.CantileverData[] cantileverDataArray2 = new CantileverBlockEntity.CantileverData[1];
            cantileverDataArray = cantileverDataArray2;
            cantileverDataArray2[0] = new CantileverBlockEntity.CantileverData(0.0f, 0.625f, 0.0f, width, height, 0.0f, registrationArmType, catenaryHeight, 0.0f, showBracing);
        }
        CantileverBlockEntity.CantileverData[] subCantilevers = cantileverDataArray;
        BasicMesh mesh = new BasicMesh();
        float steadyArmOffset = registrationArmType.getOffset();
        if (subCantilevers != null) {
            for (CantileverBlockEntity.CantileverData data : subCantilevers) {
                EInsulatorType eInsulatorType;
                float f = data.x();
                float f2 = data.y();
                float f3 = data.z();
                float f4 = data.width();
                Block block = state.m_60734_();
                if (block instanceof CantileverBlock) {
                    CantileverBlock block2 = (CantileverBlock)block;
                    eInsulatorType = block2.getInsulatorType();
                } else {
                    eInsulatorType = EInsulatorType.BROWN;
                }
                Mesh cantilever = this.createCantilever(random, f, f2, f3, f4, height, eInsulatorType, insulatorPlacement, data.frontYOffset(), data.registrationArm(), data.catenaryHeight(), data.registrationArm() == AbstractCantileverBlock.ECantileverRegistrationArmType.CENTER && data.catenaryHeight() == 1.0f && height == 1.5f && data.width() <= 1.5f ? 12.0f : 3.0f, 0.75f, steadyArmOffset, data.showBracing());
                mesh.combine(false, new Mesh[]{cantilever});
            }
            int cantileversCount = subCantilevers.length;
            if (cantileversCount > 1 || mastConnection != ECantileverMastConnection.NONE) {
                TextureAtlasSprite METAL = Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_).m_118316_(new ResourceLocation("pantographsandwires", "block/metal"));
                CantileverBlockEntity.CantileverData data = subCantilevers[0];
                float w = Math.max(0.5f, data.spacing() * (float)(cantileversCount - 1));
                CubeMesh mastBracketTop = null;
                CubeMesh mastBracketBottom = null;
                if (cantileversCount <= 1 && mastConnection == ECantileverMastConnection.HINGE) {
                    size = new Vector3f(0.1875f, 0.1875f, 0.25f);
                    mastBracketTop = new CubeMesh(new Vector3f(-data.x() - 0.125f, data.y() - 0.0625f, 0.375f), size);
                    mastBracketTop.getFaces().forEach(x -> {
                        x.setTexture(METAL);
                        x.autoUV();
                    });
                    mastBracketBottom = new CubeMesh(new Vector3f(-data.x() - 0.125f, -data.height(), 0.375f), size);
                    mastBracketBottom.getFaces().forEach(x -> {
                        x.setTexture(METAL);
                        x.autoUV();
                    });
                } else {
                    size = new Vector3f(0.0625f, 0.1875f, w + 0.375f);
                    mastBracketTop = new CubeMesh(new Vector3f(-data.x(), data.y() - 0.0625f, 0.5f - w / 2.0f - 0.1875f), size);
                    mastBracketTop.getFaces().forEach(x -> {
                        x.setTexture(METAL);
                        x.autoUV();
                    });
                    mastBracketBottom = new CubeMesh(new Vector3f(-data.x(), -data.height(), 0.5f - w / 2.0f - 0.1875f), size);
                    mastBracketBottom.getFaces().forEach(x -> {
                        x.setTexture(METAL);
                        x.autoUV();
                    });
                }
                mesh.combine(false, new Mesh[]{mastBracketTop, mastBracketBottom});
            }
        }
        mesh.cleanUp();
        Direction facing = (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        if (facing.m_122434_() == Direction.Axis.Z) {
            facing = facing.m_122424_();
        }
        Vector3f center = new Vector3f(0.5f, 0.0f, 0.5f);
        Block w = state.m_60734_();
        if (w instanceof AbstractCantileverBlock) {
            AbstractCantileverBlock rot = (AbstractCantileverBlock)w;
            float hAngle = rot.getRelativeYRotation(state);
            Vec2 p = rot.getRotationPivotPoint(state);
            Vector3f pivot = new Vector3f(-p.f_82471_, 0.0f, p.f_82470_).add((Vector3fc)center);
            mesh.rotate(Axis.f_252436_.m_252977_(hAngle), pivot);
            if ((Integer)state.m_61143_((Property)AbstractCantileverBlock.ROTATION) >= 3) {
                mesh.translate(0.0f, 0.0f, 1.0f);
            }
            mesh.rotate(Axis.f_252436_.m_252977_(facing.m_122435_() + 90.0f), center);
        }
        mesh.getFaces().forEach(x -> x.setCullface(null));
        return mesh;
    }

    private Mesh createCantilever(RandomSource random, float xOffset, float yOffset, float zOffset, float width, float height, EInsulatorType insulatorType, AbstractCantileverBlock.ECantileverInsulatorsPlacement insulators, float frontOffset, AbstractCantileverBlock.ECantileverRegistrationArmType registrationArmType, float wireOffsetY, float registrationArmAngle, float steadyArmLength, float steadyArmOffset, boolean showBracing) {
        boolean backPicked;
        boolean bracketTubeInsulatorPossible;
        TextureAtlasSprite TEXTURE = Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_).m_118316_(new ResourceLocation("pantographsandwires", "block/cantilever"));
        TextureAtlasSprite METAL = Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_).m_118316_(new ResourceLocation("pantographsandwires", "block/metal"));
        TextureAtlasSprite ANVIL = Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_).m_118316_(new ResourceLocation("pantographsandwires", "block/anvil"));
        float bracketTubeThickness = 0.0625f;
        float thickness = 0.0625f;
        float holderThinkness = 0.0625f;
        float steadyArmBodyHeight = 0.09375f;
        float wireAttachThickness = 0.125f;
        float insulatorPostDistance = 0.0625f;
        float rawWidth = width;
        float insulatorHalfWidth = 0.35f;
        float insulatorHeight = 0.2f;
        float insulatorX = (width += xOffset) * insulators.getPlacementOffsetFac();
        float supportZ = zOffset - 0.03125f;
        float z = zOffset - 0.03125f;
        float z2 = zOffset - 0.03125f;
        registrationArmAngle *= (float)(registrationArmType == AbstractCantileverBlock.ECantileverRegistrationArmType.INNER ? 1 : -1);
        BasicMesh cantileverMesh = new BasicMesh();
        Vector3f bracketTubeOrigin = new Vector3f(rawWidth, yOffset + frontOffset, supportZ);
        CubeMesh bracketTube = new CubeMesh(bracketTubeOrigin, new Vector3f(0.0f, 0.0625f, 0.0625f));
        Face bracketTubeWest = bracketTube.getFaceOnSide(Direction.WEST);
        bracketTubeWest.getEdge(EdgeType.BOTTOM).getTransformableElements().forEach(t -> t.getPos().set(-xOffset, -height, t.getPos().z()));
        float bracketTubeAngle = CantileverModel.calcAngle(width, height);
        double bracketTubeAngleRas = Math.toRadians(bracketTubeAngle);
        double hypotenuse = 0.0625 / Math.cos(bracketTubeAngleRas);
        Edge bracketTubeTopWestEdge = bracketTubeWest.getEdge(EdgeType.TOP);
        bracketTubeTopWestEdge.getTransformableElements().forEach(t -> t.getPos().set((double)(-xOffset), (double)(-height) + hypotenuse, (double)t.getPos().z()));
        Face bracketTubeEast = bracketTube.getFaceOnSide(Direction.EAST);
        bracketTubeAngle = CantileverModel.calcAngle(width, Math.abs(bracketTubeOrigin.y() - bracketTubeTopWestEdge.center().y() + 0.0625f));
        bracketTubeEast.rotate(Axis.f_252403_.m_252977_(bracketTubeAngle), bracketTubeEast.getEdge(EdgeType.TOP).center());
        bracketTubeEast.translate(new Vector3f((Vector3fc)bracketTubeEast.getNormal()).mul(0.0625f));
        Vector3f bracketTubeNormal = bracketTube.getFaceOnSide(Direction.EAST).getNormal();
        Vector3f stayTubeOrigin = new Vector3f(-xOffset, yOffset, z);
        CubeMesh stayTube = new CubeMesh(stayTubeOrigin, new Vector3f(0.0f, 0.0625f, 0.0625f));
        float stayTubeAngle = CantileverModel.calcAngle(width, frontOffset);
        stayTube.rotate(Axis.f_252403_.m_252977_(stayTubeAngle), stayTubeOrigin);
        Vector3f stayTubeNormal = stayTube.getFaceOnSide(Direction.EAST).getNormal();
        Face stayTubeEast = stayTube.getFaceOnSide(Direction.EAST);
        Vector3f[] bracketTubeCollisionPlane = bracketTube.getFaceOnSide(Direction.UP).getVertexPositionArray();
        for (FaceVertex vert : stayTubeEast.getCorners()) {
            Vertex v = vert.getVertex();
            v.setPos(CantileverModel.intersectRayWithQuads(new Vector3f[][]{bracketTubeCollisionPlane}, v.getPos(), stayTubeNormal, false, 0.0f).orElse(v.getPos()));
        }
        BasicMesh steadyArm = new BasicMesh();
        Vector3f registrationArmAttachPoint = new Vector3f();
        Vector3f steadyArmBaseOrigin = new Vector3f(rawWidth - 0.03125f + steadyArmOffset, -wireOffsetY, zOffset - 0.0625f);
        CubeMesh steadyArmBase = new CubeMesh(steadyArmBaseOrigin, new Vector3f(0.0625f, 0.125f, 0.125f));
        steadyArm.combine(false, new Mesh[]{steadyArmBase});
        if (registrationArmType != AbstractCantileverBlock.ECantileverRegistrationArmType.CENTER) {
            Vector3f steadyArmBodyOrigin = new Vector3f((Vector3fc)steadyArmBase.getFaceOnSide(Direction.UP).getEdge(EdgeType.RIGHT).center()).add(-steadyArmLength, -0.046875f, -0.015625f);
            CubeMesh steadyArmBody = new CubeMesh(steadyArmBodyOrigin, new Vector3f(steadyArmLength, 0.09375f, 0.03125f));
            steadyArmBody.rotate(Axis.f_252403_.m_252977_(-5.0f), steadyArmBase.getFaceOnSide(Direction.UP).center());
            steadyArmBody.rotate(Axis.f_252436_.m_252977_(registrationArmType == AbstractCantileverBlock.ECantileverRegistrationArmType.OUTER ? 180.0f : 0.0f), steadyArmBase.getFaceOnSide(Direction.UP).center());
            Vector3f steadyArmRootOrigin = new Vector3f((Vector3fc)steadyArmBody.getFaceOnSide(Direction.WEST).getEdge(EdgeType.BOTTOM).center()).add(-0.03125f, -0.03125f, -0.03125f);
            CubeMesh steadyArmRoot = new CubeMesh(steadyArmRootOrigin, new Vector3f(0.0625f, 0.21875f, 0.0625f));
            steadyArm.combine(false, new Mesh[]{steadyArmBody, steadyArmRoot});
            registrationArmAttachPoint = steadyArmRoot.getFaceOnSide(Direction.UP).center();
            steadyArmBody.getFaces().forEach(x -> {
                x.setTexture(METAL);
                x.autoUV(CornerType.TOP_LEFT, 0.5f);
            });
            steadyArmRoot.getFaces().forEach(x -> {
                x.setTexture(METAL);
                x.autoUV(CornerType.TOP_LEFT, 0.5f);
            });
        } else {
            registrationArmAttachPoint = steadyArmBase.getFaceOnSide(Direction.UP).getEdge(EdgeType.RIGHT).center();
        }
        Vector3f registrationArmOrigin = new Vector3f((Vector3fc)registrationArmAttachPoint).add(0.0f, -0.03125f, -0.03125f);
        CubeMesh registrationArm = new CubeMesh(registrationArmOrigin, new Vector3f(0.0625f, 0.0625f, 0.0625f));
        registrationArm.rotate(Axis.f_252403_.m_252977_(registrationArmAngle), registrationArmOrigin);
        Vector3f registrationArmNormal = registrationArm.getFaceOnSide(Direction.EAST).getNormal();
        float extendedLength = switch (registrationArmType) {
            case AbstractCantileverBlock.ECantileverRegistrationArmType.INNER -> 1.1f;
            case AbstractCantileverBlock.ECantileverRegistrationArmType.OUTER -> 0.1f;
            default -> 0.0f;
        };
        registrationArm.translate(new Vector3f((Vector3fc)registrationArmNormal).mul(extendedLength));
        Face registrationArmWest = registrationArm.getFaceOnSide(Direction.WEST);
        Vector3f registrationArmWestNormal = registrationArmWest.getNormal();
        Vector3f[] registrationArmCollisionPlane = bracketTube.getFaceOnSide(Direction.DOWN).getVertexPositionArray();
        for (FaceVertex vert : registrationArmWest.getCorners()) {
            Vertex v = vert.getVertex();
            v.setPos(CantileverModel.intersectRayWithQuads(new Vector3f[][]{registrationArmCollisionPlane, {new Vector3f(-xOffset, 0.0f, 0.0f), new Vector3f(-xOffset, 1.0f, 0.0f), new Vector3f(-xOffset, 1.0f, 1.0f), new Vector3f(-xOffset, 0.0f, 1.0f)}}, v.getPos(), registrationArmWestNormal, false, 0.0f).orElse(v.getPos()));
        }
        Vector3f registrationArmConnectPoint = registrationArm.getFaceOnSide(Direction.WEST).center();
        float registrationArmYDistToBracketTube = Math.max(0.0f, bracketTubeWest.center().y() - registrationArmWest.center().y());
        float stayTubeLength = stayTube.getFaceOnSide(Direction.EAST).center().distance((Vector3fc)stayTube.getFaceOnSide(Direction.WEST).center());
        float stayTubeInsulatorMinDistance = CantileverModel.calcAdjacent(bracketTubeAngle - stayTubeAngle, (float)CantileverModel.lerp(0.2f, 0.35f, bracketTubeAngle / 90.0f)) + 0.35f;
        float stayTubeInsulatorMaxDistance = stayTubeLength - CantileverModel.calcHypotenuseFromAdjacent(stayTubeAngle, (float)CantileverModel.lerp(0.35f, 0.2f, stayTubeAngle / 90.0f) + 0.0625f);
        float stayTubeInsulatorDistance = CantileverModel.calcHypotenuseFromAdjacent(stayTubeAngle, width - insulatorX + 0.35f);
        if (stayTubeInsulatorMaxDistance > stayTubeInsulatorMinDistance) {
            Vector3f stayTubeInsulatorPos = new Vector3f((Vector3fc)stayTubeNormal).negate().mul(MathUtils.clamp((float)stayTubeInsulatorDistance, (float)stayTubeInsulatorMinDistance, (float)stayTubeInsulatorMaxDistance));
            BasicMesh stayTubeInsulatorMesh = BasicMesh.fromBlock((BlockState)insulatorType.getInsulatorBlock().m_49966_(), (RandomSource)random);
            stayTubeInsulatorMesh.rotate(Axis.f_252403_.m_252977_(-90.0f + stayTubeAngle), stayTubeInsulatorMesh.center());
            stayTubeInsulatorMesh.centerTo(stayTube.getFaceOnSide(Direction.EAST).center());
            stayTubeInsulatorMesh.translate(stayTubeInsulatorPos);
            cantileverMesh.combine(false, new Mesh[]{stayTubeInsulatorMesh});
        }
        Vector3f registrationArmEastPos = registrationArm.getFaceOnSide(Direction.EAST).center();
        float registrationArmLengthOffset = CantileverModel.calcHypotenuseFromAdjacent(registrationArmAngle, registrationArmEastPos.x() - Math.min(steadyArmBaseOrigin.x(), registrationArmAttachPoint.x())) + (registrationArmType == AbstractCantileverBlock.ECantileverRegistrationArmType.CENTER ? 0.35f : 0.0f);
        float registrationArmLength = registrationArmEastPos.distance((Vector3fc)registrationArm.getFaceOnSide(Direction.WEST).center()) - registrationArmLengthOffset - 0.0625f;
        float registrationArmInsulatorMaxDistance = registrationArmLength - CantileverModel.calcAdjacent(bracketTubeAngle - registrationArmAngle, Math.max(0.0f, 0.2f - registrationArmYDistToBracketTube)) - 0.35f;
        float registrationArmInsulatorMinDistance = 0.35f;
        float registrationArmInsulatorDistance = CantileverModel.calcHypotenuseFromAdjacent(registrationArmAngle, Math.max(width, steadyArmBaseOrigin.x()) - insulatorX);
        boolean registrationArmPossible = registrationArmInsulatorMaxDistance > registrationArmInsulatorMinDistance;
        Vector3f registrationArmInsulatorPos = new Vector3f((Vector3fc)registrationArmNormal).negate().mul(registrationArmLengthOffset + MathUtils.clamp((float)registrationArmInsulatorDistance, (float)registrationArmInsulatorMinDistance, (float)registrationArmInsulatorMaxDistance));
        BasicMesh registrationArmInsulatorMesh = BasicMesh.fromBlock((BlockState)insulatorType.getInsulatorBlock().m_49966_(), (RandomSource)random);
        registrationArmInsulatorMesh.rotate(Axis.f_252403_.m_252977_(-90.0f + registrationArmAngle), registrationArmInsulatorMesh.center());
        registrationArmInsulatorMesh.centerTo(registrationArm.getFaceOnSide(Direction.EAST).center());
        registrationArmInsulatorMesh.translate(registrationArmInsulatorPos);
        Vector3f bracketTubeEastPos = bracketTube.getFaceOnSide(Direction.EAST).center();
        float bracketTubeStartX = bracketTubeEastPos.x() - stayTubeEast.center().x();
        float bracketTubeLengthOffset = CantileverModel.calcHypotenuseFromAdjacent(registrationArmAngle, bracketTubeStartX);
        float bracketTubeLength = bracketTubeEastPos.distance((Vector3fc)bracketTube.getFaceOnSide(Direction.WEST).center()) - bracketTubeLengthOffset;
        float bracketTubeInsulatorMinDistance = CantileverModel.calcAdjacent(bracketTubeAngle - stayTubeAngle, (float)CantileverModel.lerp(0.2f, 0.35f, bracketTubeAngle / 90.0f)) + 0.35f;
        float bracketTubeInsulatorMaxDistance = bracketTubeLength - CantileverModel.calcHypotenuseFromAdjacent(bracketTubeAngle, Math.max(0.0f, (float)CantileverModel.lerp(0.35f, 0.2f, bracketTubeAngle / 90.0f) - registrationArmYDistToBracketTube) + 0.0625f);
        float bracketTubeInsulatorRDistance = CantileverModel.calcHypotenuseFromAdjacent(bracketTubeAngle, bracketTube.getFaceOnSide(Direction.EAST).getEdge(EdgeType.BOTTOM).center().x() - registrationArmConnectPoint.x()) - bracketTubeLengthOffset;
        float bracketTubeInsulatorLDistance = bracketTubeInsulatorRDistance + 0.35f + CantileverModel.calcHypotenuseFromOpposite(bracketTubeAngle - registrationArmAngle, 0.03125f);
        float bracketTubeInsulatorUDistance = bracketTubeInsulatorRDistance - CantileverModel.calcAdjacent(bracketTubeAngle - registrationArmAngle, Math.max(0.0625f, 0.2f - registrationArmYDistToBracketTube)) - 0.35f;
        float bracketTubeInsulatorDistance = CantileverModel.calcHypotenuseFromAdjacent(bracketTubeAngle, width - insulatorX + 0.35f);
        boolean upperPossible = bracketTubeInsulatorMinDistance < bracketTubeInsulatorUDistance && registrationArmPossible;
        boolean lowerPossible = bracketTubeInsulatorLDistance < bracketTubeInsulatorMaxDistance;
        float result = 0.0f;
        if (upperPossible && lowerPossible && bracketTubeInsulatorDistance > bracketTubeInsulatorUDistance && bracketTubeInsulatorDistance < bracketTubeInsulatorLDistance) {
            result = CantileverModel.closestEdge(bracketTubeInsulatorDistance, bracketTubeInsulatorUDistance, bracketTubeInsulatorLDistance);
        } else if (upperPossible || lowerPossible) {
            float lowerBound = lowerPossible ? bracketTubeInsulatorMaxDistance : Math.min(bracketTubeInsulatorMaxDistance, bracketTubeInsulatorUDistance);
            float upperBound = upperPossible ? bracketTubeInsulatorMinDistance : Math.max(bracketTubeInsulatorMinDistance, bracketTubeInsulatorLDistance);
            result = MathUtils.clamp((float)bracketTubeInsulatorDistance, (float)upperBound, (float)lowerBound);
        }
        boolean bl = bracketTubeInsulatorPossible = result > 0.0f;
        if (bracketTubeInsulatorPossible) {
            Vector3f bracketTubeInsulatorPos = new Vector3f((Vector3fc)bracketTubeNormal).negate().mul(bracketTubeLengthOffset + result);
            BasicMesh bracketTubeInsulatorMesh = BasicMesh.fromBlock((BlockState)insulatorType.getInsulatorBlock().m_49966_(), (RandomSource)random);
            bracketTubeInsulatorMesh.rotate(Axis.f_252403_.m_252977_(-90.0f + bracketTubeAngle), bracketTubeInsulatorMesh.center());
            bracketTubeInsulatorMesh.centerTo(bracketTube.getFaceOnSide(Direction.EAST).center());
            bracketTubeInsulatorMesh.translate(bracketTubeInsulatorPos);
            cantileverMesh.combine(false, new Mesh[]{bracketTubeInsulatorMesh});
        }
        if (registrationArmPossible && result < bracketTubeInsulatorLDistance) {
            cantileverMesh.combine(false, new Mesh[]{registrationArmInsulatorMesh});
        }
        boolean bracigBehindInsulator = width * insulators.getPlacementOffsetFac() > 0.5375f;
        Vector3f bracingOrigin = new Vector3f((bracigBehindInsulator ? 0.0f : 0.7f) - xOffset + 0.0625f, yOffset, z2);
        CubeMesh bracing = new CubeMesh(bracingOrigin, new Vector3f(0.0f, 0.0625f, 0.0625f));
        float bracingAngle = CantileverModel.calcAngle(registrationArmWest.getEdge(EdgeType.TOP).center().x() - bracingOrigin.x() - 0.0625f, registrationArmWest.getEdge(EdgeType.TOP).center().y() - bracingOrigin.y() - 0.0625f);
        boolean bl2 = backPicked = lowerPossible && !upperPossible || insulators == AbstractCantileverBlock.ECantileverInsulatorsPlacement.BACK;
        if (showBracing && Math.abs(bracingAngle) < 90.0f && bracigBehindInsulator != backPicked) {
            bracing.rotate(Axis.f_252403_.m_252977_(bracingAngle), bracingOrigin);
            Face bracingWest = bracing.getFaceOnSide(Direction.WEST);
            Vector3f bracingWestNormal = bracingWest.getNormal();
            bracingWest.translate(new Vector3f((Vector3fc)bracingWestNormal).negate());
            Vector3f[] bracingCollisionPlaneDown = stayTube.getFaceOnSide(Direction.DOWN).getVertexPositionArray();
            for (FaceVertex vert : bracingWest.getCorners()) {
                Vertex v = vert.getVertex();
                v.setPos(CantileverModel.intersectRayWithQuads(new Vector3f[][]{bracingCollisionPlaneDown}, v.getPos(), bracingWestNormal, false, 0.0f).orElse(v.getPos()));
            }
            Face bracingEast = bracing.getFaceOnSide(Direction.EAST);
            Vector3f bracingEastNormal = bracingEast.getNormal();
            Vector3f[] bracingCollisionPlaneUp = bracketTube.getFaceOnSide(Direction.UP).getVertexPositionArray();
            for (FaceVertex vert : bracingEast.getCorners()) {
                Vertex v = vert.getVertex();
                v.setPos(CantileverModel.intersectRayWithQuads(new Vector3f[][]{bracingCollisionPlaneUp}, v.getPos(), bracingEastNormal, false, 0.0f).orElse(v.getPos()));
            }
            cantileverMesh.combine(false, new Mesh[]{bracing});
        }
        cantileverMesh.combine(false, new Mesh[]{stayTube, bracketTube, registrationArm, steadyArm});
        bracketTube.getFaces().forEach(x -> {
            x.setTexture(TEXTURE);
            x.autoUV(CornerType.TOP_LEFT, 0.5f);
        });
        stayTube.getFaces().forEach(x -> {
            x.setTexture(TEXTURE);
            x.autoUV(CornerType.TOP_LEFT, 0.5f);
        });
        steadyArmBase.getFaces().forEach(x -> {
            x.setTexture(ANVIL);
            x.autoUV(CornerType.TOP_LEFT, 0.5f);
        });
        registrationArm.getFaces().forEach(x -> {
            x.setTexture(TEXTURE);
            x.autoUV(CornerType.TOP_LEFT, 0.5f);
        });
        bracing.getFaces().forEach(x -> {
            x.setTexture(TEXTURE);
            x.autoUV(CornerType.TOP_LEFT, 0.5f);
        });
        cantileverMesh.cleanUp();
        return cantileverMesh;
    }

    public static float closestEdge(float input, float min, float max) {
        float distToMax;
        float distToMin = Math.abs(input - min);
        return distToMin <= (distToMax = Math.abs(input - max)) ? min : max;
    }

    private static float calcAngle(float width, float height) {
        double angleRad = Math.atan(height / width);
        double angleDeg = Math.toDegrees(angleRad);
        return (float)angleDeg;
    }

    private static float calcHypotenuseFromAdjacent(float angle, float adjacent) {
        double rad = Math.toRadians(angle);
        float result = adjacent / (float)Math.cos(rad);
        return result;
    }

    private static float calcHypotenuseFromOpposite(float angle, float opposite) {
        double rad = Math.toRadians(angle);
        float result = opposite / (float)Math.sin(rad);
        return result;
    }

    private static float calcAdjacent(float angle, float opposite) {
        double rad = Math.toRadians(angle);
        float result = (float)((double)opposite / Math.tan(rad));
        return result;
    }

    public static double lerp(double a, double b, double t) {
        return a + (b - a) * t;
    }

    public static double mapAngleToValue(double angleDegrees) {
        if (angleDegrees < 0.0) {
            angleDegrees = 0.0;
        }
        if (angleDegrees > 90.0) {
            angleDegrees = 90.0;
        }
        double t = angleDegrees / 90.0;
        return CantileverModel.lerp(0.3, 0.1, t);
    }

    public static Optional<Vector3f> intersectRayWithQuads(Vector3f[][] quads, Vector3f origin, Vector3f direction, boolean boundCheck, float maxDistance) {
        Vector3f closestIntersection = null;
        float closestT = Float.MAX_VALUE;
        for (Vector3f[] quad : quads) {
            if (quad == null || quad.length != 4) {
                throw new IllegalArgumentException("Each quad must have 4 vertices.");
            }
            Vector3f edge1 = new Vector3f();
            quad[1].sub((Vector3fc)quad[0], edge1);
            Vector3f edge2 = new Vector3f();
            quad[3].sub((Vector3fc)quad[0], edge2);
            Vector3f normal = new Vector3f();
            edge1.cross((Vector3fc)edge2, normal).normalize();
            float denom = normal.dot((Vector3fc)direction);
            if (Math.abs(denom) < 1.0E-6f) continue;
            Vector3f diff = new Vector3f();
            quad[0].sub((Vector3fc)origin, diff);
            float t = diff.dot((Vector3fc)normal) / denom;
            if (t < 0.0f || maxDistance > 0.0f && t > maxDistance) continue;
            Vector3f intersection = new Vector3f((Vector3fc)direction).mul(t).add((Vector3fc)origin);
            if (boundCheck && !CantileverModel.pointInTriangle(intersection, quad[0], quad[1], quad[2]) && !CantileverModel.pointInTriangle(intersection, quad[0], quad[2], quad[3]) || !(t < closestT)) continue;
            closestT = t;
            closestIntersection = intersection;
        }
        return Optional.ofNullable(closestIntersection);
    }

    private static boolean pointInTriangle(Vector3f p, Vector3f a, Vector3f b, Vector3f c) {
        Vector3f v0 = new Vector3f();
        Vector3f v1 = new Vector3f();
        Vector3f v2 = new Vector3f();
        c.sub((Vector3fc)a, v0);
        b.sub((Vector3fc)a, v1);
        p.sub((Vector3fc)a, v2);
        float d00 = v0.dot((Vector3fc)v0);
        float d01 = v0.dot((Vector3fc)v1);
        float d11 = v1.dot((Vector3fc)v1);
        float d20 = v2.dot((Vector3fc)v0);
        float d21 = v2.dot((Vector3fc)v1);
        float denom = d00 * d11 - d01 * d01;
        if (denom == 0.0f) {
            return false;
        }
        float v = (d11 * d20 - d01 * d21) / denom;
        float w = (d00 * d21 - d01 * d20) / denom;
        float u = 1.0f - v - w;
        return u >= 0.0f && v >= 0.0f && w >= 0.0f;
    }

    public static Vector3f getDirectionFromAngle(Direction.Axis axis, float degrees) {
        Quaternionf rotation = new Quaternionf();
        float radians = (float)Math.toRadians(degrees);
        switch (axis) {
            case X: {
                rotation.rotateX(radians);
                break;
            }
            case Y: {
                rotation.rotateY(radians);
                break;
            }
            case Z: {
                rotation.rotateZ(radians);
            }
        }
        Vector3f normal = new Vector3f(0.0f, 0.0f, -1.0f);
        rotation.transform(normal);
        return normal.normalize();
    }
}

