/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.block.model;

import de.mrjulsen.mcdragonlib.client.model.ModelContext;
import de.mrjulsen.mcdragonlib.client.model.mesh.BasicMesh;
import de.mrjulsen.mcdragonlib.client.model.mesh.DLModel;
import de.mrjulsen.mcdragonlib.client.model.mesh.Face;
import de.mrjulsen.mcdragonlib.client.model.mesh.Mesh;
import de.mrjulsen.paw.block.abstractions.IWeatheringBlock;
import de.mrjulsen.paw.block.model.AbstractRotatableBlockModel;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class OxidizedBlockModel
extends AbstractRotatableBlockModel {
    private final Set<ResourceLocation> oxidizingTextures;

    public OxidizedBlockModel(Set<ResourceLocation> oxidizingTextures) {
        this.oxidizingTextures = oxidizingTextures;
    }

    @Override
    protected Mesh getBaseMesh(DLModel.ModelType type, BakedModel originalModel, BlockState state, RandomSource random, ModelContext context) {
        BasicMesh mesh = OxidizedBlockModel.fromBakedModel(state, originalModel, random);
        Block block = state.m_60734_();
        if (block instanceof IWeatheringBlock) {
            IWeatheringBlock block2 = (IWeatheringBlock)block;
            IWeatheringBlock.WeatherState ws = (IWeatheringBlock.WeatherState)block2.m_142297_();
            HashMap<ResourceLocation, TextureAtlasSprite> oxidizedTextures = new HashMap<ResourceLocation, TextureAtlasSprite>(this.oxidizingTextures.size());
            for (ResourceLocation texture : this.oxidizingTextures) {
                oxidizedTextures.computeIfAbsent(texture, tex -> {
                    ResourceLocation newLocation = new ResourceLocation(tex.m_135827_(), tex.m_135815_() + (String)(ws.getname().isBlank() ? "" : "_" + ws.getname()));
                    return Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_).m_118316_(newLocation);
                });
            }
            mesh.getFaces().forEach(x -> {
                ResourceLocation location = x.getTexture().m_245424_().m_246162_();
                if (oxidizedTextures.containsKey(location)) {
                    x.setTexture((TextureAtlasSprite)oxidizedTextures.get(location));
                }
            });
        }
        return mesh;
    }

    public static BasicMesh fromBakedModel(BlockState state, BakedModel srcModel, RandomSource random) {
        BasicMesh mesh = new BasicMesh();
        Direction[] directions = new Direction[Direction.values().length + 1];
        System.arraycopy(Direction.values(), 0, directions, 0, Direction.values().length);
        for (Direction side : directions) {
            for (BakedQuad quad : srcModel.m_213637_(state, side, random)) {
                mesh.addFace(new Face(quad, side));
            }
        }
        return mesh;
    }
}

