/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.blockentity;

import de.mrjulsen.mcdragonlib.client.model.ICustomModelBlockEntity;
import de.mrjulsen.mcdragonlib.client.model.ModelContext;
import de.mrjulsen.mcdragonlib.data.Cache;
import de.mrjulsen.mcdragonlib.util.MathUtils;
import de.mrjulsen.paw.block.CantileverBlock;
import de.mrjulsen.paw.block.abstractions.AbstractCantileverBlock;
import de.mrjulsen.paw.block.property.ECantileverMastConnection;
import de.mrjulsen.paw.block.property.EInsulatorType;
import de.mrjulsen.paw.event.ClientWrapper;
import de.mrjulsen.paw.registry.ModBlocks;
import de.mrjulsen.paw.util.ModMath;
import de.mrjulsen.wires.block.WireConnectorBlockEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CantileverBlockEntity
extends WireConnectorBlockEntity
implements ICustomModelBlockEntity {
    public static final byte MAX_CANTILEVERS = 3;
    public static final float Z_POS = 0.5f;
    public static final float Y_POS = 0.625f;
    public static final ModelContext.ModelProperty<Float> PROPERTY_WIDTH = new ModelContext.ModelProperty();
    public static final ModelContext.ModelProperty<Float> PROPERTY_HEIGHT = new ModelContext.ModelProperty();
    public static final ModelContext.ModelProperty<AbstractCantileverBlock.ECantileverInsulatorsPlacement> PROPERTY_INSULATOR_PLACEMENT = new ModelContext.ModelProperty();
    public static final ModelContext.ModelProperty<AbstractCantileverBlock.ECantileverRegistrationArmType> PROPERTY_REGISTRATION_ARM = new ModelContext.ModelProperty();
    public static final ModelContext.ModelProperty<Boolean> PROPERTY_SHOW_BRACING = new ModelContext.ModelProperty();
    public static final ModelContext.ModelProperty<EInsulatorType> PROPERTY_INSULATOR_TYPE = new ModelContext.ModelProperty();
    public static final ModelContext.ModelProperty<Float> PROPERTY_CATENARY_HEIGHT = new ModelContext.ModelProperty();
    public static final ModelContext.ModelProperty<Byte> PROPERTY_CANTILEVERS_COUNT = new ModelContext.ModelProperty();
    public static final ModelContext.ModelProperty<ECantileverMastConnection> PROPERTY_MAST_CONNECTION_TYPE = new ModelContext.ModelProperty();
    public static final ModelContext.ModelProperty<CantileverData[]> PROPERTY_SUB_CANTILEVER_SETTINGS = new ModelContext.ModelProperty();
    public static final String NBT_WIDTH = "Width";
    public static final String NBT_HEIGHT = "Height";
    public static final String NBT_INSULATOR_PLACEMENT = "InsulatorPlacement";
    public static final String NBT_REGISTRATION_ARM_TYPE = "RegistrationArmType";
    public static final String NBT_SHOW_BRACING = "ShowBracing";
    public static final String NBT_INSULATOR_TYPE = "InsulatorType";
    public static final String NBT_CATENARY_HEIGHT = "CatenaryHeight";
    public static final String NBT_USE_SUPPORT_TUBE = "UseSupportTube";
    public static final String NBT_POST_CONNECTION_OFFSET = "PostConnectionOffset";
    public static final String NBT_MAST_CONNECTION_TYPE = "MastConnectionType";
    public static final String NBT_CANTILEVERS_COUNT = "CantileversCount";
    public static final String NBT_SUB_CANTILEVER_SETTINGS = "SubCantileverSettings";
    public static final float DEFAULT_WIDTH = 2.5f;
    public static final float DEFAULT_HEIGHT = 1.5f;
    public static final AbstractCantileverBlock.ECantileverInsulatorsPlacement DEFAULT_INSULATOR_PLACEMENT = AbstractCantileverBlock.ECantileverInsulatorsPlacement.BACK;
    public static final AbstractCantileverBlock.ECantileverRegistrationArmType DEFAULT_REGISTRATION_ARM_TYPE = AbstractCantileverBlock.ECantileverRegistrationArmType.CENTER;
    public static final EInsulatorType DEFAULT_INSULATOR_TYPE = EInsulatorType.BROWN;
    public static final boolean DEFAULT_SHOW_BRACING = false;
    public static final float DEFAULT_CATENARY_HEIGHT = 1.0f;
    public static final boolean DEFAULT_USE_SUPPORT_TUBE = false;
    public static final float DEFAULT_POST_CONNECTION_OFFSET = 0.0f;
    public static final ECantileverMastConnection DEFAULT_MAST_CONNECTION_TYPE = ECantileverMastConnection.NONE;
    public static final byte DEFAULT_CANTILEVERS_COUNT = 1;
    private float width = 2.5f;
    private float height = 1.5f;
    private AbstractCantileverBlock.ECantileverInsulatorsPlacement insulatorPlacement = DEFAULT_INSULATOR_PLACEMENT;
    private AbstractCantileverBlock.ECantileverRegistrationArmType registrationArmType = DEFAULT_REGISTRATION_ARM_TYPE;
    private EInsulatorType insulatorType = DEFAULT_INSULATOR_TYPE;
    private boolean showBracing = false;
    private float catenaryHeight = 1.0f;
    private boolean useSupportTube = false;
    private float postConnectionOffset = 0.0f;
    private ECantileverMastConnection mastConnectionType = DEFAULT_MAST_CONNECTION_TYPE;
    private byte cantileversCount = 1;
    private final SubCantileverSetting[] subCanileverSettings = new SubCantileverSetting[2];
    private boolean doNotUpdate;
    public final Cache<CantileverData[]> cantileverDataCache;

    public CantileverBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        Arrays.fill(this.subCanileverSettings, SubCantileverSetting.EMPTY);
        this.doNotUpdate = false;
        this.cantileverDataCache = new Cache(this::calcCantilevers);
    }

    @Override
    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128350_(NBT_WIDTH, this.width);
        nbt.m_128350_(NBT_HEIGHT, this.height);
        nbt.m_128405_(NBT_INSULATOR_PLACEMENT, this.insulatorPlacement.ordinal());
        nbt.m_128405_(NBT_REGISTRATION_ARM_TYPE, this.registrationArmType.ordinal());
        nbt.m_128379_(NBT_SHOW_BRACING, this.showBracing);
        nbt.m_128350_(NBT_INSULATOR_TYPE, (float)this.insulatorType.ordinal());
        nbt.m_128350_(NBT_CATENARY_HEIGHT, this.catenaryHeight);
        nbt.m_128350_(NBT_POST_CONNECTION_OFFSET, this.postConnectionOffset);
        nbt.m_128344_(NBT_MAST_CONNECTION_TYPE, this.mastConnectionType.getIndex());
        nbt.m_128344_(NBT_CANTILEVERS_COUNT, this.cantileversCount);
        nbt.m_128379_(NBT_USE_SUPPORT_TUBE, this.useSupportTube);
        ListTag list = new ListTag();
        for (SubCantileverSetting s : this.subCanileverSettings) {
            list.add((Object)(s == null ? SubCantileverSetting.EMPTY : s).toNbt());
        }
        nbt.m_128365_(NBT_SUB_CANTILEVER_SETTINGS, (Tag)list);
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.width = nbt.m_128457_(NBT_WIDTH);
        this.height = nbt.m_128457_(NBT_HEIGHT);
        this.insulatorPlacement = AbstractCantileverBlock.ECantileverInsulatorsPlacement.values()[nbt.m_128451_(NBT_INSULATOR_PLACEMENT)];
        this.registrationArmType = AbstractCantileverBlock.ECantileverRegistrationArmType.values()[nbt.m_128451_(NBT_REGISTRATION_ARM_TYPE)];
        this.showBracing = nbt.m_128471_(NBT_SHOW_BRACING);
        this.insulatorType = EInsulatorType.values()[nbt.m_128451_(NBT_INSULATOR_TYPE)];
        this.catenaryHeight = nbt.m_128457_(NBT_CATENARY_HEIGHT);
        this.postConnectionOffset = nbt.m_128457_(NBT_POST_CONNECTION_OFFSET);
        this.mastConnectionType = ECantileverMastConnection.getByIndex(nbt.m_128445_(NBT_MAST_CONNECTION_TYPE));
        this.cantileversCount = MathUtils.clamp((byte)nbt.m_128445_(NBT_CANTILEVERS_COUNT), (byte)1, (byte)3);
        this.useSupportTube = nbt.m_128471_(NBT_USE_SUPPORT_TUBE);
        Arrays.fill(this.subCanileverSettings, SubCantileverSetting.EMPTY);
        for (Tag tag : nbt.m_128437_(NBT_SUB_CANTILEVER_SETTINGS, 10)) {
            SubCantileverSetting s = SubCantileverSetting.fromNbt((CompoundTag)tag);
            byte idx = s.index();
            if (idx < 0 || idx >= this.subCanileverSettings.length) continue;
            this.subCanileverSettings[idx] = s;
        }
        this.updateModel();
        this.cantileverDataCache.clear();
    }

    public void setDoNotUpdate(boolean b) {
        this.doNotUpdate = b;
    }

    public boolean shouldNotUpdate() {
        return this.doNotUpdate;
    }

    private CantileverData[] calcCantilevers() {
        CantileverData[] dataArray = new CantileverData[this.getCantileversCount()];
        float spacing = 1.0f / (float)dataArray.length * 2.0f;
        float z = 0.5f - spacing * (float)(dataArray.length - 1) / 2.0f;
        ArrayList<Float> xPool = new ArrayList<Float>(dataArray.length);
        ArrayList<Float> yPool = new ArrayList<Float>(dataArray.length);
        float i = 0.0f;
        float x = -0.5f;
        float y = 0.5f;
        while (i < (float)dataArray.length) {
            xPool.add(Float.valueOf(x));
            yPool.add(Float.valueOf(y));
            i += 1.0f;
            x += 0.5f;
            y -= 0.5f;
        }
        Function<AbstractCantileverBlock.ECantileverRegistrationArmType, Vector2f> getter = reg -> switch (reg) {
            case AbstractCantileverBlock.ECantileverRegistrationArmType.INNER -> new Vector2f(((Float)xPool.remove(0)).floatValue(), ((Float)yPool.remove(0)).floatValue());
            case AbstractCantileverBlock.ECantileverRegistrationArmType.OUTER -> new Vector2f(((Float)xPool.remove(xPool.size() - 1)).floatValue(), ((Float)yPool.remove(yPool.size() - 1)).floatValue());
            default -> new Vector2f(((Float)xPool.remove(MathUtils.clamp((int)((int)Math.ceil((float)xPool.size() / 2.0f)), (int)0, (int)(xPool.size() - 1)))).floatValue(), ((Float)yPool.remove(MathUtils.clamp((int)((int)Math.ceil((float)yPool.size() / 2.0f)), (int)0, (int)(yPool.size() - 1)))).floatValue());
        };
        for (int i2 = 0; i2 < dataArray.length; ++i2) {
            float lw = this.getWidth();
            float dY = 0.0f;
            AbstractCantileverBlock.ECantileverRegistrationArmType lRegisterArm = this.getRegistrationArmType();
            boolean lShowBracing = this.getShowBracing();
            float lCatenaryHeight = this.getCatenaryHeight();
            if (dataArray.length > 1 && this.subCanileverSettings != null) {
                if (i2 <= 0) {
                    v = getter.apply(this.getRegistrationArmType());
                    lw += v.x();
                    dY += v.y();
                } else {
                    lRegisterArm = this.subCanileverSettings[i2 - 1].registrationArm();
                    lShowBracing = this.subCanileverSettings[i2 - 1].showBracing();
                    v = getter.apply(lRegisterArm);
                    lw += v.x();
                    dY += v.y();
                    if (this.getRegistrationArmType() != AbstractCantileverBlock.ECantileverRegistrationArmType.CENTER && this.subCanileverSettings[i2 - 1].registrationArm() == AbstractCantileverBlock.ECantileverRegistrationArmType.CENTER) {
                        lCatenaryHeight -= 0.5f;
                    }
                }
            }
            dataArray[i2] = new CantileverData(0.0625f * ((16.0f - this.getPostConnectionOffset()) / 2.0f), 0.625f, z, lw, this.getHeight(), dY, lRegisterArm, lCatenaryHeight, spacing, lShowBracing);
            z += spacing;
        }
        return dataArray;
    }

    public CantileverData[] getCantileverData() {
        return (CantileverData[])this.cantileverDataCache.get();
    }

    public CantileverShapeData getCantileverInteractionShape(int cantileverIndex) {
        CantileverData cantilever = this.getCantileverData()[cantileverIndex];
        BlockState state = this.m_58904_().m_8055_(this.m_58899_());
        Block block = state.m_60734_();
        if (!(block instanceof CantileverBlock)) {
            return new CantileverShapeData(new Vector3f(), new Vector3f(), new Vector3f());
        }
        CantileverBlock rot = (CantileverBlock)block;
        float size = cantilever.width();
        float z = -cantilever.x();
        float y = cantilever.y();
        float yFront = y + cantilever.frontYOffset();
        float height = cantilever.height() - 0.5f;
        float xOffset = cantilever.z();
        Vector3f a = new Vector3f(xOffset - 0.5f, y, 0.5f - z);
        Vector3f b = new Vector3f(xOffset - 0.5f, yFront, 0.5f - size);
        Vector3f c = new Vector3f(xOffset - 0.5f, -height - 0.5f, 0.5f - z);
        Vec2 pivot = rot.getRotationPivotPoint(state);
        Vec2 rotPivot = rot.rotatedPivotPoint(state);
        Vec2 offset = rot.getOffset(state);
        UnaryOperator transformFunc = vec -> ModMath.rotate(new Vector3f((Vector3fc)vec).sub(pivot.f_82470_, 0.0f, pivot.f_82471_), rot.getYRotation(state), Direction.Axis.Y).add(rotPivot.f_82470_, 0.0f, rotPivot.f_82471_).add(offset.f_82470_, 0.0f, offset.f_82471_);
        return new CantileverShapeData(((Vector3f)transformFunc.apply(a)).add((float)this.m_58899_().m_123341_(), (float)this.m_58899_().m_123342_(), (float)this.m_58899_().m_123343_()), ((Vector3f)transformFunc.apply(b)).add((float)this.m_58899_().m_123341_(), (float)this.m_58899_().m_123342_(), (float)this.m_58899_().m_123343_()), ((Vector3f)transformFunc.apply(c)).add((float)this.m_58899_().m_123341_(), (float)this.m_58899_().m_123342_(), (float)this.m_58899_().m_123343_()));
    }

    public ModelContext getModelContext() {
        SubCantileverSetting[] sub = new SubCantileverSetting[this.subCanileverSettings.length];
        System.arraycopy(this.subCanileverSettings, 0, sub, 0, this.subCanileverSettings.length);
        return ModelContext.builder().with(PROPERTY_WIDTH, (Object)Float.valueOf(this.width)).with(PROPERTY_HEIGHT, (Object)Float.valueOf(this.height)).with(PROPERTY_INSULATOR_PLACEMENT, (Object)this.insulatorPlacement).with(PROPERTY_REGISTRATION_ARM, (Object)this.registrationArmType).with(PROPERTY_SHOW_BRACING, (Object)this.showBracing).with(PROPERTY_INSULATOR_TYPE, (Object)this.insulatorType).with(PROPERTY_CATENARY_HEIGHT, (Object)Float.valueOf(this.catenaryHeight)).with(PROPERTY_CANTILEVERS_COUNT, (Object)this.cantileversCount).with(PROPERTY_MAST_CONNECTION_TYPE, (Object)this.mastConnectionType).with(PROPERTY_SUB_CANTILEVER_SETTINGS, (Object)((CantileverData[])this.cantileverDataCache.get())).build();
    }

    @Override
    public void onBlockEntityLoad() {
        Block block;
        if (this.m_58904_() != null && (block = this.m_58904_().m_8055_(this.m_58899_()).m_60734_()) instanceof AbstractCantileverBlock) {
            AbstractCantileverBlock cantilever = (AbstractCantileverBlock)block;
            BlockState support = this.m_58904_().m_8055_(cantilever.getSupportingBlockPos(this.m_58900_(), (LevelReader)this.f_58857_, this.m_58899_()));
            this.setPostConnectionOffset(ModBlocks.getFirstCantileverConnectionTagForState(support));
            this.setMastConnectionType(ECantileverMastConnection.getFirstForState(support));
        }
    }

    private void updateModel() {
        if (this.m_58904_() != null && this.m_58904_().m_5776_()) {
            ClientWrapper.setSectionDirty(SectionPos.m_123199_((BlockPos)this.m_58899_()));
        }
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        this.width = width;
        this.update();
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float height) {
        this.height = height;
        this.update();
    }

    public AbstractCantileverBlock.ECantileverInsulatorsPlacement getInsulatorPlacement() {
        return this.insulatorPlacement;
    }

    public void setInsulatorPlacement(AbstractCantileverBlock.ECantileverInsulatorsPlacement insulatorPlacement) {
        this.insulatorPlacement = insulatorPlacement;
        this.update();
    }

    public AbstractCantileverBlock.ECantileverRegistrationArmType getRegistrationArmType() {
        return this.registrationArmType;
    }

    public void setRegistrationArmType(AbstractCantileverBlock.ECantileverRegistrationArmType registrationArmType) {
        this.registrationArmType = registrationArmType;
        this.update();
    }

    public boolean getShowBracing() {
        return this.showBracing;
    }

    public void setShowBracing(boolean b) {
        this.showBracing = b;
        this.update();
    }

    public EInsulatorType getInsulatorType() {
        return this.insulatorType;
    }

    public void setMastConnectionType(ECantileverMastConnection mastConnection) {
        this.mastConnectionType = mastConnection;
        this.update();
    }

    public ECantileverMastConnection getMastConnectionType() {
        return this.mastConnectionType;
    }

    public void setInsulatorType(EInsulatorType insulatorType) {
        this.insulatorType = insulatorType;
        this.update();
    }

    public float getCatenaryHeight() {
        return this.catenaryHeight;
    }

    public void setCatenaryHeight(float catenaryHeight) {
        this.catenaryHeight = catenaryHeight;
        this.update();
    }

    public float getPostConnectionOffset() {
        return this.postConnectionOffset;
    }

    public void setPostConnectionOffset(float postConnectionOffset) {
        this.postConnectionOffset = postConnectionOffset;
        this.update();
    }

    public boolean shouldUseSupportTube() {
        return this.useSupportTube;
    }

    public void setUseSupportTube(boolean b) {
        this.useSupportTube = b;
        this.update();
    }

    public byte getCantileversCount() {
        return this.cantileversCount;
    }

    public void setCantileversCount(byte cantileversCount) {
        this.cantileversCount = cantileversCount;
        this.update();
    }

    public SubCantileverSetting[] getSubCanileverSettings() {
        return this.subCanileverSettings;
    }

    public void update() {
        this.notifyUpdate();
        this.updateModel();
        this.cantileverDataCache.clear();
    }

    public record SubCantileverSetting(byte index, AbstractCantileverBlock.ECantileverRegistrationArmType registrationArm, boolean showBracing) {
        public static final SubCantileverSetting EMPTY = new SubCantileverSetting(-1, AbstractCantileverBlock.ECantileverRegistrationArmType.CENTER, false);
        private static final String NBT_INDEX = "Index";

        public CompoundTag toNbt() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128344_(NBT_INDEX, this.index);
            nbt.m_128405_(CantileverBlockEntity.NBT_REGISTRATION_ARM_TYPE, this.registrationArm.ordinal());
            nbt.m_128379_(CantileverBlockEntity.NBT_SHOW_BRACING, this.showBracing);
            return nbt;
        }

        public static SubCantileverSetting fromNbt(CompoundTag nbt) {
            return new SubCantileverSetting(nbt.m_128445_(NBT_INDEX), AbstractCantileverBlock.ECantileverRegistrationArmType.values()[nbt.m_128451_(CantileverBlockEntity.NBT_REGISTRATION_ARM_TYPE)], nbt.m_128471_(CantileverBlockEntity.NBT_SHOW_BRACING));
        }
    }

    public record CantileverData(float x, float y, float z, float width, float height, float frontYOffset, AbstractCantileverBlock.ECantileverRegistrationArmType registrationArm, float catenaryHeight, float spacing, boolean showBracing) {
        public static final CantileverData EMPTY = new CantileverData(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, AbstractCantileverBlock.ECantileverRegistrationArmType.CENTER, 0.0f, 0.0f, false);
    }

    public record CantileverShapeData(Vector3f stayTubeRoot, Vector3f front, Vector3f bracketTubeRoot) {
    }
}

