/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.blockentity;

import de.mrjulsen.mcdragonlib.util.MathUtils;
import de.mrjulsen.paw.block.abstractions.AbstractRotatableBlock;
import de.mrjulsen.paw.block.abstractions.IMultiblock;
import de.mrjulsen.paw.blockentity.IMultiblockBlockEntity;
import de.mrjulsen.wires.block.WireConnectorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class MultiblockWireConnectorBlockEntity
extends WireConnectorBlockEntity
implements IMultiblockBlockEntity {
    private static final String NBT_X_SIZE = "XSize";
    private static final String NBT_Y_SIZE = "YSize";
    private static final String NBT_Z_SIZE = "ZSize";
    private final int maxXSize;
    private final int maxYSize;
    private final int maxZSize;
    private int xOffset;
    private int yOffset;
    private int zOffset;
    private BlockPos rootPos;

    public MultiblockWireConnectorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        Block block = this.m_58900_().m_60734_();
        if (block instanceof IMultiblock) {
            IMultiblock mb = (IMultiblock)block;
            Vec3 vec = mb.multiblockSize();
            this.maxXSize = (int)vec.f_82479_;
            this.maxYSize = (int)vec.f_82480_;
            this.maxZSize = (int)vec.f_82481_;
        } else {
            this.maxXSize = 1;
            this.maxYSize = 1;
            this.maxZSize = 1;
        }
    }

    public void setRootPos(BlockPos pos) {
        this.rootPos = pos;
    }

    public BlockPos getRootPos() {
        return this.rootPos;
    }

    public int getDistanceToRoot() {
        Direction direction = (Direction)this.m_58900_().m_61143_((Property)AbstractRotatableBlock.FACING);
        return direction.m_122434_() == Direction.Axis.X ? Math.abs(this.rootPos.m_123341_() - this.m_58899_().m_123341_()) : Math.abs(this.rootPos.m_123343_() - this.m_58899_().m_123343_());
    }

    public int getYDistanceToRoot() {
        return Math.abs(this.rootPos.m_123342_() - this.m_58899_().m_123342_());
    }

    @Override
    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_(NBT_X_SIZE, this.xOffset);
        nbt.m_128405_(NBT_Y_SIZE, this.yOffset);
        nbt.m_128405_(NBT_Z_SIZE, this.zOffset);
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.xOffset = MathUtils.clamp((int)nbt.m_128451_(NBT_X_SIZE), (int)0, (int)(this.maxXSize - 1));
        this.yOffset = MathUtils.clamp((int)nbt.m_128451_(NBT_Y_SIZE), (int)0, (int)(this.maxYSize - 1));
        this.zOffset = MathUtils.clamp((int)nbt.m_128451_(NBT_Z_SIZE), (int)0, (int)(this.maxZSize - 1));
    }

    @Override
    public int getXOffset() {
        return this.xOffset;
    }

    @Override
    public int getYOffset() {
        return this.yOffset;
    }

    @Override
    public int getZOffset() {
        return this.zOffset;
    }

    @Override
    public int getXSize() {
        return this.maxXSize;
    }

    @Override
    public int getYSize() {
        return this.maxYSize;
    }

    @Override
    public int getZSize() {
        return this.maxZSize;
    }

    @Override
    public void setOffset(int x, int y, int z) {
        this.xOffset = MathUtils.clamp((int)x, (int)0, (int)(this.maxXSize - 1));
        this.yOffset = MathUtils.clamp((int)y, (int)0, (int)(this.maxYSize - 1));
        this.zOffset = MathUtils.clamp((int)z, (int)0, (int)(this.maxZSize - 1));
        this.notifyUpdate();
    }
}

