/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.foundation.gui.AllIcons;
import de.mrjulsen.mcdragonlib.client.render.Sprite;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import java.util.Arrays;
import net.minecraft.resources.ResourceLocation;

public enum ModGuiIcons {
    EMPTY("empty", 0, 0),
    CANTILEVER_CENTER("cantilever_center", 1, 0),
    CANTILEVER_OUTER("cantilever_outer", 2, 0),
    CANTILEVER_INNER("cantilever_inner", 3, 0),
    CANTILEVER_INSULATOR_NONE("cantilever_insulator_none", 4, 0),
    CANTILEVER_INSULATOR_BACK("cantilever_insulator_back", 5, 0),
    CANTILEVER_INSULATOR_FRONT("cantilever_insulator_front", 6, 0),
    CANTILEVER_SUPPORT_TUBE("cantilever_support_tube", 7, 0),
    CATENARY_WIRE("catenary_wire", 8, 0),
    ENERGY_WIRE("energy_wire", 9, 0),
    CATENARY_HEADSPAN_WIRE("catenary_headspan_wire", 10, 0),
    DECORATION_WIRE("decoration_wire", 11, 0);

    private String id;
    private int u;
    private int v;
    public static final int ICON_SIZE = 16;
    public static final ResourceLocation ICON_LOCATION;

    private ModGuiIcons(String id, int u, int v) {
        this.id = id;
        this.u = u;
        this.v = v;
    }

    public String getId() {
        return this.id;
    }

    public int getUMultiplier() {
        return this.u;
    }

    public int getVMultiplier() {
        return this.v;
    }

    public int getU() {
        return this.u * 16;
    }

    public int getV() {
        return this.v * 16;
    }

    public static ModGuiIcons getByStringId(String id) {
        return Arrays.stream(ModGuiIcons.values()).filter(x -> x.getId().equals(id)).findFirst().orElse(EMPTY);
    }

    public AllIcons getAsCreateIcon() {
        return new ModAllIcons(this.u, this.v);
    }

    public void render(Graphics graphics, int x, int y) {
        GuiUtils.drawTexture((ResourceLocation)ICON_LOCATION, (Graphics)graphics, (int)x, (int)y, (int)this.getU(), (int)this.getV(), (int)16, (int)16);
    }

    public Sprite getAsSprite(int renderWidth, int renderHeight) {
        return new Sprite(ICON_LOCATION, 256, 256, this.getU(), this.getV(), 16, 16, renderWidth, renderHeight);
    }

    static {
        ICON_LOCATION = new ResourceLocation("pantographsandwires", "textures/gui/icons.png");
    }

    public static class ModAllIcons
    extends AllIcons {
        public ModAllIcons(int x, int y) {
            super(x, y);
        }

        public void bind() {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ICON_LOCATION);
        }
    }
}

