/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.client.gui.screens;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.simibubi.create.foundation.gui.AllIcons;
import de.mrjulsen.mcdragonlib.client.model.ModelContext;
import de.mrjulsen.mcdragonlib.client.model.mesh.DLModel;
import de.mrjulsen.mcdragonlib.client.newgui.events.DLGuiCommonEvents;
import de.mrjulsen.mcdragonlib.client.newgui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.newgui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.newgui.widgets.base.DLWindow;
import de.mrjulsen.mcdragonlib.client.newgui.widgets.base.DLWindowManager;
import de.mrjulsen.mcdragonlib.client.newgui.widgets.components.DLCheckBox;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.core.ITranslatableEnum;
import de.mrjulsen.mcdragonlib.data.Cache;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import de.mrjulsen.paw.PantographsAndWires;
import de.mrjulsen.paw.block.abstractions.AbstractCantileverBlock;
import de.mrjulsen.paw.blockentity.CantileverBlockEntity;
import de.mrjulsen.paw.client.gui.ModGuiIcons;
import de.mrjulsen.paw.client.gui.widgets.CreateButton;
import de.mrjulsen.paw.client.gui.widgets.CreateEnumSlider;
import de.mrjulsen.paw.client.gui.widgets.CreateSlider;
import de.mrjulsen.paw.client.gui.widgets.IIconRepresentable;
import de.mrjulsen.paw.data.CantileverSettingsData;
import de.mrjulsen.paw.item.CantileverBlockItem;
import de.mrjulsen.paw.network.stc.UpdateCantileverSettingsPacket;
import de.mrjulsen.paw.registry.ModBlocks;
import java.util.ArrayList;
import java.util.Objects;
import net.createmod.catnip.gui.element.ScreenElement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class CantileverSettingsScreen
extends DLWindow {
    private static boolean showAdvanced = false;
    private static final ResourceLocation TEXTURE = new ResourceLocation("pantographsandwires", "textures/gui/cantilever_settings.png");
    private static final int TEXTURE_WIDTH = 256;
    private static final int TEXTURE_HEIGHT = 256;
    private static final int GUI_WIDTH = 251;
    private static final int GUI_HEIGHT = 231;
    private static final int AREA1_Y = 155;
    private static final int AREA2_Y = 177;
    private final Component title = TextUtils.translate((String)"gui.pantographsandwires.cantilever_settings.title");
    private final Component txtAdvancedOptions = TextUtils.translate((String)"gui.pantographsandwires.cantilever_settings.advanced_settings_option");
    private final MutableComponent txtWidth = TextUtils.translate((String)"gui.pantographsandwires.cantilever_settings.width");
    private final MutableComponent txtHeight = TextUtils.translate((String)"gui.pantographsandwires.cantilever_settings.height");
    private final MutableComponent txtCatenaryHeight = TextUtils.translate((String)"gui.pantographsandwires.cantilever_settings.catenary_height");
    private float width = 2.5f;
    private float height = 1.5f;
    private AbstractCantileverBlock.ECantileverRegistrationArmType registrationArmType = AbstractCantileverBlock.ECantileverRegistrationArmType.INNER;
    private AbstractCantileverBlock.ECantileverInsulatorsPlacement insulatorPlacement = AbstractCantileverBlock.ECantileverInsulatorsPlacement.BACK;
    private float catenaryHeight = 1.0f;
    private boolean showBracing = false;
    private final Cache<BlockState> stateCache;
    private ModelContext context;

    public CantileverSettingsScreen(DLWindowManager manager, ItemStack stack) {
        super(manager);
        if (!(stack.m_41720_() instanceof CantileverBlockItem)) {
            throw new IllegalArgumentException(String.valueOf(stack.m_41720_()) + " is not a CantileverBlockItem.");
        }
        this.setSize(251.0, 231.0);
        this.setPosition(Minecraft.m_91087_().m_91268_().m_85445_() / 2 - this.width() / 2, Minecraft.m_91087_().m_91268_().m_85446_() / 2 - this.height() / 2);
        this.width = CantileverBlockItem.getWidth(stack);
        this.height = CantileverBlockItem.getHeight(stack);
        this.catenaryHeight = CantileverBlockItem.getCatenaryHeight(stack);
        this.registrationArmType = CantileverBlockItem.getCantileverType(stack);
        this.insulatorPlacement = CantileverBlockItem.getInsulatorPlacement(stack);
        this.showBracing = CantileverBlockItem.getShowBracing(stack);
        this.addEventListener(DLGuiStandardEvents.LayoutUpdateEvent.class, (s, e) -> {
            this.setPosition(Minecraft.m_91087_().m_91268_().m_85445_() / 2 - this.width() / 2, Minecraft.m_91087_().m_91268_().m_85446_() / 2 - this.height() / 2);
            return false;
        });
        this.addEventListener(DLGuiStandardEvents.CloseEvent.class, (s, e) -> {
            CantileverSettingsData data = new CantileverSettingsData(this.width, this.height, this.catenaryHeight, this.registrationArmType, this.insulatorPlacement, this.showBracing);
            CantileverBlockItem.setNbt(stack, data);
            PantographsAndWires.net().CHANNEL.sendToServer((Object)new UpdateCantileverSettingsPacket(data));
            return false;
        });
        this.stateCache = new Cache(() -> ((AbstractCantileverBlock)ModBlocks.getCantilever(((CantileverBlockItem)stack.m_41720_()).getInsulatorType()).get()).m_49966_());
        this.updateModelContext();
        this.addEventListener(DLGuiStandardEvents.KeyPressEvent.class, (s, e) -> {
            if (e.keyCode() == 256) {
                this.getWindowManager().closeWindow((DLWindow)this);
            }
            return false;
        });
        CreateEnumSlider<AbstractCantileverBlock.ECantileverInsulatorsPlacement> insulatorPlacementSlider = new CreateEnumSlider<AbstractCantileverBlock.ECantileverInsulatorsPlacement>(0, 177, 50, 20, AbstractCantileverBlock.ECantileverInsulatorsPlacement.class);
        CreateEnumSlider<AbstractCantileverBlock.ECantileverRegistrationArmType> registrationArmSlider = new CreateEnumSlider<AbstractCantileverBlock.ECantileverRegistrationArmType>(0, 177, 50, 20, AbstractCantileverBlock.ECantileverRegistrationArmType.class);
        CreateEnumSlider<SupportTubeEnum> bracingSlider = new CreateEnumSlider<SupportTubeEnum>(0, 177, 50, 20, SupportTubeEnum.class);
        CreateSlider cantileverSizeSlider = new CreateSlider(0, 155, 60, 14, (Component)this.txtWidth);
        CreateSlider cantileverHeightSlider = new CreateSlider(0, 155, 60, 14, (Component)this.txtHeight);
        CreateSlider regstrationArmHeightSlider = new CreateSlider(0, 155, 60, 14, (Component)this.txtCatenaryHeight);
        int cbTxtW = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)this.txtAdvancedOptions);
        int cbW = 16 + cbTxtW;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        int cbH = 9;
        DLCheckBox advancedOptionCb = new DLCheckBox(220 - cbW, 148 - cbH, cbW, cbH){

            public void renderMainLayer(Graphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
                if (this.checked.get().booleanValue()) {
                    GuiUtils.drawTexture((ResourceLocation)TEXTURE, (Graphics)graphics, (int)0, (int)(this.height() / 2 - 4), (int)12, (int)7, (int)0, (int)241, (int)256, (int)256);
                } else {
                    GuiUtils.drawTexture((ResourceLocation)TEXTURE, (Graphics)graphics, (int)0, (int)(this.height() / 2 - 4), (int)12, (int)7, (int)0, (int)249, (int)256, (int)256);
                }
                Font font = Minecraft.m_91087_().f_91062_;
                int n = this.height() / 2;
                Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
                GuiUtils.drawString((Graphics)graphics, (Font)font, (int)16, (int)(n - 9 / 2), (FormattedText)((FormattedText)this.text.get()), (int)-12566464, (EAlignment)EAlignment.LEFT, (boolean)false);
            }
        };
        CreateButton doneBtn = new CreateButton(this.width() - 7 - 18, this.height() - 6 - 18, (ScreenElement)AllIcons.I_CONFIRM);
        doneBtn.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            this.getWindowManager().closeWindow((DLWindow)this);
            return false;
        });
        this.addComponent((DLGuiComponent)doneBtn);
        Runnable relayoutFunc = () -> {
            bracingSlider.visible.set((Object)(advancedOptionCb.checked.get() != false && this.width > 1.5f ? 1 : 0));
            regstrationArmHeightSlider.visible.set((Object)advancedOptionCb.checked.get());
            cantileverHeightSlider.visible.set((Object)advancedOptionCb.checked.get());
            DLGuiComponent[] area1 = new DLGuiComponent[]{cantileverSizeSlider, cantileverHeightSlider, regstrationArmHeightSlider};
            DLGuiComponent[] area2 = new DLGuiComponent[]{insulatorPlacementSlider, registrationArmSlider, bracingSlider};
            CantileverSettingsScreen.distributeHorizontally(area1, this.width() / 2);
            CantileverSettingsScreen.distributeHorizontally(area2, this.width() / 2);
        };
        MutableBoolean updatingValues = new MutableBoolean();
        Runnable updateFunc = () -> {
            updatingValues.setTrue();
            AbstractCantileverBlock.Constraints c = AbstractCantileverBlock.calculate(this.width, this.height, this.catenaryHeight);
            cantileverSizeSlider.min.set((Number)c.width().min());
            cantileverSizeSlider.max.set((Number)c.width().max());
            cantileverHeightSlider.min.set((Number)c.height().min());
            cantileverHeightSlider.max.set((Number)c.height().max());
            cantileverHeightSlider.step.set((Number)c.height().step());
            regstrationArmHeightSlider.min.set((Number)c.armHeight().min());
            regstrationArmHeightSlider.max.set((Number)c.armHeight().max());
            regstrationArmHeightSlider.step.set((Number)c.armHeight().step());
            registrationArmSlider.visible.set((Object)c.registrationArmsAllowed());
            if (!c.registrationArmsAllowed()) {
                registrationArmSlider.value.set((Number)AbstractCantileverBlock.ECantileverRegistrationArmType.CENTER.ordinal());
            }
            if (this.width <= 1.5f) {
                this.showBracing = false;
            }
            if (!showAdvanced) {
                float w = this.width - 0.5f;
                cantileverHeightSlider.value.set((Number)((double)(w / 2.0f) + 0.5));
                regstrationArmHeightSlider.value.set((Number)(w <= 1.0f ? 0.5 : Math.floor((double)(w + 1.0f) / 3.0)));
                this.showBracing = w >= 4.0f;
            }
            relayoutFunc.run();
            updatingValues.setFalse();
        };
        cantileverSizeSlider.min.set((Number)1.5);
        cantileverSizeSlider.max.set((Number)6.5);
        cantileverSizeSlider.value.set((Number)this.width);
        cantileverSizeSlider.addEventListener(DLGuiCommonEvents.ValueChangedEvent.class, (s, e) -> {
            this.width = (float)e.value();
            if (updatingValues.isFalse()) {
                updateFunc.run();
            }
            this.stateCache.clear();
            this.updateModelContext();
            return false;
        });
        this.addComponent((DLGuiComponent)cantileverSizeSlider);
        cantileverHeightSlider.step.set((Number)0.5);
        cantileverHeightSlider.min.set((Number)0.0);
        cantileverHeightSlider.max.set((Number)3.0);
        cantileverHeightSlider.value.set((Number)this.height);
        cantileverHeightSlider.addEventListener(DLGuiCommonEvents.ValueChangedEvent.class, (s, e) -> {
            this.height = (float)e.value();
            if (updatingValues.isFalse()) {
                updateFunc.run();
            }
            this.stateCache.clear();
            this.updateModelContext();
            return false;
        });
        this.addComponent((DLGuiComponent)cantileverHeightSlider);
        regstrationArmHeightSlider.step.set((Number)0.5);
        regstrationArmHeightSlider.min.set((Number)0.0);
        regstrationArmHeightSlider.max.set((Number)3.0);
        regstrationArmHeightSlider.value.set((Number)this.catenaryHeight);
        regstrationArmHeightSlider.addEventListener(DLGuiCommonEvents.ValueChangedEvent.class, (s, e) -> {
            this.catenaryHeight = (float)e.value();
            if (updatingValues.isFalse()) {
                updateFunc.run();
            }
            this.stateCache.clear();
            this.updateModelContext();
            return false;
        });
        this.addComponent((DLGuiComponent)regstrationArmHeightSlider);
        insulatorPlacementSlider.value.set((Number)this.insulatorPlacement.ordinal());
        insulatorPlacementSlider.addEventListener(DLGuiCommonEvents.ValueChangedEvent.class, (s, e) -> {
            this.insulatorPlacement = AbstractCantileverBlock.ECantileverInsulatorsPlacement.values()[(int)e.value()];
            this.stateCache.clear();
            this.updateModelContext();
            return false;
        });
        this.addComponent((DLGuiComponent)insulatorPlacementSlider);
        registrationArmSlider.value.set((Number)this.registrationArmType.ordinal());
        registrationArmSlider.addEventListener(DLGuiCommonEvents.ValueChangedEvent.class, (s, e) -> {
            this.registrationArmType = AbstractCantileverBlock.ECantileverRegistrationArmType.values()[(int)e.value()];
            this.stateCache.clear();
            this.updateModelContext();
            return false;
        });
        this.addComponent((DLGuiComponent)registrationArmSlider);
        bracingSlider.value.set((Number)(this.showBracing ? 1.0 : 0.0));
        bracingSlider.addEventListener(DLGuiCommonEvents.ValueChangedEvent.class, (s, e) -> {
            this.showBracing = SupportTubeEnum.values()[(int)e.value()].get();
            if (updatingValues.isFalse()) {
                updateFunc.run();
            }
            this.stateCache.clear();
            this.updateModelContext();
            return false;
        });
        this.addComponent((DLGuiComponent)bracingSlider);
        updateFunc.run();
        advancedOptionCb.text.set((Object)this.txtAdvancedOptions);
        advancedOptionCb.checked.set((Object)showAdvanced);
        advancedOptionCb.addEventListener(DLGuiCommonEvents.CheckedChangedEvent.class, (s, e) -> {
            showAdvanced = e.checked();
            relayoutFunc.run();
            return false;
        });
        this.addComponent((DLGuiComponent)advancedOptionCb);
        relayoutFunc.run();
    }

    private static void distributeHorizontally(DLGuiComponent[] components, int centerX) {
        double startX;
        if (components == null || components.length <= 0) {
            return;
        }
        ArrayList<DLGuiComponent> visible = new ArrayList<DLGuiComponent>();
        for (DLGuiComponent c : components) {
            if (c == null || !c.visible.get().booleanValue()) continue;
            visible.add(c);
        }
        int count = visible.size();
        if (count == 0) {
            return;
        }
        int w = ((DLGuiComponent)visible.get(0)).width();
        int gap = 4;
        int blockWidth = count * w + (count - 1) * gap;
        double currentX = startX = (double)centerX - (double)blockWidth / 2.0;
        for (DLGuiComponent o : visible) {
            o.setX((double)((int)Math.round(currentX)));
            currentX += (double)(w + gap);
        }
    }

    private void updateModelContext() {
        this.context = ModelContext.builder().with(CantileverBlockEntity.PROPERTY_WIDTH, (Object)Float.valueOf(this.width)).with(CantileverBlockEntity.PROPERTY_HEIGHT, (Object)Float.valueOf(this.height)).with(CantileverBlockEntity.PROPERTY_INSULATOR_PLACEMENT, (Object)this.insulatorPlacement).with(CantileverBlockEntity.PROPERTY_REGISTRATION_ARM, (Object)this.registrationArmType).with(CantileverBlockEntity.PROPERTY_CATENARY_HEIGHT, (Object)Float.valueOf(this.catenaryHeight)).with(CantileverBlockEntity.PROPERTY_SHOW_BRACING, (Object)this.showBracing).build();
    }

    public void renderMainLayer(Graphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        GuiUtils.drawTexture((ResourceLocation)TEXTURE, (Graphics)graphics, (int)0, (int)0, (int)251, (int)231, (int)0, (int)0, (int)256, (int)256);
        Lighting.m_84930_();
        graphics.poseStack().m_85836_();
        graphics.poseStack().m_166856_();
        graphics.poseStack().m_252880_((float)(this.x() + 30 + 96), (float)(this.y() + 54), 200.0f);
        graphics.poseStack().m_85836_();
        graphics.poseStack().m_85841_(24.0f, 24.0f, -24.0f);
        graphics.poseStack().m_252781_(Axis.f_252403_.m_252977_(180.0f));
        graphics.poseStack().m_252781_(Axis.f_252436_.m_252977_(90.0f));
        graphics.poseStack().m_252781_(Axis.f_252436_.m_252977_((float)System.nanoTime() / 2.5E7f));
        graphics.poseStack().m_85836_();
        graphics.poseStack().m_252880_(0.0f, 0.0f, (this.width - 1.5f) / 2.0f + ((this.width - 0.5f) % 2.0f == 0.0f ? 0.5f : 0.0f));
        MultiBufferSource.BufferSource buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
        DLModel.renderModel((PoseStack.Pose)graphics.poseStack().m_85850_(), (VertexConsumer)buffersource.m_6299_(RenderType.m_110451_()), (DLModel.ModelType)DLModel.ModelType.BLOCK, (BlockState)((BlockState)this.stateCache.get()), (ModelContext)this.context, (float)1.0f, (float)1.0f, (float)1.0f, (int)0xF000F0, (int)0);
        buffersource.m_109911_();
        graphics.poseStack().m_85849_();
        graphics.poseStack().m_85849_();
        graphics.poseStack().m_85849_();
        Lighting.m_84931_();
        graphics.poseStack().m_85836_();
        graphics.poseStack().m_252880_(0.0f, 0.0f, 500.0f);
        GuiUtils.drawString((Graphics)graphics, (Font)Minecraft.m_91087_().f_91062_, (int)(this.width() / 2), (int)4, (FormattedText)this.title, (int)-12566464, (EAlignment)EAlignment.CENTER, (boolean)false);
        graphics.poseStack().m_85849_();
    }

    private static enum SupportTubeEnum implements ITranslatableEnum,
    IIconRepresentable
    {
        OFF(false, ModGuiIcons.CANTILEVER_INSULATOR_NONE),
        ON(true, ModGuiIcons.CANTILEVER_SUPPORT_TUBE);

        private final boolean b;
        private final ModGuiIcons icon;

        private SupportTubeEnum(boolean b, ModGuiIcons icon) {
            this.b = b;
            this.icon = icon;
        }

        public boolean get() {
            return this.b;
        }

        public String getEnumName() {
            return "show_support_tube";
        }

        public String getEnumValueName() {
            return String.valueOf(this.b);
        }

        @Override
        public ModGuiIcons getIcon() {
            return this.icon;
        }
    }
}

