/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.client.gui.screens;

import com.simibubi.create.foundation.gui.AllIcons;
import de.mrjulsen.mcdragonlib.client.newgui.events.DLGuiCommonEvents;
import de.mrjulsen.mcdragonlib.client.newgui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.newgui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.newgui.widgets.base.DLWindow;
import de.mrjulsen.mcdragonlib.client.newgui.widgets.base.DLWindowManager;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import de.mrjulsen.paw.PantographsAndWires;
import de.mrjulsen.paw.client.gui.widgets.CreateButton;
import de.mrjulsen.paw.client.gui.widgets.CreateListSlider;
import de.mrjulsen.paw.data.WireSettingsData;
import de.mrjulsen.paw.network.stc.ClearWireConnectionPacket;
import de.mrjulsen.paw.network.stc.UpdateWireSettingsPacket;
import de.mrjulsen.paw.registry.ModWireRegistry;
import de.mrjulsen.wires.item.IPawWireItemBase;
import de.mrjulsen.wires.item.IWireItemBase;
import de.mrjulsen.wires.item.MultiWireItem;
import net.createmod.catnip.gui.element.ScreenElement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class WireTypeSelectionScreen
extends DLWindow {
    private static final ResourceLocation TEXTURE = new ResourceLocation("pantographsandwires", "textures/gui/quick_settings.png");
    private static final int TEXTURE_WIDTH = 256;
    private static final int TEXTURE_HEIGHT = 256;
    private static final int GUI_WIDTH = 192;
    private static final int GUI_HEIGHT = 106;
    private final Component title = TextUtils.translate((String)"gui.pantographsandwires.wire_selection.title");
    private final Component txtInstruction = TextUtils.translate((String)"gui.pantographsandwires.wire_selection.instruction");
    private final Component txtWireType = TextUtils.translate((String)"gui.pantographsandwires.wire_selection.wire_type");
    private IPawWireItemBase selectedType;

    public WireTypeSelectionScreen(DLWindowManager manager, ItemStack stack) {
        super(manager);
        Item item = stack.m_41720_();
        if (!(item instanceof MultiWireItem)) {
            throw new IllegalArgumentException("This item is no MultiWireItem.");
        }
        MultiWireItem item2 = (MultiWireItem)item;
        this.selectedType = (IPawWireItemBase)item2.getSubType(stack);
        this.setSize(192.0, 106.0);
        this.setPosition(Minecraft.m_91087_().m_91268_().m_85445_() / 2 - this.width() / 2, Minecraft.m_91087_().m_91268_().m_85446_() / 2 - this.height() / 2);
        this.addEventListener(DLGuiStandardEvents.CloseEvent.class, (s, e) -> {
            WireSettingsData data = new WireSettingsData(this.selectedType);
            MultiWireItem.setNbt(stack, data);
            PantographsAndWires.net().CHANNEL.sendToServer((Object)new UpdateWireSettingsPacket(data));
            return false;
        });
        int w = ModWireRegistry.WIRE_SUBTYPES_REGISTRY.getAll().size() * 20;
        CreateListSlider<IPawWireItemBase> typeSelection = new CreateListSlider<IPawWireItemBase>(this.width() / 2 - w / 2, 43, w, 20, ModWireRegistry.WIRE_SUBTYPES_REGISTRY.getAll());
        typeSelection.text.set((Object)this.txtWireType);
        typeSelection.setValue(this.selectedType);
        typeSelection.addEventListener(DLGuiCommonEvents.ValueChangedEvent.class, (s, e) -> {
            this.selectedType = (IPawWireItemBase)typeSelection.getValue();
            return false;
        });
        this.addComponent((DLGuiComponent)typeSelection);
        CreateButton doneBtn = new CreateButton(this.width() - 7 - 18, this.height() - 6 - 18, (ScreenElement)AllIcons.I_CONFIRM);
        doneBtn.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            this.getWindowManager().closeWindow((DLWindow)this);
            return false;
        });
        this.addComponent((DLGuiComponent)doneBtn);
        CreateButton resetBtn = new CreateButton(7, this.height() - 6 - 18, (ScreenElement)AllIcons.I_TRASH);
        resetBtn.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            IWireItemBase.clear(stack);
            PantographsAndWires.net().CHANNEL.sendToServer((Object)new ClearWireConnectionPacket());
            this.getWindowManager().closeWindow((DLWindow)this);
            return false;
        });
        this.addComponent((DLGuiComponent)resetBtn);
    }

    public void renderMainLayer(Graphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        GuiUtils.drawTexture((ResourceLocation)TEXTURE, (Graphics)graphics, (int)0, (int)0, (int)192, (int)106, (int)0, (int)0, (int)256, (int)256);
        GuiUtils.drawString((Graphics)graphics, (Font)Minecraft.m_91087_().f_91062_, (int)(this.width() / 2), (int)4, (FormattedText)this.title, (int)-12566464, (EAlignment)EAlignment.CENTER, (boolean)false);
        GuiUtils.drawString((Graphics)graphics, (Font)Minecraft.m_91087_().f_91062_, (int)(this.width() / 2), (int)26, (FormattedText)this.txtInstruction, (int)-8750470, (EAlignment)EAlignment.CENTER, (boolean)false);
    }
}

