/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.client.gui.widgets;

import de.mrjulsen.mcdragonlib.client.newgui.widgets.components.DLSlider;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import de.mrjulsen.paw.client.gui.ModGuiUtils;
import de.mrjulsen.paw.client.gui.widgets.IIconRepresentable;
import de.mrjulsen.paw.client.gui.widgets.ITranslatable;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class CreateListSlider<T extends IIconRepresentable & ITranslatable>
extends DLSlider {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("create:textures/gui/value_settings.png");
    private static final int SLIDER_BAR_SIZE = 8;
    private static final int SLIDER_DOCK_WIDTH = 7;
    private static final int SLIDER_SIZE = 22;
    private final List<T> values;

    public CreateListSlider(int x, int y, int w, int h, List<T> values) {
        super(x, y, w, h);
        this.values = values;
        this.max.set((Number)((double)values.size() - 1.0));
        this.sliderWidth.set((Number)22);
    }

    public T getValue() {
        return (T)((IIconRepresentable)this.values.get(((Double)this.value.get()).intValue()));
    }

    public void setValue(T value) {
        this.value.set((Number)this.values.indexOf(value));
    }

    protected void updateSliderValue(double mouseX, double mouseY) {
        double value = ((Double)this.max.get() - (Double)this.min.get()) / (double)(this.width() - (Integer)this.sliderWidth.get()) * (mouseX - (double)((Integer)this.sliderWidth.get()).intValue() / 2.0);
        value = (double)Math.round(value / (Double)this.step.get()) * (Double)this.step.get();
        this.value.set((Number)(value + (Double)this.min.get()));
    }

    public void renderMainLayer(Graphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        int k = (Integer)this.sliderWidth.get() / 2 - 3;
        int i = (this.height() - 8) / 2;
        GuiUtils.drawTexture((ResourceLocation)TEXTURE, (Graphics)graphics, (int)k, (int)i, (int)0, (int)0, (int)7, (int)8);
        GuiUtils.drawTexture((ResourceLocation)TEXTURE, (Graphics)graphics, (int)(this.width() - 7 - k), (int)i, (int)0, (int)0, (int)7, (int)8);
        GuiUtils.drawTexture((ResourceLocation)TEXTURE, (Graphics)graphics, (int)(k + 7), (int)i, (int)7, (int)0, (int)(this.width() - 14 - k * 2), (int)8);
        int sliderX = (int)((double)(this.width() - (Integer)this.sliderWidth.get()) / ((Double)this.max.get() - (Double)this.min.get()) * ((Double)this.value.get() - (Double)this.min.get()));
        GuiUtils.drawTexture((ResourceLocation)TEXTURE, (Graphics)graphics, (int)sliderX, (int)(this.height() / 2 - 11), (int)0, (int)43, (int)22, (int)22);
        ((IIconRepresentable)this.values.get(((Double)this.value.get()).intValue())).getIcon().render(graphics, sliderX + 3, 3);
    }

    public void renderFrontLayer(Graphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        if (this.isSelected() || this.isDragged()) {
            Font font = Minecraft.m_91087_().f_91062_;
            IIconRepresentable e = (IIconRepresentable)this.values.get(((Double)this.value.get()).intValue());
            MutableComponent valueTxt = TextUtils.translate((String)((ITranslatable)((Object)e)).getTranslationKey());
            int halfWidth = Math.max(font.m_92852_((FormattedText)this.text.get()) / 2, font.m_92852_((FormattedText)valueTxt) / 2);
            int n = this.width() / 2 - halfWidth - 3;
            Objects.requireNonNull(font);
            int n2 = -9 * 2 - 6;
            Objects.requireNonNull(font);
            ModGuiUtils.renderRoundedBox(graphics, n, n2, halfWidth * 2 + 6, 9 * 2 + 5, -1442840576);
            int n3 = this.width() / 2;
            Objects.requireNonNull(font);
            GuiUtils.drawString((Graphics)graphics, (Font)font, (int)n3, (int)(-9 - 2), (FormattedText)valueTxt, (int)-7031331, (EAlignment)EAlignment.CENTER, (boolean)false);
            int n4 = this.width() / 2;
            Objects.requireNonNull(font);
            GuiUtils.drawString((Graphics)graphics, (Font)font, (int)n4, (int)(-9 * 2 - 4), (FormattedText)((FormattedText)this.text.get()), (int)-1, (EAlignment)EAlignment.CENTER, (boolean)false);
        }
    }
}

