/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.client.gui.widgets;

import de.mrjulsen.mcdragonlib.client.newgui.events.DLGuiCommonEvents;
import de.mrjulsen.mcdragonlib.client.newgui.widgets.components.DLSlider;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import de.mrjulsen.paw.client.gui.ModGuiUtils;
import de.mrjulsen.paw.util.ModMath;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class CreateSlider
extends DLSlider {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("create:textures/gui/value_settings.png");
    private static final int SLIDER_BAR_SIZE = 8;
    private static final int SLIDER_HEIGHT = 14;
    private static final int SLIDER_DOCK_WIDTH = 7;
    private Component text;

    public CreateSlider(int x, int y, int w, int h, Component text) {
        super(x, y, w, h);
        this.text = text;
        this.addEventListener(DLGuiCommonEvents.ValueRangeChangedEvent.class, (s, e) -> {
            this.updateSliderWidth();
            return false;
        });
        this.step.withAfterPropertyChangedCallback((o, a) -> {
            this.value.set((Number)ModMath.snapNearest((Double)this.value.get(), (Double)this.step.get()));
            this.updateSliderWidth();
        });
        this.updateSliderWidth();
    }

    protected void updateSliderWidth() {
        if (Math.abs((Double)this.step.get() - (double)Math.round((Double)this.step.get())) < 1.0E-6) {
            this.sliderWidth.set((Number)(Math.max(Minecraft.m_91087_().f_91062_.m_92895_(String.valueOf(((Double)this.min.get()).intValue())), Minecraft.m_91087_().f_91062_.m_92895_(String.valueOf(((Double)this.max.get()).intValue()))) + 10));
        } else {
            this.sliderWidth.set((Number)(Math.max(Minecraft.m_91087_().f_91062_.m_92895_(String.valueOf((Double)this.min.get())), Minecraft.m_91087_().f_91062_.m_92895_(String.valueOf((Double)this.max.get()))) + 10));
        }
    }

    protected String getValueString() {
        return Math.abs((Double)this.step.get() - (double)Math.round((Double)this.step.get())) < 1.0E-6 ? String.valueOf(((Double)this.value.get()).intValue()) : String.valueOf((Double)this.value.get());
    }

    protected void updateSliderValue(double mouseX, double mouseY) {
        double value = ((Double)this.max.get() - (Double)this.min.get()) / (double)(this.width() - (Integer)this.sliderWidth.get()) * (mouseX - (double)((Integer)this.sliderWidth.get()).intValue() / 2.0);
        value = (double)Math.round(value / (Double)this.step.get()) * (Double)this.step.get();
        this.value.set((Number)(value + (Double)this.min.get()));
    }

    public void renderMainLayer(Graphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        int i = (this.height() - 8) / 2;
        GuiUtils.drawTexture((ResourceLocation)TEXTURE, (Graphics)graphics, (int)i, (int)i, (int)0, (int)0, (int)7, (int)8);
        GuiUtils.drawTexture((ResourceLocation)TEXTURE, (Graphics)graphics, (int)(this.width() - 7 - i), (int)i, (int)0, (int)0, (int)7, (int)8);
        GuiUtils.drawTexture((ResourceLocation)TEXTURE, (Graphics)graphics, (int)(i + 7), (int)i, (int)7, (int)0, (int)(this.width() - 14 - i * 2), (int)8);
        String txt = this.getValueString();
        int sliderX = (int)((double)(this.width() - (Integer)this.sliderWidth.get()) / ((Double)this.max.get() - (Double)this.min.get()) * ((Double)this.value.get() - (Double)this.min.get()));
        int sliderY = (this.height() - 14) / 2;
        int sliderW = (Double)this.max.get() <= (Double)this.min.get() ? this.width() : ((Integer)this.sliderWidth.get()).intValue();
        GuiUtils.drawTexture((ResourceLocation)TEXTURE, (Graphics)graphics, (int)sliderX, (int)sliderY, (int)0, (int)9, (int)3, (int)14);
        GuiUtils.drawTexture((ResourceLocation)TEXTURE, (Graphics)graphics, (int)(sliderX + 3), (int)sliderY, (int)4, (int)9, (int)(sliderW - 6), (int)14);
        GuiUtils.drawTexture((ResourceLocation)TEXTURE, (Graphics)graphics, (int)(sliderX + sliderW - 3), (int)sliderY, (int)61, (int)9, (int)3, (int)14);
        Font font = Minecraft.m_91087_().f_91062_;
        int n = sliderX + sliderW / 2;
        int n2 = this.height() / 2;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        GuiUtils.drawString((Graphics)graphics, (Font)font, (int)n, (int)(n2 - 9 / 2), (String)txt, (int)-12312576, (EAlignment)EAlignment.CENTER, (boolean)false);
    }

    public void renderFrontLayer(Graphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        if (this.isSelected() || this.isDragged()) {
            Font font = Minecraft.m_91087_().f_91062_;
            MutableComponent valueTxt = TextUtils.text((String)String.valueOf(this.getValueString()));
            int halfWidth = Math.max(font.m_92852_((FormattedText)this.text) / 2, font.m_92852_((FormattedText)valueTxt) / 2);
            int n = this.width() / 2 - halfWidth - 3;
            Objects.requireNonNull(font);
            int n2 = -9 * 2 - 6;
            Objects.requireNonNull(font);
            ModGuiUtils.renderRoundedBox(graphics, n, n2, halfWidth * 2 + 6, 9 * 2 + 5, -1442840576);
            int n3 = this.width() / 2;
            Objects.requireNonNull(font);
            GuiUtils.drawString((Graphics)graphics, (Font)font, (int)n3, (int)(-9 - 2), (FormattedText)valueTxt, (int)-7031331, (EAlignment)EAlignment.CENTER, (boolean)false);
            int n4 = this.width() / 2;
            Objects.requireNonNull(font);
            GuiUtils.drawString((Graphics)graphics, (Font)font, (int)n4, (int)(-9 * 2 - 4), (FormattedText)this.text, (int)-1, (EAlignment)EAlignment.CENTER, (boolean)false);
        }
    }
}

