/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.client.model;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import de.mrjulsen.paw.block.abstractions.IConicalShape;
import de.mrjulsen.paw.block.abstractions.IRotatableBlock;
import de.mrjulsen.paw.client.model.BakedModelExtension;
import de.mrjulsen.paw.client.model.ETransformationType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class RotatedBlockModel
extends BakedModelExtension<BakedModel> {
    public static final VertexFormat FORMAT = DefaultVertexFormat.f_85811_;
    public static final int VERTEX_STRIDE = FORMAT.m_86017_();
    public static final int X_OFFSET = 0;
    public static final int Y_OFFSET = 1;
    public static final int Z_OFFSET = 2;

    public RotatedBlockModel(BakedModel originalModel) {
        super(originalModel);
    }

    @Override
    public List<BakedQuad> m_213637_(BlockState state, Direction side, RandomSource rand) {
        Block block = state.m_60734_();
        if (!(block instanceof IRotatableBlock)) {
            return this.originalModel.m_213637_(state, side, rand);
        }
        IRotatableBlock rot = (IRotatableBlock)block;
        List templateQuads = this.originalModel.m_213637_(state, side, rand);
        if (templateQuads.isEmpty()) {
            return templateQuads;
        }
        double hAngle = rot.getRelativeYRotation(state);
        Vec2 pivot = rot.rotatedPivotPoint(state);
        Vec2 offset = rot.getOffset(state);
        Vec3 verticalOffset = new Vec3(0.5, 0.25, 0.5).m_82492_((double)pivot.f_82470_, 0.0, (double)pivot.f_82471_);
        int size = templateQuads.size();
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (int i = 0; i < size; ++i) {
            BakedQuad quad = RotatedBlockModel.clone((BakedQuad)templateQuads.get(i));
            int[] vertexData = quad.m_111303_();
            for (int j = 0; j < 4; ++j) {
                Vec3 vec = RotatedBlockModel.getXYZ(vertexData, j);
                Block block2 = state.m_60734_();
                if (block2 instanceof IConicalShape) {
                    IConicalShape cone = (IConicalShape)block2;
                    Vec2 coneTarget = cone.coneTarget(state);
                    Vec2 coneOffset = cone.coneOffset(state);
                    double sX = -Math.signum(vec.f_82479_ - (double)coneTarget.f_82470_);
                    double sZ = -Math.signum(vec.f_82481_ - (double)coneTarget.f_82471_);
                    vec = vec.m_82520_(sX * vec.f_82480_ * (double)coneOffset.f_82470_, 0.0, sZ * vec.f_82480_ * (double)coneOffset.f_82471_);
                }
                RotatedBlockModel.setXYZ(vertexData, j, this.transformVector(state, side, rand, rot, vec, hAngle, verticalOffset, quad.m_111305_(), offset, pivot));
            }
            quads.add(quad);
        }
        return quads;
    }

    private Vec3 transformVector(BlockState state, Direction side, RandomSource rand, IRotatableBlock rot, Vec3 v, double rotationAngle, Vec3 verticalOffset, int flags, Vec2 offset, Vec2 pivot) {
        block11: {
            Direction.Axis axis;
            ETransformationType transformationType;
            block12: {
                transformationType = ETransformationType.getByIndex(flags);
                axis = rot.transformOnAxis(state);
                if (axis == null) break block11;
                if (!transformationType.isScale()) break block12;
                switch (axis) {
                    case X: {
                        double distance = v.m_82507_(axis) - (double)pivot.f_82470_;
                        if (transformationType != ETransformationType.SCALE_POSITIVE && transformationType != ETransformationType.SCALE_NEGATIVE || (!(distance > 0.0) || transformationType == ETransformationType.SCALE_POSITIVE) && (!(distance < 0.0) || transformationType == ETransformationType.SCALE_NEGATIVE)) {
                            double scaledDistance = distance * rot.getScaleForRotation(state);
                            v = new Vec3((double)pivot.f_82470_ + scaledDistance, v.f_82480_, v.f_82481_);
                        }
                        break block11;
                    }
                    case Z: {
                        double distance = v.m_82507_(axis) - (double)pivot.f_82471_;
                        if (transformationType != ETransformationType.SCALE_POSITIVE && transformationType != ETransformationType.SCALE_NEGATIVE || (!(distance > 0.0) || transformationType == ETransformationType.SCALE_POSITIVE) && (!(distance < 0.0) || transformationType == ETransformationType.SCALE_NEGATIVE)) {
                            double scaledDistance = distance * rot.getScaleForRotation(state);
                            v = new Vec3(v.f_82479_, v.f_82480_, (double)pivot.f_82471_ + scaledDistance);
                        }
                        break block11;
                    }
                    default: {
                        throw new IllegalArgumentException("The scaling axis for block " + String.valueOf(state.m_60734_()) + " must be horizontal. " + String.valueOf(axis) + " is not allowed!");
                    }
                }
            }
            if (transformationType == ETransformationType.TRANSLATE) {
                switch (axis) {
                    case X: {
                        double angleRadians = Math.toRadians(rot.getRelativeYRotation(state));
                        float h = 1.0f / (float)Math.cos(angleRadians);
                        v = new Vec3(v.f_82479_ + (double)((float)((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122421_().m_122540_() * (1.0f - h)), v.f_82480_, v.f_82481_);
                        break;
                    }
                    case Z: {
                        double angleRadians = Math.toRadians(rot.getRelativeYRotation(state));
                        float h = 1.0f / (float)Math.cos(angleRadians);
                        v = new Vec3(v.f_82479_, v.f_82480_, v.f_82481_ + (double)((float)((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122421_().m_122540_() * (1.0f - h)));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("The scaling axis for block " + String.valueOf(state.m_60734_()) + " must be horizontal. " + String.valueOf(axis) + " is not allowed!");
                    }
                }
            }
        }
        v = v.m_82549_(verticalOffset);
        v = VecHelper.rotateCentered((Vec3)v, (double)rotationAngle, (Direction.Axis)Direction.Axis.Y);
        v = v.m_82546_(verticalOffset);
        v = v.m_82520_((double)offset.f_82470_, 0.0, (double)offset.f_82471_);
        return v;
    }

    public static BakedQuad clone(BakedQuad quad) {
        return new BakedQuad(Arrays.copyOf(quad.m_111303_(), quad.m_111303_().length), quad.m_111305_(), quad.m_111306_(), quad.m_173410_(), quad.m_111307_());
    }

    public static Vec3 getXYZ(int[] vertexData, int vertex) {
        float x = Float.intBitsToFloat(vertexData[vertex * VERTEX_STRIDE + 0]);
        float y = Float.intBitsToFloat(vertexData[vertex * VERTEX_STRIDE + 1]);
        float z = Float.intBitsToFloat(vertexData[vertex * VERTEX_STRIDE + 2]);
        return new Vec3((double)x, (double)y, (double)z);
    }

    public static void setXYZ(int[] vertexData, int vertex, Vec3 xyz) {
        vertexData[vertex * RotatedBlockModel.VERTEX_STRIDE + 0] = Float.floatToRawIntBits((float)xyz.f_82479_);
        vertexData[vertex * RotatedBlockModel.VERTEX_STRIDE + 1] = Float.floatToRawIntBits((float)xyz.f_82480_);
        vertexData[vertex * RotatedBlockModel.VERTEX_STRIDE + 2] = Float.floatToRawIntBits((float)xyz.f_82481_);
    }
}

