/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.data;

import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.util.MathUtils;
import de.mrjulsen.paw.data.CustomHitResultTypes;
import de.mrjulsen.wires.graph.NewWireCollision;
import de.mrjulsen.wires.graph.WireGraph;
import de.mrjulsen.wires.graph.WireGraphClient;
import de.mrjulsen.wires.graph.WireGraphManager;
import de.mrjulsen.wires.network.WireId;
import de.mrjulsen.wires.util.GraphId;
import de.mrjulsen.wires.util.Utils;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class WireHitResult
extends HitResult {
    private static final String NBT_VECTOR = "Vector";
    private static final String NBT_WIRE_POS = "PosOnWire";
    private static final String NBT_POS = "Pos";
    private static final String NBT_GRAPH_ID = "GraphId";
    private static final String NBT_WIRE = "Wire";
    private final BlockPos blockPos;
    private final float posOnWire;
    private final GraphId graphId;
    private final WireId wire;

    public WireHitResult(Vec3 location, float posOnWire, BlockPos pos, GraphId graphId, WireId wire) {
        super(location);
        this.blockPos = pos;
        this.posOnWire = posOnWire;
        this.graphId = graphId;
        this.wire = wire;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public float getPosOnWire() {
        return this.posOnWire;
    }

    public WireId getWireId() {
        return this.wire;
    }

    public GraphId getGraphId() {
        return this.graphId;
    }

    public float getWireLength(Level level) {
        return this.getCollision(level).map(x -> Float.valueOf(x.length(this.getWireId().name()))).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public float getPosPercentage(Level level) {
        return this.getCollision(level).map(x -> Float.valueOf(MathUtils.clamp((float)(1.0f / x.length(this.getWireId().name()) * this.getPosOnWire()), (float)0.0f, (float)1.0f))).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public Optional<NewWireCollision> getCollision(Level level) {
        Optional<NewWireCollision> collision = Optional.empty();
        if (level.m_5776_()) {
            WireGraphClient graph = WireGraphManager.getClient(level, this.getGraphId());
            collision = graph.getCollisionById(this.getWireId().id());
        } else if (DragonLib.hasServer()) {
            WireGraph graph = WireGraphManager.get(level, this.getGraphId());
            collision = graph.getCollisionById(this.getWireId().id());
        }
        return collision;
    }

    public HitResult.Type m_6662_() {
        return CustomHitResultTypes.WIRE.getType();
    }

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        Utils.putNbtVector3f(nbt, NBT_VECTOR, this.m_82450_().m_252839_());
        nbt.m_128350_(NBT_WIRE_POS, this.posOnWire);
        nbt.m_128359_(NBT_GRAPH_ID, this.graphId.id());
        Utils.putNbtBlockPos(nbt, NBT_POS, this.blockPos);
        nbt.m_128365_(NBT_WIRE, (Tag)this.wire.toNbt());
        return nbt;
    }

    public static Optional<WireHitResult> fromNbt(CompoundTag nbt) {
        return WireId.fromNbt(nbt.m_128469_(NBT_WIRE)).map(x -> new WireHitResult(new Vec3(Utils.getNbtVector3f(nbt, NBT_VECTOR)), nbt.m_128457_(NBT_WIRE_POS), Utils.getNbtBlockPos(nbt, NBT_POS), new GraphId(nbt.m_128461_(NBT_GRAPH_ID)), (WireId)x));
    }
}

