/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.event;

import de.mrjulsen.mcdragonlib.client.model.CustomBlockModelRegistry;
import de.mrjulsen.paw.PantographsAndWires;
import de.mrjulsen.paw.block.model.CantileverModel;
import de.mrjulsen.paw.registry.ModBlocks;
import de.mrjulsen.wires.graph.DLStatistics;
import de.mrjulsen.wires.graph.WireGraph;
import de.mrjulsen.wires.graph.WireGraphClient;
import de.mrjulsen.wires.graph.WireGraphManager;
import de.mrjulsen.wires.item.IWireItemBase;
import de.mrjulsen.wires.render.WireRenderer;
import de.mrjulsen.wires.util.ClientUtils;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientPlayerEvent;
import java.util.LinkedList;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.HitResult;

public final class ModClientEvents {
    public static final ResourceLocation WIRE_TEXTURE = new ResourceLocation("pantographsandwires", "textures/block/wire.png");

    private ModClientEvents() {
    }

    public static void init() {
        for (Supplier supplier : ModBlocks.getCantilevers()) {
            CustomBlockModelRegistry.registerForBlock(() -> ModClientEvents.lambda$init$0((Supplier)supplier), CantileverModel::new, null);
        }
        ClientGuiEvent.DEBUG_TEXT_LEFT.register(lines -> {
            if (!PantographsAndWires.useAdvancedLogging()) {
                return;
            }
            LinkedList<DLStatistics> serverStats = new LinkedList<DLStatistics>();
            for (WireGraph wireGraph : WireGraphManager.getAll(ClientUtils.level())) {
                serverStats.add(wireGraph.getStatistics());
            }
            LinkedList<DLStatistics> clientStats = new LinkedList<DLStatistics>();
            for (WireGraphClient graph : WireGraphManager.getAllClient(ClientUtils.level())) {
                clientStats.add(graph.getStatistics());
            }
            if (!serverStats.isEmpty()) {
                DLStatistics dLStatistics = DLStatistics.merge(((DLStatistics)serverStats.get(0)).getName(), (a, b) -> {
                    if (a instanceof Integer) {
                        Integer i = (Integer)a;
                        if (b instanceof Integer) {
                            Integer k = (Integer)b;
                            return i + k;
                        }
                    }
                    return a;
                }, (DLStatistics[])serverStats.toArray(DLStatistics[]::new));
                lines.add(dLStatistics.print(false));
            }
            if (!clientStats.isEmpty()) {
                DLStatistics dLStatistics = DLStatistics.merge(((DLStatistics)clientStats.get(0)).getName(), (a, b) -> {
                    if (a instanceof Integer) {
                        Integer i = (Integer)a;
                        if (b instanceof Integer) {
                            Integer k = (Integer)b;
                            return i + k;
                        }
                    }
                    return a;
                }, (DLStatistics[])clientStats.toArray(DLStatistics[]::new));
                lines.add(dLStatistics.print(false));
            }
        });
        ClientLifecycleEvent.CLIENT_STARTED.register(mc -> {
            if (Minecraft.m_91087_() != null) {
                ReloadableResourceManager reloadableManager = (ReloadableResourceManager)Minecraft.m_91087_().m_91098_();
                reloadableManager.m_7217_((PreparableReloadListener)new WireRenderer());
            } else {
                PantographsAndWires.LOGGER.error("Could not register ReloadableResourceManager.");
            }
        });
        ClientPlayerEvent.CLIENT_PLAYER_QUIT.register(server -> WireGraphManager.clearClient());
        ClientGuiEvent.RENDER_HUD.register((graphics, ticks) -> {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            for (InteractionHand hand : InteractionHand.values()) {
                HitResult lookingAt;
                IWireItemBase item;
                Component text;
                ItemStack stack = player.m_21120_(hand);
                Item patt0$temp = stack.m_41720_();
                if (!(patt0$temp instanceof IWireItemBase) || (text = (item = (IWireItemBase)patt0$temp).createHudInfoText(stack, (Player)Minecraft.m_91087_().f_91074_, lookingAt = Minecraft.m_91087_().f_91077_)) == null) continue;
                int scaledWidth = Minecraft.m_91087_().m_91268_().m_85445_();
                int scaledHeight = Minecraft.m_91087_().m_91268_().m_85446_();
                graphics.m_280653_(Minecraft.m_91087_().f_91062_, text, scaledWidth / 2, scaledHeight - 100, -1);
                break;
            }
        });
    }

    private static /* synthetic */ Block lambda$init$0(Supplier cantilever) {
        return (Block)cantilever.get();
    }
}

