/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.forge.client.model.loaders;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.paw.forge.client.model.loaders.MultipartObjModel;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.obj.ObjMaterialLibrary;
import net.minecraftforge.client.model.obj.ObjTokenizer;

public class MultipartObjLoader
implements IGeometryLoader<MultipartObjModel>,
ResourceManagerReloadListener {
    public static MultipartObjLoader INSTANCE = new MultipartObjLoader();
    public static final ResourceLocation ID = new ResourceLocation("pantographsandwires", "multipart_obj");
    private final Map<MultipartObjModel.ModelSettings, MultipartObjModel> modelCache = Maps.newConcurrentMap();
    private final Map<ResourceLocation, ObjMaterialLibrary> materialCache = Maps.newConcurrentMap();
    private ResourceManager manager = Minecraft.m_91087_().m_91098_();

    public void m_6213_(ResourceManager resourceManager) {
        this.modelCache.clear();
        this.materialCache.clear();
        this.manager = resourceManager;
    }

    public MultipartObjModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) {
        return this.readInternal(deserializationContext, jsonObject);
    }

    public MultipartObjModel readInternal(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
        if (!modelContents.has("model")) {
            throw new JsonParseException("OBJ Loader requires a 'model' key that points to a valid .OBJ model.");
        }
        if (!modelContents.has("loader") || !modelContents.get("loader").getAsString().equals(ID.toString())) {
            throw new RuntimeException("Importing invalid model loader.");
        }
        String modelLocation = modelContents.get("model").getAsString();
        boolean automaticCulling = GsonHelper.m_13855_((JsonObject)modelContents, (String)"automatic_culling", (boolean)true);
        boolean shadeQuads = GsonHelper.m_13855_((JsonObject)modelContents, (String)"shade_quads", (boolean)true);
        boolean flipV = GsonHelper.m_13855_((JsonObject)modelContents, (String)"flip_v", (boolean)false);
        boolean emissiveAmbient = GsonHelper.m_13855_((JsonObject)modelContents, (String)"emissive_ambient", (boolean)true);
        String mtlOverride = GsonHelper.m_13851_((JsonObject)modelContents, (String)"mtl_override", null);
        ArrayList<MultipartObjModel.SubModelSettings> subSettings = new ArrayList<MultipartObjModel.SubModelSettings>();
        if (modelContents.has("add")) {
            for (JsonElement element : GsonHelper.m_13933_((JsonObject)modelContents, (String)"add")) {
                subSettings.add((MultipartObjModel.SubModelSettings)DragonLib.GSON.fromJson(element, MultipartObjModel.SubModelSettings.class));
            }
        }
        MultipartObjModel.ModelSettings settings = new MultipartObjModel.ModelSettings(new ResourceLocation(modelLocation), automaticCulling, shadeQuads, flipV, emissiveAmbient, mtlOverride, subSettings);
        MultipartObjModel model = this.loadModel(settings);
        int i = 0;
        for (MultipartObjModel.SubModelSettings subModelSettings : settings.subSettings()) {
            ++i;
            MultipartObjModel subModel = subModelSettings.isJson() ? this.readSubModel(new ResourceLocation(subModelSettings.model())) : this.loadModel(new MultipartObjModel.ModelSettings(new ResourceLocation(subModelSettings.model()), automaticCulling, shadeQuads, flipV, emissiveAmbient, mtlOverride, List.of()));
            for (MultipartObjModel.ModelObject modelObject : subModel.getParts()) {
                MultipartObjModel.ModelGroup group = (MultipartObjModel.ModelGroup)modelObject;
                if (!group.settings.inheritable()) continue;
                String newName = "m" + i + "_" + modelObject.name();
                group = group.copy(subModelSettings, newName);
                model.addPart(group.name(), group);
            }
        }
        return model;
    }

    private MultipartObjModel readSubModel(ResourceLocation location) {
        try {
            Resource resource = (Resource)this.manager.m_213713_(location).orElseThrow();
            InputStreamReader reader = new InputStreamReader(resource.m_215507_(), StandardCharsets.UTF_8);
            JsonObject obj = GsonHelper.m_13859_((Reader)reader);
            return this.readInternal(null, obj);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public MultipartObjModel loadModel(MultipartObjModel.ModelSettings settings) {
        return this.modelCache.computeIfAbsent(settings, data -> {
            MultipartObjModel multipartObjModel;
            Resource resource = (Resource)this.manager.m_213713_(settings.modelLocation()).orElseThrow();
            ObjTokenizer tokenizer = new ObjTokenizer(resource.m_215507_());
            try {
                multipartObjModel = MultipartObjModel.parse(tokenizer, settings);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        tokenizer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException("Could not find OBJ model", e);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not read OBJ model", e);
                }
            }
            tokenizer.close();
            return multipartObjModel;
        });
    }

    public ObjMaterialLibrary loadMaterialLibrary(ResourceLocation materialLocation) {
        return this.materialCache.computeIfAbsent(materialLocation, location -> {
            ObjMaterialLibrary objMaterialLibrary;
            Resource resource = (Resource)this.manager.m_213713_(location).orElseThrow();
            ObjTokenizer rdr = new ObjTokenizer(resource.m_215507_());
            try {
                objMaterialLibrary = new ObjMaterialLibrary(rdr);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        rdr.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException("Could not find OBJ material library", e);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not read OBJ material library", e);
                }
            }
            rdr.close();
            return objMaterialLibrary;
        });
    }
}

