/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.item;

import de.mrjulsen.mcdragonlib.util.MathUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.paw.block.abstractions.AbstractCantileverBlock;
import de.mrjulsen.paw.block.property.EInsulatorType;
import de.mrjulsen.paw.blockentity.CantileverBlockEntity;
import de.mrjulsen.paw.data.CantileverSettingsData;
import de.mrjulsen.paw.event.ClientWrapper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class CantileverBlockItem<T extends AbstractCantileverBlock>
extends BlockItem {
    private static final String KEY_TOO_SMALL_FOR_ADDITIONAL_CANTILEVERS = "block.pantographsandwires.cantilever.too_small_for_multiple_cantilevers";
    private final EInsulatorType insulatorType;

    public CantileverBlockItem(T block, EInsulatorType insulatorType, Item.Properties properties) {
        super(block, properties);
        this.insulatorType = insulatorType;
    }

    public AbstractCantileverBlock getCantilever() {
        return (AbstractCantileverBlock)this.m_40614_();
    }

    public EInsulatorType getInsulatorType() {
        return this.insulatorType;
    }

    protected boolean m_7274_(BlockPos pos, Level level, Player player, ItemStack stack, BlockState state) {
        CantileverBlockEntity be;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CantileverBlockEntity && (be = (CantileverBlockEntity)blockEntity).shouldNotUpdate()) {
            be.setDoNotUpdate(false);
            return false;
        }
        return super.m_7274_(pos, level, player, stack, state);
    }

    protected boolean m_7429_(BlockPlaceContext context, BlockState state) {
        Level level = context.m_43725_();
        BlockEntity blockEntity = level.m_7702_(context.m_8083_());
        if (blockEntity instanceof CantileverBlockEntity) {
            CantileverBlockEntity be = (CantileverBlockEntity)blockEntity;
            byte allowedCount = AbstractCantileverBlock.additionalCantileversCheck(be.getWidth(), be.getHeight(), be.getCatenaryHeight());
            byte currentCount = be.getCantileversCount();
            if (currentCount < allowedCount) {
                byte count = (byte)(be.getCantileversCount() + 1);
                be.getSubCanileverSettings()[count - 2] = new CantileverBlockEntity.SubCantileverSetting((byte)(count - 2), CantileverBlockItem.getCantileverType(context.m_43722_()), CantileverBlockItem.getShowBracing(context.m_43722_()));
                be.setCantileversCount(count);
                be.update();
                be.setDoNotUpdate(true);
                return true;
            }
            if (allowedCount < 3) {
                context.m_43723_().m_5661_((Component)TextUtils.translate((String)KEY_TOO_SMALL_FOR_ADDITIONAL_CANTILEVERS).m_130940_(ChatFormatting.RED), true);
            }
        }
        return super.m_7429_(context, state);
    }

    public static CompoundTag getNbt(ItemStack stack) {
        CompoundTag nbt;
        CompoundTag itemNbt = stack.m_41784_();
        if (itemNbt.m_128441_("BlockEntityTag")) {
            nbt = itemNbt.m_128469_("BlockEntityTag");
        } else {
            nbt = new CompoundTag();
            itemNbt.m_128365_("BlockEntityTag", (Tag)nbt);
        }
        if (!nbt.m_128441_("Width")) {
            nbt.m_128350_("Width", 2.5f);
        } else {
            nbt.m_128350_("Width", MathUtils.clamp((float)nbt.m_128457_("Width"), (float)1.5f, (float)6.5f));
        }
        if (!nbt.m_128441_("Height")) {
            nbt.m_128350_("Height", 1.5f);
        } else {
            nbt.m_128350_("Height", MathUtils.clamp((float)nbt.m_128457_("Height"), (float)0.0f, (float)3.0f));
        }
        if (!nbt.m_128441_("CatenaryHeight")) {
            nbt.m_128350_("CatenaryHeight", 1.0f);
        } else {
            nbt.m_128350_("CatenaryHeight", MathUtils.clamp((float)nbt.m_128457_("CatenaryHeight"), (float)0.0f, (float)3.0f));
        }
        if (!nbt.m_128441_("RegistrationArmType")) {
            nbt.m_128405_("RegistrationArmType", CantileverBlockEntity.DEFAULT_REGISTRATION_ARM_TYPE.ordinal());
        } else {
            nbt.m_128405_("RegistrationArmType", MathUtils.clamp((int)nbt.m_128451_("RegistrationArmType"), (int)0, (int)(AbstractCantileverBlock.ECantileverRegistrationArmType.values().length - 1)));
        }
        if (!nbt.m_128441_("InsulatorPlacement")) {
            nbt.m_128405_("InsulatorPlacement", CantileverBlockEntity.DEFAULT_INSULATOR_PLACEMENT.ordinal());
        } else {
            nbt.m_128405_("InsulatorPlacement", MathUtils.clamp((int)nbt.m_128451_("InsulatorPlacement"), (int)0, (int)(AbstractCantileverBlock.ECantileverInsulatorsPlacement.values().length - 1)));
        }
        return nbt;
    }

    public static boolean setNbt(ItemStack stack, CantileverSettingsData data) {
        if (stack.m_41720_() instanceof CantileverBlockItem) {
            CompoundTag nbt = CantileverBlockItem.getNbt(stack);
            nbt.m_128350_("Width", data.width());
            nbt.m_128350_("Height", data.height());
            nbt.m_128350_("CatenaryHeight", data.catenaryHeight());
            nbt.m_128405_("RegistrationArmType", data.cantileverType().ordinal());
            nbt.m_128405_("InsulatorPlacement", data.insulatorPlacement().ordinal());
            nbt.m_128379_("ShowBracing", data.showBracing());
            return true;
        }
        return false;
    }

    public static float getWidth(ItemStack stack) {
        if (stack != null && stack.m_41720_() instanceof CantileverBlockItem) {
            return CantileverBlockItem.getNbt(stack).m_128457_("Width");
        }
        return 1.5f;
    }

    public static float getHeight(ItemStack stack) {
        if (stack != null && stack.m_41720_() instanceof CantileverBlockItem) {
            return CantileverBlockItem.getNbt(stack).m_128457_("Height");
        }
        return 1.5f;
    }

    public static boolean getShowBracing(ItemStack stack) {
        if (stack != null && stack.m_41720_() instanceof CantileverBlockItem) {
            return CantileverBlockItem.getNbt(stack).m_128471_("ShowBracing");
        }
        return false;
    }

    public static float getCatenaryHeight(ItemStack stack) {
        if (stack != null && stack.m_41720_() instanceof CantileverBlockItem) {
            return CantileverBlockItem.getNbt(stack).m_128457_("CatenaryHeight");
        }
        return 1.5f;
    }

    public static AbstractCantileverBlock.ECantileverRegistrationArmType getCantileverType(ItemStack stack) {
        if (stack != null && stack.m_41720_() instanceof CantileverBlockItem) {
            return AbstractCantileverBlock.ECantileverRegistrationArmType.values()[CantileverBlockItem.getNbt(stack).m_128451_("RegistrationArmType")];
        }
        return AbstractCantileverBlock.ECantileverRegistrationArmType.def();
    }

    public static AbstractCantileverBlock.ECantileverInsulatorsPlacement getInsulatorPlacement(ItemStack stack) {
        if (stack != null && stack.m_41720_() instanceof CantileverBlockItem) {
            return AbstractCantileverBlock.ECantileverInsulatorsPlacement.values()[CantileverBlockItem.getNbt(stack).m_128451_("InsulatorPlacement")];
        }
        return AbstractCantileverBlock.ECantileverInsulatorsPlacement.def();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.m_21120_(usedHand);
        if (level.f_46443_) {
            ClientWrapper.showCantileverSettingsScreen(stack);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }
}

