/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.item;

import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.paw.client.gui.ModGuiIcons;
import de.mrjulsen.paw.config.ModServerConfig;
import de.mrjulsen.paw.data.WireHitResult;
import de.mrjulsen.paw.registry.ModBlocks;
import de.mrjulsen.paw.registry.ModWireRegistry;
import de.mrjulsen.wires.IWireType;
import de.mrjulsen.wires.WiresApi;
import de.mrjulsen.wires.graph.WireGraphClient;
import de.mrjulsen.wires.graph.WireGraphManager;
import de.mrjulsen.wires.graph.data.node.LatticeMastNodeData;
import de.mrjulsen.wires.graph.data.node.NodeData;
import de.mrjulsen.wires.graph.registry.DLStaticRegistryObject;
import de.mrjulsen.wires.item.IPawWireItemBase;
import de.mrjulsen.wires.item.IWireItemBase;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CatenaryHeadspanWireItem
implements IPawWireItemBase {
    public static final String NBT_UPPER_WIRE_HEIGHT = "UpperWireHeight";
    public static final String NBT_TOP_WIRE_HEIGHT = "TopWireHeight";
    private static final String KEY_HEIGHT_DIFFERENCE_TOO_SMALL = "item.pantographsandwires.catenary_headspan.small_height_difference";
    private static final String KEY_HEIGHT_DIFFERENCE_TOO_LARGE = "item.pantographsandwires.catenary_headspan.large_height_difference";

    @Override
    public InteractionResult interactWithWire(Level level, Player player, InteractionHand hand, WireHitResult hit) {
        return this.placeWire(level, player, hand, hit, (a, b) -> {});
    }

    @Override
    public IWireType getWireType(ItemStack stack) {
        return ModWireRegistry.CATENARY_HEADSPAN;
    }

    @Override
    public DLStaticRegistryObject<IPawWireItemBase> getRegistryType() {
        return ModWireRegistry.CATENARY_HEADSPAN_ITEM_SUBTYPE;
    }

    @Override
    public String getTranslationKey() {
        return "wire.pantographsandwires.catenary_headspan";
    }

    @Override
    public ModGuiIcons getIcon() {
        return ModGuiIcons.CATENARY_HEADSPAN_WIRE;
    }

    @Override
    public NodeData createNodeData(Level level, Player player, InteractionHand hand, HitResult hit) {
        BlockHitResult h;
        if (hit instanceof BlockHitResult && level.m_8055_((h = (BlockHitResult)hit).m_82425_()).m_204343_().anyMatch(x -> x.equals(ModBlocks.TAG_CATENARY_HEADSPAN_CONNECTABLE))) {
            return new LatticeMastNodeData(h.m_82425_());
        }
        return null;
    }

    @Override
    public InteractionResult placeWire(Level level, Player player, InteractionHand hand, HitResult hit, BiConsumer<CompoundTag, CompoundTag> metadata) {
        if (level.m_5776_()) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.m_21120_(hand);
        if (!(stack.m_41720_() instanceof IWireItemBase)) {
            return InteractionResult.FAIL;
        }
        CompoundTag itemData = IWireItemBase.getNbt(stack);
        CompoundTag customDataNbt = itemData.m_128469_("CustomData");
        ArrayList<CompoundTag> points = new ArrayList<CompoundTag>();
        if (itemData.m_128441_("CustomPointData")) {
            points.addAll(itemData.m_128437_("CustomPointData", 10).stream().map(x -> (CompoundTag)x).toList());
        }
        if (points.size() < 2) {
            if (!this.addNewPoint(level, player, hand, hit, metadata, stack, itemData, customDataNbt, points)) {
                IWireItemBase.clear(stack);
                return InteractionResult.FAIL;
            }
        } else if (!customDataNbt.m_128441_(NBT_UPPER_WIRE_HEIGHT) || !customDataNbt.m_128441_(NBT_TOP_WIRE_HEIGHT)) {
            CompoundTag startPointData = (CompoundTag)points.get(0);
            CompoundTag endPointData = (CompoundTag)points.get(1);
            NodeData nodeA = WiresApi.NODE_DATA_REGISTRY.load(startPointData);
            NodeData nodeB = WiresApi.NODE_DATA_REGISTRY.load(endPointData);
            if (nodeA instanceof LatticeMastNodeData) {
                LatticeMastNodeData nA = (LatticeMastNodeData)nodeA;
                if (nodeB instanceof LatticeMastNodeData) {
                    BlockHitResult h;
                    LatticeMastNodeData nB = (LatticeMastNodeData)nodeB;
                    if (hit instanceof BlockHitResult && level.m_8055_((h = (BlockHitResult)hit).m_82425_()).m_204343_().anyMatch(x -> x.equals(ModBlocks.TAG_CATENARY_HEADSPAN_CONNECTABLE))) {
                        if (!customDataNbt.m_128441_(NBT_UPPER_WIRE_HEIGHT)) {
                            int min = (Integer)ModServerConfig.CATENARY_HEADSPAN_MIN_UPPER_TENSION_WIRE.get();
                            int max = (Integer)ModServerConfig.CATENARY_HEADSPAN_MAX_UPPER_TENSION_WIRE.get();
                            float d = h.m_82425_().m_123342_() - nB.getBlockPos().m_123342_();
                            if (d < (float)min) {
                                player.m_5661_((Component)TextUtils.translate((String)KEY_HEIGHT_DIFFERENCE_TOO_SMALL, (Object[])new Object[]{min, max}).m_130940_(ChatFormatting.RED), true);
                                IWireItemBase.clear(stack);
                                return InteractionResult.FAIL;
                            }
                            if (d > (float)max) {
                                player.m_5661_((Component)TextUtils.translate((String)KEY_HEIGHT_DIFFERENCE_TOO_LARGE, (Object[])new Object[]{min, max}).m_130940_(ChatFormatting.RED), true);
                                IWireItemBase.clear(stack);
                                return InteractionResult.FAIL;
                            }
                            customDataNbt.m_128350_(NBT_UPPER_WIRE_HEIGHT, d);
                        } else if (!customDataNbt.m_128441_(NBT_TOP_WIRE_HEIGHT)) {
                            float p = customDataNbt.m_128457_(NBT_UPPER_WIRE_HEIGHT);
                            float min = p + (float)CatenaryHeadspanWireItem.calcSupportWireMinHeightDifference(new Vector3f((float)nA.getBlockPos().m_123341_(), (float)nA.getBlockPos().m_123342_(), (float)nA.getBlockPos().m_123343_()), new Vector3f((float)nB.getBlockPos().m_123341_(), (float)nB.getBlockPos().m_123342_(), (float)nB.getBlockPos().m_123343_()));
                            float max = min + (float)((Integer)ModServerConfig.CATENARY_HEADSPAN_MAX_TOP_SUPPORT_WIRE.get()).intValue();
                            float d = (float)(h.m_82425_().m_123342_() - nB.getBlockPos().m_123342_()) - p;
                            if (d < min) {
                                player.m_5661_((Component)TextUtils.translate((String)KEY_HEIGHT_DIFFERENCE_TOO_SMALL, (Object[])new Object[]{Float.valueOf(min), Float.valueOf(max)}).m_130940_(ChatFormatting.RED), true);
                                IWireItemBase.clear(stack);
                                return InteractionResult.FAIL;
                            }
                            if (d > max) {
                                player.m_5661_((Component)TextUtils.translate((String)KEY_HEIGHT_DIFFERENCE_TOO_LARGE, (Object[])new Object[]{Float.valueOf(min), Float.valueOf(max)}).m_130940_(ChatFormatting.RED), true);
                                IWireItemBase.clear(stack);
                                return InteractionResult.FAIL;
                            }
                            customDataNbt.m_128350_(NBT_TOP_WIRE_HEIGHT, d);
                        }
                    }
                }
            }
        }
        ListTag pointsList = new ListTag();
        for (CompoundTag p : points) {
            pointsList.add((Object)p);
        }
        itemData.m_128365_("CustomPointData", (Tag)pointsList);
        itemData.m_128365_("CustomData", (Tag)customDataNbt);
        IWireItemBase.setNbt(stack, itemData);
        if (this.canCreateWire(level, player, hand, hit, stack, itemData, customDataNbt, points)) {
            this.createWire(level, player, hand, hit, stack, itemData, customDataNbt, points);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public boolean canCreateWire(Level level, Player player, InteractionHand hand, HitResult hit, ItemStack stack, CompoundTag itemData, CompoundTag customDataNbt, List<CompoundTag> points) {
        return IPawWireItemBase.super.canCreateWire(level, player, hand, hit, stack, itemData, customDataNbt, points) && customDataNbt.m_128441_(NBT_UPPER_WIRE_HEIGHT) && customDataNbt.m_128441_(NBT_TOP_WIRE_HEIGHT);
    }

    @Override
    public Component createHudInfoText(ItemStack stack, Player player, HitResult hit) {
        Vector3f targetPos;
        if (!stack.m_41782_()) {
            return null;
        }
        CompoundTag itemData = IWireItemBase.getNbt(stack);
        ListTag list = itemData.m_128437_("CustomPointData", 10);
        if (list.size() < 2) {
            return IPawWireItemBase.super.createHudInfoText(stack, player, hit);
        }
        WireGraphClient graph = WireGraphManager.getClient(player.m_9236_(), this.getWireType(stack).getGraphId(itemData));
        if (graph == null || list.isEmpty()) {
            return null;
        }
        CompoundTag customDataNbt = itemData.m_128469_("CustomData");
        CompoundTag startPointData = (CompoundTag)list.get(0);
        CompoundTag endPointData = (CompoundTag)list.get(1);
        NodeData nodeA = WiresApi.NODE_DATA_REGISTRY.load(startPointData);
        NodeData nodeB = WiresApi.NODE_DATA_REGISTRY.load(endPointData);
        Vector3f pos = nodeB.toWorldPos(graph);
        if (hit instanceof BlockHitResult) {
            BlockHitResult r = (BlockHitResult)hit;
            targetPos = r.m_82450_().m_252839_();
        } else {
            targetPos = player.m_146892_().m_252839_();
        }
        if (!customDataNbt.m_128441_(NBT_UPPER_WIRE_HEIGHT)) {
            int min = (Integer)ModServerConfig.CATENARY_HEADSPAN_MIN_UPPER_TENSION_WIRE.get();
            int max = (Integer)ModServerConfig.CATENARY_HEADSPAN_MAX_UPPER_TENSION_WIRE.get();
            int diff = (int)Math.floor(targetPos.y()) - (int)pos.y();
            return TextUtils.empty().m_130940_(ChatFormatting.WHITE).m_7220_((Component)TextUtils.text((String)String.format("Y: %s", (int)pos.y())).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)TextUtils.text((String)" \u25a0 ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)TextUtils.text((String)"Upper Tension Wire height difference").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)TextUtils.text((String)" \u25a0 ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)TextUtils.text((String)String.format("%sm [%sm - %sm]", diff, min, max)).m_130940_(diff < min || diff > max ? ChatFormatting.RED : ChatFormatting.GREEN));
        }
        if (!customDataNbt.m_128441_(NBT_TOP_WIRE_HEIGHT)) {
            float min = customDataNbt.m_128457_(NBT_UPPER_WIRE_HEIGHT) + (float)CatenaryHeadspanWireItem.calcSupportWireMinHeightDifference(nodeA.toWorldPos(graph), nodeB.toWorldPos(graph));
            float max = min + (float)((Integer)ModServerConfig.CATENARY_HEADSPAN_MAX_TOP_SUPPORT_WIRE.get()).intValue();
            int diff = (int)(Math.floor(targetPos.y()) - (double)pos.y() - (double)min);
            return TextUtils.empty().m_130940_(ChatFormatting.WHITE).m_7220_((Component)TextUtils.text((String)String.format("Y: %s", (int)pos.y())).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)TextUtils.text((String)" \u25a0 ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)TextUtils.text((String)"Top Support Wire height difference").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)TextUtils.text((String)" \u25a0 ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)TextUtils.text((String)String.format("%sm [%sm - %sm]", diff, Float.valueOf(min), Float.valueOf(max))).m_130940_((float)diff < min || (float)diff > max ? ChatFormatting.RED : ChatFormatting.GREEN));
        }
        return TextUtils.empty();
    }

    public static int calcSupportWireMinHeightDifference(Vector3f a, Vector3f b) {
        return (int)Math.floor(a.distance((Vector3fc)b) / 16.0f);
    }
}

