/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.item;

import com.eliotlash.mclib.utils.MathUtils;
import de.mrjulsen.mcdragonlib.data.Pair;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.paw.block.RegistrationArmBlock;
import de.mrjulsen.paw.block.abstractions.AbstractCantileverBlock;
import de.mrjulsen.paw.config.ModServerConfig;
import de.mrjulsen.paw.data.WireHitResult;
import de.mrjulsen.paw.item.CantileverBlockItem;
import de.mrjulsen.paw.item.PAWWireType;
import de.mrjulsen.paw.registry.InsulatorWireDecoration;
import de.mrjulsen.paw.registry.ModItems;
import de.mrjulsen.paw.registry.ModWireRegistry;
import de.mrjulsen.paw.registry.RegistrationArmWireDecoration;
import de.mrjulsen.paw.util.ModMath;
import de.mrjulsen.wires.SegmentControl;
import de.mrjulsen.wires.Wire;
import de.mrjulsen.wires.WireBatch;
import de.mrjulsen.wires.WireBuilder;
import de.mrjulsen.wires.WireCreationContext;
import de.mrjulsen.wires.WirePoints;
import de.mrjulsen.wires.WiresApi;
import de.mrjulsen.wires.decoration.IWireDecoration;
import de.mrjulsen.wires.decoration.WireDecorationData;
import de.mrjulsen.wires.graph.NewWireCollision;
import de.mrjulsen.wires.graph.WireEdge;
import de.mrjulsen.wires.graph.WireGraph;
import de.mrjulsen.wires.graph.WireGraphManager;
import de.mrjulsen.wires.graph.WireNode;
import de.mrjulsen.wires.graph.data.WireConnectionData;
import de.mrjulsen.wires.graph.data.accessor.GenericWireNodeAccessor;
import de.mrjulsen.wires.graph.data.accessor.NodeAccessor;
import de.mrjulsen.wires.graph.data.node.NodeData;
import de.mrjulsen.wires.graph.registry.NodeDataRegistryObject;
import de.mrjulsen.wires.network.WireId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CatenaryHeadspanWireType
extends PAWWireType {
    private static final String KEY_NOT_ENOUGH_INSULATORS = "item.pantographsandwires.wire.not_enough_insulators";
    private static final String KEY_INVALID_DECORATION_POSITION = "item.pantographsandwires.wire.invalid_decoration_position";
    private static final String KEY_ONE_INVALID_DECORATION_POSITION = "item.pantographsandwires.wire.one_invalid_decoration_position";
    private static final String KEY_DROPPER_HAS_REGISTRATION_ARM = "item.pantographsandwires.catenary_headspan.dropper_has_registration_arm";
    private static final String KEY_INVALID_DROPPER_LOCATION = "item.pantographsandwires.catenary_headspan.invalid_dropper_position";
    private static final String KEY_DROPPER_EXISTS = "item.pantographsandwires.catenary_headspan.dropper_exists";
    public static final String WIRE_UPPER_TENSION = "upper_tension_wire";
    public static final String WIRE_LOWER_TENSION = "lower_tension_wire";
    public static final String WIRE_TOP_SUPPORT_WIRE = "headspan_wire";
    public static final String WIRE_DROPPER_L = "dropper_l_";
    public static final String WIRE_DROPPER_U = "dropper_u_";
    public static final String WIRE_CROSS_CONNECTION = "cross_connection";
    public static final String NBT_DROPPERS = "Droppers";
    private static final float THICKNESS = 0.046875f;
    private static final float DECORATION_GRID_SIZE = 0.5f;

    public CatenaryHeadspanWireType(ResourceLocation location) {
        super(location);
    }

    @Override
    public int getMaxLength() {
        return (Integer)ModServerConfig.CATENARY_WIRE_MAX_LENGTH.get();
    }

    @Override
    public int getWireLength(int connectionLength) {
        return connectionLength * 4;
    }

    @Override
    public WireBatch buildWire(WireCreationContext context, BlockAndTintGetter level, WireConnectionData customData, WireEdge edge, WireNode nodeA, WireNode nodeB) {
        Vector3f start = nodeA.getPos();
        Vector3f end = nodeB.getPos();
        float upperWireHeight = customData.customData().getCommonData().m_128457_("UpperWireHeight");
        float topWireHeight = upperWireHeight + customData.customData().getCommonData().m_128457_("TopWireHeight") + 0.4f;
        float wireLength = new Vector3f((Vector3fc)end).sub((Vector3fc)start).length();
        int subSegments = (int)(wireLength / 2.0f);
        List<Dropper> droppers = customData.customData().getCommonData().m_128437_(NBT_DROPPERS, 10).stream().map(x -> Dropper.fromNbt((CompoundTag)x)).sorted(Dropper::compareTo).toList();
        float[] dropperDistances = new float[droppers.size()];
        float lastDropperDistance = 0.0f;
        for (int i = 0; i < droppers.size(); ++i) {
            dropperDistances[i] = wireLength * (droppers.get(i).pos() - lastDropperDistance);
            lastDropperDistance = droppers.get(i).pos();
        }
        Vector3f direction = new Vector3f((Vector3fc)end).sub((Vector3fc)start);
        direction = new Vector3f(direction.x(), 0.0f, direction.z());
        Vector3f rightVec = new Vector3f(direction.z(), 0.0f, -direction.x()).normalize();
        direction.absolute().normalize();
        Vector3f offsetA = new Vector3f((Vector3fc)rightVec).mul(0.125f);
        Vector3f offsetB = new Vector3f((Vector3fc)rightVec).mul(-0.125f);
        Wire topWire1 = WireBuilder.createWire("headspan_wire1", context, new Vector3f((Vector3fc)start).add(offsetA.x(), topWireHeight, offsetA.z()), new Vector3f((Vector3fc)end).add(offsetA.x(), topWireHeight, offsetA.z()), WireBuilder.CableType.HANGING, 0.046875f, topWireHeight - upperWireHeight - 1.0f, SegmentControl.create(dropperDistances.length <= 0 ? SegmentControl.Config.auto() : SegmentControl.Config.custom(dropperDistances, false), SegmentControl.Config.maxLength(3.0f)));
        Wire topWire2 = WireBuilder.createWire("headspan_wire2", context, new Vector3f((Vector3fc)start).add(offsetB.x(), topWireHeight, offsetB.z()), new Vector3f((Vector3fc)end).add(offsetB.x(), topWireHeight, offsetB.z()), WireBuilder.CableType.TENSION, 0.046875f, topWireHeight - upperWireHeight - 1.0f, SegmentControl.create(dropperDistances.length <= 0 ? SegmentControl.Config.auto() : SegmentControl.Config.custom(dropperDistances, false), SegmentControl.Config.maxLength(3.0f)));
        Wire upperWire = WireBuilder.createWire(WIRE_UPPER_TENSION, context, new Vector3f((Vector3fc)start).add(0.0f, upperWireHeight, 0.0f), new Vector3f((Vector3fc)end).add(0.0f, upperWireHeight, 0.0f), WireBuilder.CableType.TIGHT, 0.046875f, 0.0f, SegmentControl.create(SegmentControl.Config.custom(dropperDistances, false), SegmentControl.Config.maxLength(3.0f)));
        Wire lowerWire = WireBuilder.createWire(WIRE_LOWER_TENSION, context, new Vector3f((Vector3fc)start).add(0.0f, -0.125f, 0.0f), new Vector3f((Vector3fc)end).add(0.0f, -0.125f, 0.0f), WireBuilder.CableType.TIGHT, 0.046875f, 0.0f, SegmentControl.create(SegmentControl.Config.custom(dropperDistances, false), SegmentControl.Config.maxLength(3.0f)));
        WireBatch batch = WireBatch.of(lowerWire, upperWire, topWire1, topWire2);
        if (dropperDistances.length > 0 && upperWire.getCollisionData().isPresent() && lowerWire.getCollisionData().isPresent() && topWire1.getCollisionData().isPresent() && topWire2.getCollisionData().isPresent()) {
            WirePoints topRenderData1 = topWire1.collisionData();
            WirePoints topRenderData2 = topWire2.collisionData();
            ArrayList<Wire> crossConnectionWires = new ArrayList<Wire>(topRenderData1.vertices().length);
            int i = 1;
            int c = 0;
            while (i < topRenderData1.vertices().length && i < topRenderData2.vertices().length - 1) {
                crossConnectionWires.add(batch.addSubWire(WireBuilder.createWire(WIRE_CROSS_CONNECTION + c, context, topRenderData1.vertices()[i], topRenderData2.vertices()[i], WireBuilder.CableType.TIGHT, 0.046875f, 0.0f, SegmentControl.single())));
                ++i;
                ++c;
            }
            WirePoints lowerRenderData = lowerWire.collisionData();
            WirePoints upperRenderData = upperWire.collisionData();
            int i2 = 1;
            for (int c2 = 0; i2 < lowerRenderData.vertices().length && i2 < upperRenderData.vertices().length && c2 < crossConnectionWires.size(); ++i2, ++c2) {
                UUID dropperId = droppers.get(c2).id();
                WirePoints crossConnectionWire = ((Wire)crossConnectionWires.get(c2)).collisionData();
                boolean noDropperL = false;
                for (WireDecorationData decoData : edge.getDecorations()) {
                    RegistrationArmWireDecoration deco;
                    IWireDecoration<?> iWireDecoration = decoData.getDecoration();
                    if (!(iWireDecoration instanceof RegistrationArmWireDecoration) || !(deco = (RegistrationArmWireDecoration)iWireDecoration).getDropperId().equals(dropperId)) continue;
                    noDropperL = deco.getVariant().isAbove();
                    break;
                }
                batch.addSubWire(WireBuilder.createWire(WIRE_DROPPER_L + String.valueOf(dropperId), noDropperL ? WireCreationContext.COLLISION : context, lowerRenderData.vertices()[i2], upperRenderData.vertices()[i2], WireBuilder.CableType.TIGHT, 0.046875f, 0.0f, SegmentControl.single()));
                batch.addSubWire(WireBuilder.createWire(WIRE_DROPPER_U + String.valueOf(dropperId), context, upperRenderData.vertices()[i2], ModMath.centerOf(crossConnectionWire.vertices()[0], crossConnectionWire.vertices()[1]), WireBuilder.CableType.TIGHT, 0.046875f, 0.0f, SegmentControl.single()));
            }
        }
        return batch;
    }

    @Override
    public InteractionResult use(Level level, Player player, InteractionHand hand, WireHitResult hitResult) {
        if (!level.m_5776_()) {
            WireGraph network = WireGraphManager.get(level, hitResult.getGraphId());
            WireEdge edge = network.getEdge(hitResult.getWireId().id());
            if (edge == null) {
                return InteractionResult.FAIL;
            }
            if ((player.m_21120_(hand).m_150930_(Items.f_42574_) || player.m_21120_(hand).m_204117_(ModItems.TAG_WRENCH)) && (hitResult.getWireId().name().startsWith(WIRE_DROPPER_L) || hitResult.getWireId().name().startsWith(WIRE_DROPPER_U))) {
                UUID dropperId;
                try {
                    dropperId = UUID.fromString(hitResult.getWireId().name().replace(WIRE_DROPPER_L, "").replace(WIRE_DROPPER_U, ""));
                }
                catch (Exception e) {
                    return InteractionResult.FAIL;
                }
                CompoundTag nbt = edge.getWireConnectionData().customData().getCommonData();
                List<Dropper> points = nbt.m_128437_(NBT_DROPPERS, 10).stream().map(x -> Dropper.fromNbt((CompoundTag)x)).filter(x -> !x.id().equals(dropperId)).toList();
                ListTag li = new ListTag();
                for (Dropper dropper : points) {
                    li.add((Object)dropper.toNbt());
                }
                nbt.m_128365_(NBT_DROPPERS, (Tag)li);
                Collection<WireDecorationData> decorations = edge.getDecorations(deco -> {
                    RegistrationArmWireDecoration d;
                    IWireDecoration<?> patt0$temp = deco.getDecoration();
                    return patt0$temp instanceof RegistrationArmWireDecoration && (d = (RegistrationArmWireDecoration)patt0$temp).getDropperId().equals(dropperId);
                });
                for (WireDecorationData decoration : decorations) {
                    edge.removeDecorations(level, Optional.of(player), WIRE_LOWER_TENSION, List.of(decoration));
                }
                for (NodeDataRegistryObject<NodeData, NodeAccessor<?>> type : WiresApi.NODE_DATA_REGISTRY.getRegisteredTypes()) {
                    NodeAccessor<?> nodeAccessor;
                    Optional<NodeAccessor<?>> accessor = type.getAccessor(network);
                    if (!accessor.isPresent() || !((nodeAccessor = accessor.get()) instanceof GenericWireNodeAccessor)) continue;
                    GenericWireNodeAccessor a = (GenericWireNodeAccessor)nodeAccessor;
                    ArrayList<WireNode> nodes = new ArrayList<WireNode>(a.get(hitResult.getWireId()));
                    for (WireNode node : nodes) {
                        network.removeNode(node.getId(), node.getPos(), Optional.of(player));
                        a.remove(node);
                    }
                }
                network.setAndUpdateEdge(edge, true);
                network.m_77762_();
            } else if (player.m_21120_(hand).m_150930_(Items.f_42574_)) {
                network.removeEdge(hitResult.getWireId().id(), hitResult.m_82450_().m_252839_(), Optional.of(player));
            } else if (player.m_21120_(hand).m_204117_(ModItems.TAG_WRENCH)) {
                if (edge != null) {
                    UUID dropperId;
                    Optional<NewWireCollision> collisionOpt = hitResult.getCollision(level);
                    if (!collisionOpt.isPresent()) {
                        return InteractionResult.FAIL;
                    }
                    NewWireCollision collision = collisionOpt.get();
                    float pos = (float)ModMath.snapNearest(hitResult.getPosOnWire(), 0.5);
                    float posPercentage = MathUtils.clamp((float)(1.0f / collision.length(hitResult.getWireId().name()) * pos), (float)0.0f, (float)1.0f);
                    CompoundTag nbt = edge.getWireConnectionData().customData().getCommonData();
                    HashMap<UUID, Dropper> hashMap = new HashMap<UUID, Dropper>();
                    TreeSet<Float> pointsByLocation = new TreeSet<Float>();
                    for (Tag tag : nbt.m_128437_(NBT_DROPPERS, 10)) {
                        Dropper dropper = Dropper.fromNbt((CompoundTag)tag);
                        hashMap.put(dropper.id(), dropper);
                        pointsByLocation.add(Float.valueOf(collision.length(WIRE_LOWER_TENSION) * dropper.pos()));
                    }
                    if (edge.isOccupied(pos, WIRE_LOWER_TENSION, 0.03125f) || edge.isOccupied(pos, WIRE_UPPER_TENSION, 0.03125f)) {
                        player.m_5661_((Component)TextUtils.translate((String)KEY_INVALID_DROPPER_LOCATION).m_130940_(ChatFormatting.RED), true);
                        return InteractionResult.FAIL;
                    }
                    Float ceil = pointsByLocation.ceiling(Float.valueOf(pos));
                    Float floor = pointsByLocation.floor(Float.valueOf(pos));
                    if (ceil != null && Math.abs(ceil.floatValue() - pos) < 0.25f || floor != null && Math.abs(pos - floor.floatValue()) < 0.25f) {
                        player.m_5661_((Component)TextUtils.translate((String)KEY_DROPPER_EXISTS).m_130940_(ChatFormatting.RED), true);
                        return InteractionResult.FAIL;
                    }
                    while (hashMap.containsKey(dropperId = UUID.randomUUID())) {
                    }
                    hashMap.put(dropperId, new Dropper(dropperId, posPercentage));
                    ListTag li = new ListTag();
                    for (Dropper f : hashMap.values()) {
                        li.add((Object)f.toNbt());
                    }
                    nbt.m_128365_(NBT_DROPPERS, (Tag)li);
                    network.setAndUpdateEdge(edge, true);
                    network.m_77762_();
                }
            } else if (player.m_21120_(hand).m_204117_(ModItems.TAG_CANTILEVERS) && (hitResult.getWireId().name().startsWith(WIRE_DROPPER_L) || hitResult.getWireId().name().startsWith(WIRE_DROPPER_U))) {
                UUID dropperId;
                ItemStack stack = player.m_21120_(hand);
                Optional<NewWireCollision> collisionOpt = network.getCollisionById(edge.getId());
                if (!collisionOpt.isPresent()) {
                    return InteractionResult.FAIL;
                }
                NewWireCollision collision = collisionOpt.get();
                try {
                    dropperId = UUID.fromString(hitResult.getWireId().name().replace(WIRE_DROPPER_L, "").replace(WIRE_DROPPER_U, ""));
                }
                catch (Exception exception) {
                    return InteractionResult.FAIL;
                }
                for (WireDecorationData decoration : edge.getDecorations()) {
                    RegistrationArmWireDecoration deco2;
                    IWireDecoration<?> floor = decoration.getDecoration();
                    if (!(floor instanceof RegistrationArmWireDecoration) || !(deco2 = (RegistrationArmWireDecoration)floor).getDropperId().equals(dropperId)) continue;
                    player.m_5661_((Component)TextUtils.translate((String)KEY_DROPPER_HAS_REGISTRATION_ARM).m_130940_(ChatFormatting.RED), true);
                    return InteractionResult.FAIL;
                }
                boolean bl = CantileverBlockItem.getCantileverType(stack) == AbstractCantileverBlock.ECantileverRegistrationArmType.CENTER;
                float pos = collision.worldPosToWirePos(WIRE_LOWER_TENSION, collision.getWirePointsOf(WIRE_DROPPER_L + String.valueOf(dropperId)).vertices()[0]);
                boolean front = CatenaryHeadspanWireType.isFront(network.getNode(edge.getNodeAId()).getPos(), network.getNode(edge.getNodeBId()).getPos(), player.m_20252_(0.0f).m_252839_()) ^ CantileverBlockItem.getCantileverType(stack) == AbstractCantileverBlock.ECantileverRegistrationArmType.OUTER;
                RegistrationArmBlock.State state = bl ? RegistrationArmBlock.State.NORMAL_CENTERED : RegistrationArmBlock.State.NORMAL;
                float offset = front ? 1.0f : 0.0f;
                RegistrationArmWireDecoration element = new RegistrationArmWireDecoration(stack.m_255036_(1), front, state, dropperId);
                if (edge.canPlaceDecoration(pos - element.getRadius(element) + (offset += (bl ? -0.03125f : 0.21875f) * (float)(front ? 1 : -1)), WIRE_LOWER_TENSION, element)) {
                    edge.addDecoration(pos - element.getRadius(element) + offset, WIRE_LOWER_TENSION, element);
                    if (player == null || !player.m_7500_() && !player.m_5833_()) {
                        stack.m_41774_(1);
                    }
                } else if (!state.isAbove() && edge.addDecoration(pos - (element = new RegistrationArmWireDecoration(stack.m_255036_(1), front, bl ? RegistrationArmBlock.State.ABOVE_CENTERED : RegistrationArmBlock.State.ABOVE, dropperId)).getRadius(element) + offset, WIRE_LOWER_TENSION, element) && (player == null || !player.m_7500_() && !player.m_5833_())) {
                    stack.m_41774_(1);
                }
            } else if (player.m_21120_(hand).m_204117_(ModItems.TAG_INSULATORS)) {
                boolean isLarge;
                ItemStack stack = player.m_21120_(hand);
                Optional<NewWireCollision> collisionOpt = network.getCollisionById(edge.getId());
                if (!collisionOpt.isPresent()) {
                    return InteractionResult.FAIL;
                }
                NewWireCollision collision = collisionOpt.get();
                boolean bl = isLarge = edge.getWireConnectionData().customData().getCommonData().m_128457_("UpperWireHeight") > 1.5f;
                if (hitResult.getWireId().name().startsWith(WIRE_DROPPER_L) || hitResult.getWireId().name().startsWith(WIRE_DROPPER_U)) {
                    InsulatorWireDecoration element = new InsulatorWireDecoration(stack.m_255036_(1));
                    String string = hitResult.getWireId().name().replace(WIRE_DROPPER_L, "").replace(WIRE_DROPPER_U, "");
                    if (isLarge) {
                        String string2 = WIRE_DROPPER_L + string;
                        if (edge.addDecoration(collision.length(string2) - element.getRadius(element), string2, element) && (player == null || !player.m_7500_() && !player.m_5833_())) {
                            stack.m_41774_(1);
                        }
                    } else {
                        String string3 = WIRE_DROPPER_U + string;
                        if (edge.addDecoration(element.getRadius(element), string3, element) && (player == null || !player.m_7500_() && !player.m_5833_())) {
                            stack.m_41774_(1);
                        }
                    }
                } else if (hitResult.getWireId().name().equals(WIRE_LOWER_TENSION) || hitResult.getWireId().name().equals(WIRE_UPPER_TENSION)) {
                    float f = (float)ModMath.snapNearest(hitResult.getPosOnWire(), 0.5);
                    if (isLarge) {
                        InsulatorWireDecoration element = new InsulatorWireDecoration(stack.m_255036_(1));
                        if (edge.addDecoration(f, WIRE_LOWER_TENSION, element) && (player == null || !player.m_7500_() && !player.m_5833_())) {
                            stack.m_41774_(1);
                        }
                    } else {
                        if (stack.m_41613_() < 2) {
                            player.m_5661_((Component)TextUtils.translate((String)KEY_NOT_ENOUGH_INSULATORS, (Object[])new Object[]{2}).m_130940_(ChatFormatting.RED), true);
                            return InteractionResult.FAIL;
                        }
                        InsulatorWireDecoration element = new InsulatorWireDecoration(stack.m_255036_(1));
                        if (edge.canPlaceDecoration(f, WIRE_LOWER_TENSION, element) && edge.canPlaceDecoration(f, WIRE_UPPER_TENSION, element)) {
                            edge.addDecoration(f, WIRE_LOWER_TENSION, element);
                            edge.addDecoration(f, WIRE_UPPER_TENSION, element);
                            if (player == null || !player.m_7500_() && !player.m_5833_()) {
                                stack.m_41774_(2);
                            }
                        } else {
                            player.m_5661_((Component)TextUtils.translate((String)KEY_ONE_INVALID_DECORATION_POSITION, (Object[])new Object[]{2}).m_130940_(ChatFormatting.RED), true);
                            return InteractionResult.FAIL;
                        }
                    }
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public static boolean isFront(Vector3f A, Vector3f B, Vector3f D) {
        float abx = B.x - A.x;
        float dz = D.z;
        float abz = B.z - A.z;
        float dx = D.x;
        float cross = abx * dz - abz * dx;
        return cross > 0.0f;
    }

    public static Pair<Boolean, WireId> canConnectCatenary(WireEdge edge, WireId id) {
        if (id.type() != ModWireRegistry.CATENARY_HEADSPAN || !id.name().startsWith(WIRE_DROPPER_L) && !id.name().startsWith(WIRE_DROPPER_U)) {
            return Pair.of((Object)false, (Object)id);
        }
        return CatenaryHeadspanWireType.toDropperId(id.name()).map(dropperId -> {
            for (WireDecorationData decoration : edge.getDecorations()) {
                RegistrationArmWireDecoration deco;
                IWireDecoration<?> patt0$temp = decoration.getDecoration();
                if (!(patt0$temp instanceof RegistrationArmWireDecoration) || !(deco = (RegistrationArmWireDecoration)patt0$temp).getDropperId().equals(dropperId)) continue;
                return Pair.of((Object)true, (Object)new WireId(id.id(), WIRE_DROPPER_L + dropperId.toString(), id.type()));
            }
            return Pair.of((Object)false, (Object)id);
        }).orElse(Pair.of((Object)false, (Object)id));
    }

    public static Optional<UUID> toDropperId(String wireName) {
        try {
            return Optional.of(UUID.fromString(wireName.replace(WIRE_DROPPER_L, "").replace(WIRE_DROPPER_U, "")));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static Optional<RegistrationArmWireDecoration> getRegistrationArmForDropper(WireEdge edge, UUID dropperId) {
        for (WireDecorationData decoration : edge.getDecorations()) {
            RegistrationArmWireDecoration deco;
            IWireDecoration<?> iWireDecoration = decoration.getDecoration();
            if (!(iWireDecoration instanceof RegistrationArmWireDecoration) || !(deco = (RegistrationArmWireDecoration)iWireDecoration).getDropperId().equals(dropperId)) continue;
            return Optional.of(deco);
        }
        return Optional.empty();
    }

    public record Dropper(UUID id, float pos) implements Comparable<Dropper>
    {
        private static final String NBT_ID = "Id";
        private static final String NBT_POS = "Pos";

        public CompoundTag toNbt() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128362_(NBT_ID, this.id);
            nbt.m_128350_(NBT_POS, this.pos);
            return nbt;
        }

        public static Dropper fromNbt(CompoundTag nbt) {
            return new Dropper(nbt.m_128342_(NBT_ID), nbt.m_128457_(NBT_POS));
        }

        @Override
        public int compareTo(Dropper o) {
            return Float.compare(this.pos(), o.pos());
        }
    }
}

