/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.item;

import de.mrjulsen.mcdragonlib.data.Pair;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.paw.block.CantileverBlock;
import de.mrjulsen.paw.block.abstractions.ICatenaryWireConnector;
import de.mrjulsen.paw.blockentity.CantileverBlockEntity;
import de.mrjulsen.paw.client.gui.ModGuiIcons;
import de.mrjulsen.paw.data.WireHitResult;
import de.mrjulsen.paw.item.CatenaryHeadspanWireType;
import de.mrjulsen.paw.registry.ModWireRegistry;
import de.mrjulsen.paw.util.collision.LineShape;
import de.mrjulsen.paw.util.collision.RaycastHitResult;
import de.mrjulsen.paw.util.collision.RaycastUtils;
import de.mrjulsen.wires.IWireType;
import de.mrjulsen.wires.block.WireConnectorBlockEntity;
import de.mrjulsen.wires.graph.WireGraphManager;
import de.mrjulsen.wires.graph.data.node.BlockConnectorNodeData;
import de.mrjulsen.wires.graph.data.node.CatenaryHeadspanConnectionNodeData;
import de.mrjulsen.wires.graph.data.node.NodeData;
import de.mrjulsen.wires.graph.registry.DLStaticRegistryObject;
import de.mrjulsen.wires.item.IPawWireItemBase;
import de.mrjulsen.wires.network.WireId;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CatenaryWireItem
implements IPawWireItemBase {
    public static final String NBT_CANTILEVER_INDEX = "CantileverIndex";
    private final Component txtNoRegistrationArm = TextUtils.translate((String)"item.pantographsandwires.catenary_headspan.dropper_missing_registration_arm").m_130940_(ChatFormatting.RED);

    @Override
    public IWireType getWireType(ItemStack stack) {
        return ModWireRegistry.CATENARY_WIRE;
    }

    @Override
    public DLStaticRegistryObject<IPawWireItemBase> getRegistryType() {
        return ModWireRegistry.CATENARY_WIRE_ITEM_SUBTYPE;
    }

    @Override
    public String getTranslationKey() {
        return "wire.pantographsandwires.catenary_wire";
    }

    @Override
    public ModGuiIcons getIcon() {
        return ModGuiIcons.CATENARY_WIRE;
    }

    @Override
    public InteractionResult useWireOn(UseOnContext context) {
        InteractionResult result;
        if (!context.m_43725_().f_46443_ && (result = this.useWire(context.m_43725_(), context.m_43723_(), context.m_43724_()).m_19089_()) == InteractionResult.FAIL) {
            return IPawWireItemBase.super.useWireOn(context);
        }
        return InteractionResult.CONSUME;
    }

    @Override
    public InteractionResultHolder<ItemStack> useWire(Level level, Player player, InteractionHand usedHand) {
        if (level.f_46443_) {
            return InteractionResultHolder.m_19096_((Object)player.m_21120_(usedHand));
        }
        Optional<RaycastHitResult> result = RaycastUtils.rayTrace(player.m_146892_().m_252839_(), player.m_146892_().m_252839_().add((Vector3fc)player.m_20154_().m_252839_().normalize().mul(5.0f)), level, 6.5f, 0.0625f, (lvl, pos, rayOrigin, rayDirection) -> {
            BlockEntity patt0$temp;
            if (!(lvl.m_8055_(pos).m_60734_() instanceof CantileverBlock) || !((patt0$temp = lvl.m_7702_(pos)) instanceof CantileverBlockEntity)) {
                return Optional.empty();
            }
            CantileverBlockEntity be = (CantileverBlockEntity)patt0$temp;
            for (int i = 0; i < be.getCantileversCount(); ++i) {
                LineShape[] shapes;
                int k = i;
                CantileverBlockEntity.CantileverShapeData shapeData = be.getCantileverInteractionShape(k);
                for (LineShape shape : shapes = new LineShape[]{new LineShape(shapeData.stayTubeRoot(), shapeData.front(), 0.125f), new LineShape(shapeData.bracketTubeRoot(), shapeData.front(), 0.125f)}) {
                    Optional<Vector3f> oHit = shape.intersects(rayOrigin, rayDirection);
                    if (!oHit.isPresent()) continue;
                    Vector3f hit = oHit.get();
                    return Optional.of(new RaycastHitResult(new Vec3(hit), pos, new Vector3f((Vector3fc)hit).sub((Vector3fc)rayOrigin).length(), k));
                }
            }
            return Optional.empty();
        });
        result.ifPresent(x -> this.placeWire(level, player, usedHand, (HitResult)x, (metaNbt, pointMeta) -> pointMeta.m_128405_(NBT_CANTILEVER_INDEX, ((Integer)x.getHitData()).intValue())));
        return result.isPresent() ? InteractionResultHolder.m_19090_((Object)player.m_21120_(usedHand)) : InteractionResultHolder.m_19100_((Object)player.m_21120_(usedHand));
    }

    @Override
    public InteractionResult interactWithWire(Level level, Player player, InteractionHand hand, WireHitResult hit) {
        return this.placeWire(level, player, hand, hit, (a, b) -> {});
    }

    @Override
    public NodeData createNodeData(Level level, Player player, InteractionHand hand, HitResult hit) {
        if (hit instanceof WireHitResult) {
            WireHitResult h = (WireHitResult)hit;
            Pair<Boolean, WireId> result = CatenaryHeadspanWireType.canConnectCatenary(WireGraphManager.get(level, h.getGraphId()).getEdge(h.getWireId().id()), h.getWireId());
            if (((Boolean)result.getFirst()).booleanValue()) {
                return new CatenaryHeadspanConnectionNodeData((WireId)result.getSecond());
            }
            player.m_5661_(this.txtNoRegistrationArm, true);
            return null;
        }
        BlockPos pos = null;
        if (hit instanceof BlockHitResult) {
            BlockHitResult h = (BlockHitResult)hit;
            pos = h.m_82425_();
        } else if (hit instanceof RaycastHitResult) {
            RaycastHitResult h = (RaycastHitResult)hit;
            pos = h.getBlockPos();
        }
        if (pos != null && level.m_7702_(pos) instanceof WireConnectorBlockEntity && level.m_8055_(pos).m_60734_() instanceof ICatenaryWireConnector) {
            return new BlockConnectorNodeData(pos);
        }
        return null;
    }
}

