/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.item;

import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.paw.config.ModServerConfig;
import de.mrjulsen.paw.data.WireHitResult;
import de.mrjulsen.paw.item.PAWWireType;
import de.mrjulsen.paw.registry.InsulatorWireDecoration;
import de.mrjulsen.paw.registry.ModItems;
import de.mrjulsen.wires.SegmentControl;
import de.mrjulsen.wires.Wire;
import de.mrjulsen.wires.WireBatch;
import de.mrjulsen.wires.WireBuilder;
import de.mrjulsen.wires.WireCreationContext;
import de.mrjulsen.wires.graph.WireEdge;
import de.mrjulsen.wires.graph.WireGraph;
import de.mrjulsen.wires.graph.WireGraphManager;
import de.mrjulsen.wires.graph.WireNode;
import de.mrjulsen.wires.graph.data.WireConnectionData;
import de.mrjulsen.wires.graph.data.provider.CantileverConnectorDataProvider;
import de.mrjulsen.wires.render.WireRenderData;
import de.mrjulsen.wires.render.WireRenderPoint;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CatenaryWireType
extends PAWWireType {
    private static final String KEY_NOT_ENOUGH_INSULATORS = "item.pantographsandwires.wire.not_enough_insulators";
    private static final String KEY_ONE_INVALID_DECORATION_POSITION = "item.pantographsandwires.wire.one_invalid_decoration_position";
    public static final String NBT_SUPER_TIGHTENED = "SuperTightened";
    public static final String WIRE_TENSION = "tension";
    public static final String WIRE_CONTACT = "contact";
    public static final String WIRE_DROPPER = "dropper";
    private static final float HANG_FAC = 0.025f;
    private static final float THICKNESS = 0.046875f;

    public CatenaryWireType(ResourceLocation location) {
        super(location);
    }

    @Override
    public int getMaxLength() {
        return (Integer)ModServerConfig.CATENARY_WIRE_MAX_LENGTH.get();
    }

    @Override
    public int getWireLength(int connectionLength) {
        return connectionLength * 2;
    }

    @Override
    public WireBatch buildWire(WireCreationContext context, BlockAndTintGetter level, WireConnectionData customData, WireEdge edge, WireNode nodeA, WireNode nodeB) {
        CantileverConnectorDataProvider dataA = customData.connectorA().getAsTypeIfMatching(CantileverConnectorDataProvider.class).orElse(null);
        CantileverConnectorDataProvider dataB = customData.connectorB().getAsTypeIfMatching(CantileverConnectorDataProvider.class).orElse(null);
        if (dataA == null || dataB == null) {
            return WireBatch.of(new Wire[0]);
        }
        Vector3f start = nodeA.getPos();
        Vector3f end = nodeB.getPos();
        Vector3f contactWireAttachPointA = dataA.getAttachOffset();
        Vector3f contactWireAttachPointB = dataB.getAttachOffset();
        Vector3f tensionWireAttachPointA = dataA.getTensionWireAttachOffset();
        Vector3f tensionWireAttachPointB = dataB.getTensionWireAttachOffset();
        float maxHang = Math.min(tensionWireAttachPointA.y() - contactWireAttachPointA.y(), tensionWireAttachPointB.y() - contactWireAttachPointB.y());
        float length = Math.abs(new Vector3f((Vector3fc)end).sub((Vector3fc)start).length());
        float hang = Math.min(customData.customData().getCommonData().m_128471_(NBT_SUPER_TIGHTENED) ? 0.5f : 0.025f * length, maxHang - 0.25f);
        Wire tensionWire = WireBuilder.createWire(WIRE_TENSION, context, new Vector3f((Vector3fc)start).add((Vector3fc)tensionWireAttachPointA), new Vector3f((Vector3fc)end).add((Vector3fc)tensionWireAttachPointB), WireBuilder.CableType.TENSION, 0.03515625f, hang, SegmentControl.create(SegmentControl.Config.fixed((int)(length / 5.0f)), SegmentControl.Config.fixed(2)));
        Wire contactWire = WireBuilder.createWire(WIRE_CONTACT, context, new Vector3f((Vector3fc)start).add((Vector3fc)contactWireAttachPointA), new Vector3f((Vector3fc)end).add((Vector3fc)contactWireAttachPointB), WireBuilder.CableType.TIGHT, 0.046875f, 0.0f, SegmentControl.create(SegmentControl.Config.fixed((int)(length / 5.0f)), SegmentControl.Config.fixed(2)));
        WireBatch batch = WireBatch.of(contactWire, tensionWire);
        if (context.renderingRequired() && tensionWire.getRenderData().isPresent() && contactWire.getRenderData().isPresent()) {
            WireRenderData tensionRenderData = tensionWire.renderData();
            WireRenderData contactRenderData = contactWire.renderData();
            int i = 2;
            int c = 0;
            while (i < tensionRenderData.count() - 1 && i < contactRenderData.count() - 1) {
                batch.addSubWire(WireBuilder.createWire(WIRE_DROPPER + c, WireCreationContext.RENDERING, contactRenderData.getPoint(i).vertex(WireRenderPoint.VertexCorner.CENTER), tensionRenderData.getPoint(i).vertex(WireRenderPoint.VertexCorner.CENTER), WireBuilder.CableType.TIGHT, 0.01875f, 0.0f, SegmentControl.single()));
                i += 2;
                ++c;
            }
        }
        return batch;
    }

    @Override
    public InteractionResult use(Level level, Player player, InteractionHand hand, WireHitResult hitResult) {
        if (!level.f_46443_) {
            WireGraph network = WireGraphManager.get(level, this.getGraphId(null));
            WireEdge a = network.getEdge(hitResult.getWireId().id());
            if (player.m_21120_(hand).m_150930_(Items.f_42574_)) {
                network.removeEdge(hitResult.getWireId().id(), hitResult.m_82450_().m_252839_(), Optional.of(player));
            } else if (player.m_21120_(hand).m_204117_(ModItems.TAG_INSULATORS) && player.m_21120_(hand).m_41720_() instanceof BlockItem) {
                ItemStack stack = player.m_21120_(hand);
                InsulatorWireDecoration element = new InsulatorWireDecoration(stack.m_255036_(1));
                if (stack.m_41613_() < 2) {
                    player.m_5661_((Component)TextUtils.translate((String)KEY_NOT_ENOUGH_INSULATORS, (Object[])new Object[]{2}).m_130940_(ChatFormatting.RED), true);
                    return InteractionResult.FAIL;
                }
                if (a.canPlaceDecoration(hitResult.getPosOnWire(), WIRE_TENSION, element) && a.canPlaceDecoration(hitResult.getPosOnWire(), WIRE_CONTACT, element)) {
                    a.addDecoration(hitResult.m_82450_().m_252839_(), WIRE_TENSION, element);
                    a.addDecoration(hitResult.m_82450_().m_252839_(), WIRE_CONTACT, element);
                    if (player == null || !player.m_7500_() && !player.m_5833_()) {
                        stack.m_41774_(2);
                    }
                } else {
                    player.m_5661_((Component)TextUtils.translate((String)KEY_ONE_INVALID_DECORATION_POSITION, (Object[])new Object[]{2}).m_130940_(ChatFormatting.RED), true);
                    return InteractionResult.FAIL;
                }
            }
        }
        return InteractionResult.SUCCESS;
    }
}

