/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.item;

import de.mrjulsen.paw.config.ModServerConfig;
import de.mrjulsen.paw.data.WireHitResult;
import de.mrjulsen.paw.item.PAWWireType;
import de.mrjulsen.paw.registry.InsulatorWireDecoration;
import de.mrjulsen.paw.registry.ModItems;
import de.mrjulsen.wires.SegmentControl;
import de.mrjulsen.wires.Wire;
import de.mrjulsen.wires.WireBatch;
import de.mrjulsen.wires.WireBuilder;
import de.mrjulsen.wires.WireCreationContext;
import de.mrjulsen.wires.graph.WireEdge;
import de.mrjulsen.wires.graph.WireGraph;
import de.mrjulsen.wires.graph.WireGraphManager;
import de.mrjulsen.wires.graph.WireNode;
import de.mrjulsen.wires.graph.data.WireConnectionData;
import de.mrjulsen.wires.graph.data.provider.BasicConnectorDataProvider;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class PowerWireType
extends PAWWireType {
    private static final float HANG_FAC = 0.025f;
    private static final float THICKNESS = 0.0625f;

    public PowerWireType(ResourceLocation location) {
        super(location);
    }

    @Override
    public int getMaxLength() {
        return (Integer)ModServerConfig.CATENARY_WIRE_MAX_LENGTH.get();
    }

    @Override
    public int getWireLength(int connectionLength) {
        return connectionLength;
    }

    @Override
    public WireBatch buildWire(WireCreationContext context, BlockAndTintGetter level, WireConnectionData customData, WireEdge edge, WireNode nodeA, WireNode nodeB) {
        BasicConnectorDataProvider dataA = customData.connectorA().getAsTypeIfMatching(BasicConnectorDataProvider.class).orElse(null);
        BasicConnectorDataProvider dataB = customData.connectorB().getAsTypeIfMatching(BasicConnectorDataProvider.class).orElse(null);
        if (dataA == null || dataB == null) {
            return WireBatch.of(new Wire[0]);
        }
        Vector3f a = new Vector3f((Vector3fc)nodeA.getPos()).add((Vector3fc)dataA.getAttachOffset());
        Vector3f b = new Vector3f((Vector3fc)nodeB.getPos()).add((Vector3fc)dataB.getAttachOffset());
        float length = a.distance((Vector3fc)b);
        Wire wire = WireBuilder.createWire("main", context, a, b, WireBuilder.CableType.HANGING, 0.0625f, 0.025f * length, SegmentControl.create(SegmentControl.Config.auto(), SegmentControl.Config.fixed(1)));
        WireBatch batch = WireBatch.of(wire);
        return batch;
    }

    @Override
    public InteractionResult use(Level level, Player player, InteractionHand hand, WireHitResult hitResult) {
        if (!level.f_46443_) {
            WireGraph network = WireGraphManager.get(level, this.getGraphId(null));
            WireEdge a = network.getEdge(hitResult.getWireId().id());
            if (player.m_21120_(hand).m_150930_(Items.f_42574_)) {
                network.removeEdge(hitResult.getWireId().id(), hitResult.m_82450_().m_252839_(), Optional.of(player));
            } else if (player.m_21120_(hand).m_204117_(ModItems.TAG_INSULATORS) && player.m_21120_(hand).m_41720_() instanceof BlockItem) {
                ItemStack stack = player.m_21120_(hand);
                InsulatorWireDecoration element = new InsulatorWireDecoration(stack.m_255036_(1));
                if (a.addDecoration(hitResult.m_82450_().m_252839_(), "main", element) && (player == null || !player.m_7500_() && !player.m_5833_())) {
                    stack.m_41774_(1);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }
}

