/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.item;

import de.mrjulsen.paw.client.gui.ModGuiIcons;
import de.mrjulsen.paw.registry.ModBlocks;
import de.mrjulsen.paw.registry.ModWireRegistry;
import de.mrjulsen.wires.IWireType;
import de.mrjulsen.wires.graph.data.node.MastNodeData;
import de.mrjulsen.wires.graph.data.node.NodeData;
import de.mrjulsen.wires.graph.registry.DLStaticRegistryObject;
import de.mrjulsen.wires.item.IPawWireItemBase;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SupportWireItem
implements IPawWireItemBase {
    @Override
    public IWireType getWireType(ItemStack stack) {
        return ModWireRegistry.SUPPORT_WIRE;
    }

    @Override
    public DLStaticRegistryObject<IPawWireItemBase> getRegistryType() {
        return ModWireRegistry.SUPPORT_WIRE_ITEM_SUBTYPE;
    }

    @Override
    public String getTranslationKey() {
        return "wire.pantographsandwires.support_wire";
    }

    @Override
    public ModGuiIcons getIcon() {
        return ModGuiIcons.DECORATION_WIRE;
    }

    @Override
    public NodeData createNodeData(Level level, Player player, InteractionHand hand, HitResult hit) {
        BlockHitResult blockHit;
        if (hit instanceof BlockHitResult && level.m_8055_((blockHit = (BlockHitResult)hit).m_82425_()).m_204343_().anyMatch(x -> x.equals(ModBlocks.TAG_SUPPORT_WIRE_CONNECTABLE))) {
            return new MastNodeData(blockHit.m_82425_());
        }
        return null;
    }

    public static Optional<BlockHitResult> clipFromSide(VoxelShape shape, BlockPos pos, Direction dir) {
        if (shape.m_83281_()) {
            return Optional.empty();
        }
        AABB bounds = shape.m_83215_();
        double minX = 0.5;
        double minY = 0.5;
        double minZ = 0.5;
        double maxX = 0.5;
        double maxY = 0.5;
        double maxZ = 0.5;
        switch (dir) {
            case DOWN: {
                minY = bounds.f_82292_;
                maxY = bounds.f_82289_;
                break;
            }
            case UP: {
                minY = bounds.f_82289_;
                maxY = bounds.f_82292_;
                break;
            }
            case NORTH: {
                minZ = bounds.f_82293_;
                maxZ = bounds.f_82290_;
                break;
            }
            case SOUTH: {
                minZ = bounds.f_82290_;
                maxZ = bounds.f_82293_;
                break;
            }
            case WEST: {
                minX = bounds.f_82291_;
                maxX = bounds.f_82288_;
                break;
            }
            case EAST: {
                minX = bounds.f_82288_;
                maxX = bounds.f_82291_;
            }
        }
        Vec3 block = new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        Vec3 start = new Vec3(maxX + (double)dir.m_122429_() * 0.001, maxY + (double)dir.m_122430_() * 0.001, maxZ + (double)dir.m_122431_() * 0.001).m_82549_(block);
        Vec3 end = new Vec3(minX - (double)dir.m_122429_() * 0.001, minY - (double)dir.m_122430_() * 0.001, minZ - (double)dir.m_122431_() * 0.001).m_82549_(block);
        return Optional.ofNullable(shape.m_83220_(start, end, pos));
    }
}

