/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.item;

import de.mrjulsen.paw.config.ModServerConfig;
import de.mrjulsen.paw.data.WireHitResult;
import de.mrjulsen.paw.item.PAWWireType;
import de.mrjulsen.wires.SegmentControl;
import de.mrjulsen.wires.Wire;
import de.mrjulsen.wires.WireBatch;
import de.mrjulsen.wires.WireBuilder;
import de.mrjulsen.wires.WireCreationContext;
import de.mrjulsen.wires.WirePoints;
import de.mrjulsen.wires.graph.WireEdge;
import de.mrjulsen.wires.graph.WireGraph;
import de.mrjulsen.wires.graph.WireGraphManager;
import de.mrjulsen.wires.graph.WireNode;
import de.mrjulsen.wires.graph.data.WireConnectionData;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class SupportWireType
extends PAWWireType {
    private static final float THICKNESS = 0.0625f;

    public SupportWireType(ResourceLocation location) {
        super(location);
    }

    @Override
    public int getMaxLength() {
        return (Integer)ModServerConfig.SUPPORT_WIRE_MAX_LENGTH.get();
    }

    @Override
    public int getWireLength(int connectionLength) {
        return connectionLength;
    }

    @Override
    public WireBatch buildWire(WireCreationContext context, BlockAndTintGetter level, WireConnectionData customData, WireEdge edge, WireNode nodeA, WireNode nodeB) {
        Vector3f a = new Vector3f((Vector3fc)nodeA.getPos());
        Vector3f b = new Vector3f((Vector3fc)nodeB.getPos());
        Vector3f direction = new Vector3f((Vector3fc)b).sub((Vector3fc)a);
        direction = new Vector3f(direction.x(), 0.0f, direction.z());
        Vector3f rightVec = new Vector3f(direction.z(), 0.0f, -direction.x()).normalize();
        direction.absolute().normalize();
        Vector3f offsetA = new Vector3f((Vector3fc)rightVec).mul(0.125f);
        Vector3f offsetB = new Vector3f((Vector3fc)rightVec).mul(-0.125f);
        Wire wire1 = WireBuilder.createWire("main1", context, new Vector3f((Vector3fc)a).add(offsetA.x(), 0.0f, offsetA.z()), new Vector3f((Vector3fc)b).add(offsetA.x(), 0.0f, offsetA.z()), WireBuilder.CableType.TIGHT, 0.0625f, 0.0f, SegmentControl.createAuto());
        Wire wire2 = WireBuilder.createWire("main2", context, new Vector3f((Vector3fc)a).add(offsetB.x(), 0.0f, offsetB.z()), new Vector3f((Vector3fc)b).add(offsetB.x(), 0.0f, offsetB.z()), WireBuilder.CableType.TIGHT, 0.0625f, 0.0f, SegmentControl.createAuto());
        WirePoints topRenderData1 = wire1.collisionData();
        WirePoints topRenderData2 = wire2.collisionData();
        Wire crossConnection1 = WireBuilder.createWire("connection1", WireCreationContext.RENDERING, topRenderData1.vertices()[0], topRenderData2.vertices()[0], WireBuilder.CableType.TIGHT, 0.0625f, 0.0f, SegmentControl.single());
        Wire crossConnection2 = WireBuilder.createWire("connection2", WireCreationContext.RENDERING, topRenderData1.vertices()[topRenderData1.vertices().length - 1], topRenderData2.vertices()[topRenderData2.vertices().length - 1], WireBuilder.CableType.TIGHT, 0.0625f, 0.0f, SegmentControl.single());
        WireBatch batch = WireBatch.of(wire1, wire2, crossConnection1, crossConnection2);
        return batch;
    }

    @Override
    public InteractionResult use(Level level, Player player, InteractionHand hand, WireHitResult hitResult) {
        if (!level.f_46443_) {
            WireGraph network = WireGraphManager.get(level, this.getGraphId(null));
            WireEdge a = network.getEdge(hitResult.getWireId().id());
            if (player.m_21120_(hand).m_150930_(Items.f_42574_)) {
                network.removeEdge(hitResult.getWireId().id(), hitResult.m_82450_().m_252839_(), Optional.of(player));
            }
        }
        return InteractionResult.SUCCESS;
    }
}

