/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.mixin;

import de.mrjulsen.paw.block.abstractions.IRotatableBlock;
import de.mrjulsen.paw.block.extended.BlockPlaceContextExtension;
import de.mrjulsen.paw.data.BlockModificationData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockItem.class})
public class BlockItemMixin {
    boolean canModifyPos;
    Direction direction;
    BlockPos newPos;

    private BlockItem self() {
        return (BlockItem)this;
    }

    @Inject(method={"place"}, at={@At(value="HEAD")}, cancellable=true)
    private void onPlace(BlockPlaceContext context, CallbackInfoReturnable<InteractionResult> cir) {
        BlockPlaceContextExtension contextExtension = (BlockPlaceContextExtension)context;
        Level level = context.m_43725_();
        BlockPos clickedBlockPos = context.m_8083_().m_121945_(context.m_43719_().m_122424_());
        BlockState clickedState = level.m_8055_(clickedBlockPos);
        Block thisBlock = this.self().m_40614_();
        contextExtension.setPlacedOnPos(clickedBlockPos);
        contextExtension.setPlacedOnState(clickedState);
        boolean bl = this.canModifyPos = context.m_43719_().m_122434_().m_122479_() && clickedState.m_60734_() instanceof IRotatableBlock;
        if (this.canModifyPos) {
            IRotatableBlock supportRot = (IRotatableBlock)clickedState.m_60734_();
            BlockModificationData value = supportRot.onPlaceOnRotatedBlock(context, clickedState, clickedBlockPos);
            if (thisBlock instanceof IRotatableBlock) {
                IRotatableBlock selfRot = (IRotatableBlock)thisBlock;
                value = selfRot.onPlaceOnOtherRotatedBlock(value, context, clickedState, clickedBlockPos);
            }
            if (value != null) {
                this.newPos = value.newPos();
                this.direction = value.newDirection();
                if (!level.m_8055_(this.newPos).m_60629_(context)) {
                    cir.setReturnValue((Object)InteractionResult.FAIL);
                }
            } else {
                this.canModifyPos = false;
            }
        }
    }

    @ModifyVariable(method={"place"}, at=@At(value="STORE"))
    private BlockPos modifyPlacementPos(BlockPos pos) {
        if (this.canModifyPos && this.direction != null) {
            pos = pos.m_121945_(this.direction.m_122428_());
        }
        return pos;
    }

    @Inject(method={"placeBlock"}, at={@At(value="HEAD")}, cancellable=true)
    private void onPlace(BlockPlaceContext context, BlockState state, CallbackInfoReturnable<Boolean> cir) {
        if (this.canModifyPos) {
            cir.setReturnValue((Object)context.m_43725_().m_7731_(this.newPos, state, 11));
        }
    }
}

