/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.mixin.datafixer;

import de.mrjulsen.mcdragonlib.data.Pair;
import de.mrjulsen.paw.PantographsAndWires;
import de.mrjulsen.paw.block.abstractions.AbstractCantileverBlock;
import de.mrjulsen.paw.block.property.ECantileverConnectionType;
import de.mrjulsen.paw.block.property.EInsulatorType;
import de.mrjulsen.paw.blockentity.CantileverBlockEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.storage.ChunkSerializer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ChunkSerializer.class})
public abstract class ChunkSerializerMixin {
    @Unique
    private static final String CANTILEVER_REGEX = "pantographsandwires:cantilever_(double_)?[3-7]_(green|brown)";
    @Unique
    private static final Pattern CANTILEVER_REGEX_PATTERN = Pattern.compile("pantographsandwires:cantilever_(double_)?[3-7]_(green|brown)");
    @Unique
    private static final Function<String, Matcher> CANTILEVER_REGEX_MATCHER = i -> CANTILEVER_REGEX_PATTERN.matcher((CharSequence)i);

    @Inject(method={"write"}, at={@At(value="INVOKE", target="Lnet/minecraft/nbt/CompoundTag;putInt(Ljava/lang/String;I)V", ordinal=0)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private static void paw$write(ServerLevel level, ChunkAccess chunk, CallbackInfoReturnable<CompoundTag> cir, ChunkPos pos, CompoundTag tag) {
        tag.m_128405_("pantographsandwires_datafixer_version", 2);
    }

    @Inject(method={"read"}, at={@At(value="HEAD")})
    private static void paw$read(ServerLevel level, PoiManager poiManager, ChunkPos chunkPos, CompoundTag tag, CallbackInfoReturnable<?> cir) {
        if (tag.m_128451_("pantographsandwires_datafixer_version") >= 2) {
            return;
        }
        try {
            HashMap<BlockPos, CompoundTag> foundBlocks = new HashMap<BlockPos, CompoundTag>();
            List<CompoundTag> sections = tag.m_128437_("sections", 10).stream().map(x -> (CompoundTag)x).toList();
            int chunkX = tag.m_128451_("xPos");
            int chunkZ = tag.m_128451_("zPos");
            for (CompoundTag section : sections) {
                long[] data;
                Object bst22;
                int sectionY = section.m_128451_("Y");
                CompoundTag compoundTag = section.m_128469_("block_states");
                ListTag blockStatesList = compoundTag.m_128437_("palette", 10);
                ArrayList<Pair> palette = new ArrayList<Pair>(blockStatesList.size());
                for (Object bst22 : blockStatesList) {
                    palette.add(new Pair((Object)((CompoundTag)bst22), (Object)CANTILEVER_REGEX_MATCHER.apply(((CompoundTag)bst22).m_128461_("Name")).matches()));
                }
                if (palette.isEmpty()) continue;
                boolean found = false;
                bst22 = palette.iterator();
                while (bst22.hasNext()) {
                    Pair state = (Pair)bst22.next();
                    if (!((Boolean)state.getSecond()).booleanValue()) continue;
                    found = true;
                    break;
                }
                if (!found || (data = compoundTag.m_128467_("data")) == null || data.length <= 0) continue;
                int bitsPerEntry = Math.max(4, (int)Math.ceil(Math.log(palette.size()) / Math.log(2.0)));
                int blocksPerLong = 64 / bitsPerEntry;
                int mask = (1 << bitsPerEntry) - 1;
                for (int y = 0; y < 16; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        for (int x2 = 0; x2 < 16; ++x2) {
                            Pair state;
                            long blockData;
                            int paletteIndex;
                            int index = y * 16 * 16 + z * 16 + x2;
                            int longIndex = index / blocksPerLong;
                            int bitIndex = index % blocksPerLong * bitsPerEntry;
                            if (longIndex >= data.length || (paletteIndex = (int)((blockData = data[longIndex]) >> bitIndex) & mask) >= palette.size() || !((Boolean)(state = (Pair)palette.get(paletteIndex)).getSecond()).booleanValue()) continue;
                            int globalX = chunkX * 16 + x2;
                            int globalY = sectionY * 16 + y;
                            int globalZ = chunkZ * 16 + z;
                            foundBlocks.put(new BlockPos(globalX, globalY, globalZ), (CompoundTag)state.getFirst());
                        }
                    }
                }
                ListTag bsl = new ListTag();
                for (int i = 0; i < palette.size(); ++i) {
                    Pair pair = (Pair)palette.get(i);
                    if (!((Boolean)pair.getSecond()).booleanValue()) {
                        bsl.add((Object)((Tag)pair.getFirst()));
                        continue;
                    }
                    CompoundTag state = ((CompoundTag)pair.getFirst()).m_6426_();
                    String name = state.m_128461_("Name");
                    String insulatorType = name.replaceAll("pantographsandwires:cantilever_(double_)?[3-7]_", "");
                    state.m_128359_("Name", "pantographsandwires:cantilever_" + insulatorType);
                    bsl.add((Object)state);
                }
                compoundTag.m_128365_("palette", (Tag)bsl);
            }
            if (foundBlocks.isEmpty()) {
                return;
            }
            List<CompoundTag> blockEntities = tag.m_128437_("block_entities", 10).stream().map(x -> (CompoundTag)x).toList();
            HashMap<BlockPos, CompoundTag> blockEntitiesByPos = new HashMap<BlockPos, CompoundTag>();
            for (CompoundTag compoundTag : blockEntities) {
                int x3 = compoundTag.m_128451_("x");
                int y = compoundTag.m_128451_("y");
                int z = compoundTag.m_128451_("z");
                if (x3 >= Integer.MAX_VALUE || y >= Integer.MAX_VALUE || z >= Integer.MAX_VALUE) continue;
                blockEntitiesByPos.put(new BlockPos(x3, y, z), compoundTag);
            }
            for (Map.Entry entry : foundBlocks.entrySet()) {
                try {
                    BlockPos pos = (BlockPos)entry.getKey();
                    CompoundTag state = (CompoundTag)entry.getValue();
                    String name = state.m_128461_("Name");
                    int rawWidth = Integer.parseInt(name.replaceAll("pantographsandwires:cantilever_(double_)?", "").replaceAll("_(brown|green)", ""));
                    float width = (float)rawWidth - 0.5f;
                    String rawInsulatorType = name.replaceAll("pantographsandwires:cantilever_(double_)?[0-9]_", "");
                    int insulatorType = EInsulatorType.getByName(rawInsulatorType).getId();
                    byte cantileverCount = (byte)(name.contains("double") ? 2 : 1);
                    int insulatorPlacement = AbstractCantileverBlock.ECantileverInsulatorsPlacement.getByName(((CompoundTag)state.m_128423_("Properties")).m_128461_("insulator_placement").replace("\"", "")).ordinal();
                    int registrationArmType = AbstractCantileverBlock.ECantileverRegistrationArmType.getByName(((CompoundTag)state.m_128423_("Properties")).m_128461_("registration_arm").replace("\"", "")).ordinal();
                    int postConnectionOffset = ECantileverConnectionType.getByName(((CompoundTag)state.m_128423_("Properties")).m_128461_("connection").replace("\"", "")).getIndex();
                    float height = 0.5f * (float)rawWidth - 0.125f;
                    float catenaryHeight = width < 5.0f ? 1.0f : 2.0f;
                    boolean showBracing = width >= 4.0f;
                    CompoundTag existing = (CompoundTag)blockEntitiesByPos.get(pos);
                    if (existing != null) {
                        existing.m_128350_("Width", width);
                        existing.m_128405_("InsulatorPlacement", insulatorPlacement);
                        existing.m_128350_("Height", height);
                        existing.m_128350_("CatenaryHeight", catenaryHeight);
                        existing.m_128405_("PostConnectionOffset", postConnectionOffset);
                        existing.m_128405_("InsulatorType", insulatorType);
                        existing.m_128344_("CantileversCount", cantileverCount);
                        if (cantileverCount > 1 && registrationArmType == AbstractCantileverBlock.ECantileverRegistrationArmType.CENTER.ordinal()) {
                            existing.m_128405_("RegistrationArmType", AbstractCantileverBlock.ECantileverRegistrationArmType.INNER.ordinal());
                            ListTag list = new ListTag();
                            list.add((Object)new CantileverBlockEntity.SubCantileverSetting(0, AbstractCantileverBlock.ECantileverRegistrationArmType.OUTER, showBracing).toNbt());
                            existing.m_128365_("SubCantileverSettings", (Tag)list);
                        } else {
                            existing.m_128405_("RegistrationArmType", registrationArmType);
                        }
                        blockEntitiesByPos.put(pos, existing);
                        continue;
                    }
                    CompoundTag newEntity = new CompoundTag();
                    newEntity.m_128405_("x", pos.m_123341_());
                    newEntity.m_128405_("y", pos.m_123342_());
                    newEntity.m_128405_("z", pos.m_123343_());
                    newEntity.m_128359_("id", "pantographsandwires:cantilever_block_entity");
                    newEntity.m_128350_("Width", width);
                    newEntity.m_128405_("InsulatorPlacement", insulatorPlacement);
                    newEntity.m_128350_("Height", height);
                    newEntity.m_128350_("CatenaryHeight", catenaryHeight);
                    newEntity.m_128405_("PostConnectionOffset", postConnectionOffset);
                    newEntity.m_128405_("InsulatorType", insulatorType);
                    newEntity.m_128344_("CantileversCount", cantileverCount);
                    if (cantileverCount > 1 && registrationArmType == AbstractCantileverBlock.ECantileverRegistrationArmType.CENTER.ordinal()) {
                        newEntity.m_128405_("RegistrationArmType", AbstractCantileverBlock.ECantileverRegistrationArmType.INNER.ordinal());
                        ListTag list = new ListTag();
                        list.add((Object)new CantileverBlockEntity.SubCantileverSetting(0, AbstractCantileverBlock.ECantileverRegistrationArmType.OUTER, showBracing).toNbt());
                        newEntity.m_128365_("SubCantileverSettings", (Tag)list);
                    } else {
                        newEntity.m_128405_("RegistrationArmType", registrationArmType);
                    }
                    blockEntitiesByPos.put(pos, newEntity);
                }
                catch (Exception e) {
                    PantographsAndWires.LOGGER.error("Unable to convert cantilever.", (Throwable)e);
                }
            }
            ListTag lst = new ListTag();
            for (CompoundTag c : blockEntitiesByPos.values()) {
                lst.add((Object)c);
            }
            tag.m_128365_("block_entities", (Tag)lst);
        }
        catch (Exception e) {
            PantographsAndWires.LOGGER.error("Error while running datafixer: ", (Throwable)e);
        }
    }
}

