/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.mixin.sodium;

import de.mrjulsen.paw.compat.sodium.MeshAppenderRenderer;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSection;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildBuffers;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildContext;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildOutput;
import me.jellysquid.mods.sodium.client.render.chunk.compile.tasks.ChunkBuilderMeshingTask;
import me.jellysquid.mods.sodium.client.util.task.CancellationToken;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import me.jellysquid.mods.sodium.client.world.cloned.ChunkRenderContext;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChunkBuilderMeshingTask.class})
public class ChunkBuilderMeshingTaskMixin {
    @Shadow
    private RenderSection render;
    @Shadow
    private ChunkRenderContext renderContext;
    private WorldSlice slice;

    @Shadow
    private ReportedException fillCrashInfo(CrashReport report, WorldSlice slice, BlockPos pos) {
        throw new AssertionError();
    }

    @ModifyVariable(method={"execute"}, at=@At(value="STORE"), remap=false)
    public WorldSlice getWorldSlice(WorldSlice slice) {
        this.slice = slice;
        return slice;
    }

    @Inject(method={"execute"}, at={@At(value="INVOKE", target="Lit/unimi/dsi/fastutil/objects/Reference2ReferenceOpenHashMap;<init>()V", shift=At.Shift.BEFORE)}, remap=false)
    public void append(ChunkBuildContext buildContext, CancellationToken cancellationToken, CallbackInfoReturnable<ChunkBuildOutput> cir) {
        int minX = this.render.getOriginX();
        int minY = this.render.getOriginY();
        int minZ = this.render.getOriginZ();
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos(minX, minY, minZ);
        ChunkBuildBuffers buffers = buildContext.buffers;
        try {
            MeshAppenderRenderer.renderMeshAppenders((BlockAndTintGetter)this.slice, this.renderContext.getOrigin(), buffers);
        }
        catch (ReportedException var24) {
            throw this.fillCrashInfo(var24.m_134761_(), this.slice, (BlockPos)blockPos);
        }
        catch (Exception var25) {
            throw this.fillCrashInfo(CrashReport.m_127521_((Throwable)var25, (String)"Encountered exception while building chunk meshes"), this.slice, (BlockPos)blockPos);
        }
        finally {
            this.slice = null;
        }
    }
}

