/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.registry;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import de.mrjulsen.mcdragonlib.client.model.ModelContext;
import de.mrjulsen.mcdragonlib.client.model.mesh.BasicMesh;
import de.mrjulsen.mcdragonlib.client.model.mesh.DLModel;
import de.mrjulsen.mcdragonlib.client.model.mesh.Mesh;
import de.mrjulsen.paw.config.ModServerConfig;
import de.mrjulsen.paw.registry.ModWireRegistry;
import de.mrjulsen.wires.decoration.IWireDecoration;
import de.mrjulsen.wires.decoration.WireDecorationRenderer;
import de.mrjulsen.wires.graph.registry.DLRegistryObject;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Vector3f;

public class InsulatorWireDecoration
implements IWireDecoration<InsulatorWireDecoration> {
    public static final float RADIUS = 0.35f;
    private final Renderer renderer = new Renderer(this);
    private ItemStack stack;

    public InsulatorWireDecoration() {
    }

    public InsulatorWireDecoration(ItemStack stack) {
        this();
        this.stack = stack;
    }

    @Override
    public DLRegistryObject<IWireDecoration<?>> getRegistryType() {
        return ModWireRegistry.INSULATOR_DECORATION;
    }

    @Override
    public WireDecorationRenderer<InsulatorWireDecoration> getRenderer() {
        return this.renderer;
    }

    @Override
    public void onBreak(Level level, Vector3f position, Optional<Player> player) {
        if (!player.isPresent() || !player.get().m_7500_() && !player.get().m_5833_() || ((Boolean)ModServerConfig.DROP_WIRE_ITEMS_IN_CREATIVE.get()).booleanValue()) {
            ItemEntity itementity = new ItemEntity(level, (double)position.x(), (double)position.y(), (double)position.z(), this.stack);
            itementity.m_32060_();
            level.m_7967_((Entity)itementity);
        }
    }

    public ItemStack getItem() {
        return this.stack;
    }

    public CompoundTag serializeNbt() {
        CompoundTag nbt = new CompoundTag();
        this.stack.m_41739_(nbt);
        return nbt;
    }

    public void deserializeNbt(CompoundTag nbt) {
        this.stack = ItemStack.m_41712_((CompoundTag)nbt);
    }

    @Override
    public float getRadius(IWireDecoration<?> element) {
        return 0.35f;
    }

    private static class Renderer
    extends WireDecorationRenderer<InsulatorWireDecoration> {
        private final Supplier<DLModel> model = Suppliers.memoize(() -> new DLModel(){

            protected Mesh getMesh(DLModel.ModelType type, BakedModel originalModel, BlockState state, RandomSource random, ModelContext context) {
                BasicMesh mesh = BasicMesh.fromBlock((BlockState)((BlockItem)((InsulatorWireDecoration)((Renderer)this).decoration).stack.m_41720_()).m_40614_().m_49966_(), (RandomSource)RandomSource.m_216327_());
                mesh.getFaces().forEach(x -> x.setRenderType(RenderType.m_110463_()));
                mesh.centerTo(new Vector3f(0.0f));
                mesh.rotate(Axis.f_252529_.m_252977_(90.0f), new Vector3f(0.0f));
                return mesh;
            }
        });

        public Renderer(InsulatorWireDecoration decoratin) {
            super(decoratin);
        }

        @Override
        public void render(PoseStack poseStack, VertexConsumer consumer, Vector3f pos, Vector3f directio, int light) {
            Item item = ((InsulatorWireDecoration)this.decoration).stack.m_41720_();
            if (!(item instanceof BlockItem)) {
                return;
            }
            BlockItem blockitem = (BlockItem)item;
            this.model.get().render(poseStack.m_85850_(), consumer, DLModel.ModelType.BLOCK, blockitem.m_40614_().m_49966_(), ModelContext.EMPTY, 1.0f, 1.0f, 1.0f, light, OverlayTexture.f_118083_);
        }
    }
}

