/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.registry;

import com.google.common.collect.ImmutableMap;
import com.simibubi.create.api.behaviour.interaction.MovingInteractionBehaviour;
import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.SharedProperties;
import com.simibubi.create.foundation.data.TagGen;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import de.mrjulsen.mcdragonlib.client.model.CustomBlockModelRegistry;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.paw.PantographsAndWires;
import de.mrjulsen.paw.block.CantileverBlock;
import de.mrjulsen.paw.block.CantileverBracketBlock;
import de.mrjulsen.paw.block.CantileverBracketPostConnectionBlock;
import de.mrjulsen.paw.block.CantileverBracketVerticalBlock;
import de.mrjulsen.paw.block.ConcretePillarBlock;
import de.mrjulsen.paw.block.FlatLatticeMastBlock;
import de.mrjulsen.paw.block.HBeamMastBlock;
import de.mrjulsen.paw.block.InsulatorBlock;
import de.mrjulsen.paw.block.LatticeMastBlock;
import de.mrjulsen.paw.block.PantographBlock;
import de.mrjulsen.paw.block.PowerLineBracketBlock;
import de.mrjulsen.paw.block.RegistrationArmBlock;
import de.mrjulsen.paw.block.TensioningDeviceBlock;
import de.mrjulsen.paw.block.UInsulatorBlock;
import de.mrjulsen.paw.block.VInsulatorBlock;
import de.mrjulsen.paw.block.abstractions.AbstractCantileverBlock;
import de.mrjulsen.paw.block.abstractions.IWeatheringBlock;
import de.mrjulsen.paw.block.model.OxidizedBlockModel;
import de.mrjulsen.paw.block.property.EInsulatorType;
import de.mrjulsen.paw.blockentity.PantographInteractionBehaviour;
import de.mrjulsen.paw.blockentity.PantographMovementBehaviour;
import de.mrjulsen.paw.client.model.RotatedBlockModel;
import de.mrjulsen.paw.item.CantileverBlockItem;
import de.mrjulsen.paw.item.FuelBlockItem;
import de.mrjulsen.paw.registry.ModCreativeModeTab;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class ModBlocks {
    private static final int CANTILEVER_CONNECTION_PIXELS = 16;
    private static final List<TagKey<Block>> cantileverConnectableTags = new ArrayList<TagKey<Block>>();
    public static final TagKey<Block> TAG_CANTILEVER_CONNECTABLE;
    public static final TagKey<Block> TAG_CANTILEVER_MAST_BRACKET_FITTING;
    public static final TagKey<Block> TAG_CANTILEVER_MAST_HINGE;
    public static final TagKey<Block> TAG_TENSIONING_DEVICE_CONNECTABLE;
    public static final TagKey<Block> TAG_CANTILEVER_CONNECTABLE_16PX;
    public static final TagKey<Block> TAG_CANTILEVER_CONNECTABLE_12PX;
    public static final TagKey<Block> TAG_CANTILEVER_CONNECTABLE_8PX;
    public static final TagKey<Block> TAG_CANTILEVER_CONNECTABLE_5PX;
    public static final TagKey<Block> TAG_CANTILEVER_CONNECTABLE_4PX;
    public static final TagKey<Block> TAG_CATENARY_HEADSPAN_CONNECTABLE;
    public static final TagKey<Block> TAG_SUPPORT_WIRE_CONNECTABLE;
    public static final BlockEntry<PantographBlock> PANTOGRAPH;
    public static final ImmutableMap<IWeatheringBlock.WeatherState, BlockEntry<LatticeMastBlock>> LATTICE_MAST;
    public static final ImmutableMap<IWeatheringBlock.WeatherState, BlockEntry<FlatLatticeMastBlock>> FLAT_LATTICE_MAST;
    public static final ImmutableMap<IWeatheringBlock.WeatherState, BlockEntry<FlatLatticeMastBlock>> FLAT_LATTICE_MAST_DIAGONAL;
    public static final ImmutableMap<IWeatheringBlock.WeatherState, BlockEntry<HBeamMastBlock>> H_BEAM_MAST;
    public static final ImmutableMap<IWeatheringBlock.WeatherState, BlockEntry<ConcretePillarBlock>> CONCRETE_POST;
    public static final ImmutableMap<IWeatheringBlock.WeatherState, BlockEntry<ConcretePillarBlock>> CONCRETE_PILLAR;
    public static final BlockEntry<RegistrationArmBlock> REGISTRATION_ARM;
    public static final BlockEntry<TensioningDeviceBlock> TENSIONING_DEVICE;
    public static final ImmutableMap<IWeatheringBlock.WeatherState, BlockEntry<CantileverBracketBlock>> CANTILEVER_BRACKET;
    public static final ImmutableMap<IWeatheringBlock.WeatherState, BlockEntry<CantileverBracketVerticalBlock>> CANTILEVER_BRACKET_VERTICAL;
    public static final ImmutableMap<IWeatheringBlock.WeatherState, BlockEntry<CantileverBracketPostConnectionBlock>> CANTILEVER_BRACKET_AT_POST;
    public static final ImmutableMap<IWeatheringBlock.WeatherState, BlockEntry<PowerLineBracketBlock>> POWER_LINE_BRACKET;
    public static final BlockEntry<VInsulatorBlock> V_INSULATOR_BROWN;
    public static final BlockEntry<VInsulatorBlock> V_INSULATOR_GREEN;
    public static final BlockEntry<InsulatorBlock> INSULATOR_BROWN;
    public static final BlockEntry<InsulatorBlock> INSULATOR_GREEN;
    public static final BlockEntry<UInsulatorBlock> U_INSULATOR_GREEN;
    public static final BlockEntry<UInsulatorBlock> U_INSULATOR_BROWN;
    public static final BlockEntry<Block> GRAPHITE_BLOCK;
    public static final BlockEntry<Block> COAL_COKE_BLOCK;
    public static final Map<EInsulatorType, BlockEntry<? extends AbstractCantileverBlock>> CANTILEVERS;
    public static final Collection<NonNullSupplier<? extends Block>> CANTILEVER_BLOCK_ENTITY_BLOCKS;
    public static final Map<EInsulatorType, ItemEntry<CantileverBlockItem<CantileverBlock>>> CANTILEVER_ITEMS;

    private static TagKey<Block> createTag(String name) {
        return TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("pantographsandwires", name));
    }

    public static TagKey<Block> getCantileverConnectableTagFor(int pixels) {
        return cantileverConnectableTags.get(pixels - 1);
    }

    public static int getFirstCantileverConnectionTagForState(BlockState state) {
        for (int i = 0; i < 16; ++i) {
            TagKey<Block> tag = cantileverConnectableTags.get(i);
            if (!state.m_204343_().anyMatch(y -> y.equals((Object)tag))) continue;
            return i + 1;
        }
        return 16;
    }

    public static void init() {
        ModBlocks.registerCantilevers();
    }

    public static BlockEntry<? extends AbstractCantileverBlock> getCantilever(EInsulatorType type) {
        return CANTILEVERS.get((Object)type);
    }

    public static Collection<BlockEntry<? extends AbstractCantileverBlock>> getCantilevers() {
        return CANTILEVERS.values();
    }

    private static void registerCantilevers() {
        EInsulatorType[] eInsulatorTypeArray = EInsulatorType.values();
        int n = eInsulatorTypeArray.length;
        for (int i = 0; i < n; ++i) {
            EInsulatorType type;
            EInsulatorType t = type = eInsulatorTypeArray[i];
            BlockEntry cantileverBlock = ModBlocks.registerBlockEntityBlock(CANTILEVER_BLOCK_ENTITY_BLOCKS, ((BlockBuilder)PantographsAndWires.REGISTRATE.block(String.format("cantilever_%s", type.m_7912_()), p -> new CantileverBlock((BlockBehaviour.Properties)p, t)).initialProperties(SharedProperties::softMetal).transform(TagGen.pickaxeOnly())).addLayer(() -> () -> RenderType.m_110466_()).register());
            CANTILEVERS.put(t, (BlockEntry<? extends AbstractCantileverBlock>)cantileverBlock);
            DLUtils.doIfNotNull((Object)cantileverBlock, x -> {
                BlockEntry y = x;
                ItemEntry item = PantographsAndWires.REGISTRATE.item(String.format("cantilever_%s", type.m_7912_()), p -> new CantileverBlockItem<CantileverBlock>((CantileverBlock)y.get(), type, (Item.Properties)p)).tab(ModCreativeModeTab.MAIN_TAB.getKey()).register();
                CANTILEVER_ITEMS.put(type, (ItemEntry<CantileverBlockItem<CantileverBlock>>)item);
            });
        }
    }

    private static <T extends Block> ImmutableMap<IWeatheringBlock.WeatherState, BlockEntry<T>> registerOxidizingBlock(String name, IOxidizingBlockFactory<T> factory, Set<ResourceLocation> oxidizingTextures, boolean addGalvanizedState, UnaryOperator<BlockBuilder<T, CreateRegistrate>> builder) {
        AtomicReference<Object> previous = new AtomicReference<Object>(null);
        HashMap<IWeatheringBlock.WeatherState, BlockEntry> variants = new HashMap<IWeatheringBlock.WeatherState, BlockEntry>(IWeatheringBlock.WeatherState.values().length);
        for (int i = IWeatheringBlock.WeatherState.oxidationStates().length - 1; i >= 0; --i) {
            IWeatheringBlock.WeatherState s = IWeatheringBlock.WeatherState.oxidationStates()[i];
            BlockEntry prev = previous.get();
            BlockEntry block = ((BlockBuilder)builder.apply(PantographsAndWires.REGISTRATE.block(name + (String)(!s.getname().isBlank() ? "_" + s.getname() : ""), p -> factory.create((BlockBehaviour.Properties)p, s, () -> prev == null ? null : (Block)prev.get())))).register();
            if (Platform.getEnvironment() == Env.CLIENT) {
                CustomBlockModelRegistry.registerForBlock(() -> (Block)block.get(), () -> new OxidizedBlockModel(oxidizingTextures), () -> new OxidizedBlockModel(oxidizingTextures));
            }
            variants.put(s, block);
            previous.set(block);
        }
        if (addGalvanizedState) {
            IWeatheringBlock.WeatherState s = IWeatheringBlock.WeatherState.GALVANIZED;
            BlockEntry block = ((BlockBuilder)builder.apply(PantographsAndWires.REGISTRATE.block(name + (String)(!s.getname().isBlank() ? "_" + s.getname() : ""), p -> factory.create((BlockBehaviour.Properties)p, s, null)))).register();
            if (Platform.getEnvironment() == Env.CLIENT) {
                CustomBlockModelRegistry.registerForBlock(() -> (Block)block.get(), () -> new OxidizedBlockModel(oxidizingTextures), () -> new OxidizedBlockModel(oxidizingTextures));
            }
            variants.put(s, block);
        }
        return ImmutableMap.copyOf(variants);
    }

    private static <T extends BlockEntry<? extends Block>> T registerBlockEntityBlock(Collection<NonNullSupplier<? extends Block>> mem, T e) {
        mem.add((NonNullSupplier<? extends Block>)e);
        return e;
    }

    static {
        for (int i = 1; i <= 16; ++i) {
            cantileverConnectableTags.add(ModBlocks.createTag("cantilever_connectable_" + i + "px"));
        }
        TAG_CANTILEVER_CONNECTABLE = ModBlocks.createTag("cantilever_connectable");
        TAG_CANTILEVER_MAST_BRACKET_FITTING = ModBlocks.createTag("cantilever_mast_bracket_fitting");
        TAG_CANTILEVER_MAST_HINGE = ModBlocks.createTag("cantilever_mast_hinge");
        TAG_TENSIONING_DEVICE_CONNECTABLE = ModBlocks.createTag("tensioning_device_connectable");
        TAG_CANTILEVER_CONNECTABLE_16PX = ModBlocks.createTag("cantilever_connectable_16px");
        TAG_CANTILEVER_CONNECTABLE_12PX = ModBlocks.createTag("cantilever_connectable_12px");
        TAG_CANTILEVER_CONNECTABLE_8PX = ModBlocks.createTag("cantilever_connectable_8px");
        TAG_CANTILEVER_CONNECTABLE_5PX = ModBlocks.createTag("cantilever_connectable_5px");
        TAG_CANTILEVER_CONNECTABLE_4PX = ModBlocks.createTag("cantilever_connectable_4px");
        TAG_CATENARY_HEADSPAN_CONNECTABLE = ModBlocks.createTag("catenary_headspan_connectable");
        TAG_SUPPORT_WIRE_CONNECTABLE = ModBlocks.createTag("support_wire_connectable");
        PANTOGRAPH = ((BlockBuilder)((BlockBuilder)((BlockBuilder)PantographsAndWires.REGISTRATE.block("pantograph", PantographBlock::new).initialProperties(SharedProperties::softMetal).transform(TagGen.pickaxeOnly())).onRegister(MovementBehaviour.movementBehaviour((MovementBehaviour)new PantographMovementBehaviour()))).onRegister(MovingInteractionBehaviour.interactionBehaviour((MovingInteractionBehaviour)new PantographInteractionBehaviour()))).register();
        LATTICE_MAST = ModBlocks.registerOxidizingBlock("lattice_mast", LatticeMastBlock::new, Set.of(new ResourceLocation("pantographsandwires", "block/metal")), true, builder -> (BlockBuilder)((BlockBuilder)builder.initialProperties(SharedProperties::softMetal).transform(TagGen.pickaxeOnly())).item().tab(ModCreativeModeTab.MAIN_TAB.getKey()).build());
        FLAT_LATTICE_MAST = ModBlocks.registerOxidizingBlock("flat_lattice_mast", FlatLatticeMastBlock::new, Set.of(new ResourceLocation("pantographsandwires", "block/metal")), true, builder -> (BlockBuilder)((BlockBuilder)builder.initialProperties(SharedProperties::softMetal).transform(TagGen.pickaxeOnly())).item().tab(ModCreativeModeTab.MAIN_TAB.getKey()).build());
        FLAT_LATTICE_MAST_DIAGONAL = ModBlocks.registerOxidizingBlock("flat_lattice_mast_diagonal", FlatLatticeMastBlock::new, Set.of(new ResourceLocation("pantographsandwires", "block/metal")), true, builder -> (BlockBuilder)((BlockBuilder)builder.initialProperties(SharedProperties::softMetal).transform(TagGen.pickaxeOnly())).item().tab(ModCreativeModeTab.MAIN_TAB.getKey()).build());
        H_BEAM_MAST = ModBlocks.registerOxidizingBlock("h_beam_mast", HBeamMastBlock::new, Set.of(new ResourceLocation("pantographsandwires", "block/metal")), true, builder -> (BlockBuilder)((BlockBuilder)builder.initialProperties(SharedProperties::softMetal).transform(TagGen.pickaxeOnly())).item().tab(ModCreativeModeTab.MAIN_TAB.getKey()).build());
        CONCRETE_POST = ModBlocks.registerOxidizingBlock("concrete_post", (properties, weatherState, next) -> new ConcretePillarBlock(properties, weatherState, next, false), Set.of(new ResourceLocation("pantographsandwires", "block/concrete_post")), false, builder -> (BlockBuilder)((BlockBuilder)builder.initialProperties(() -> Blocks.f_50470_).transform(TagGen.pickaxeOnly())).item().tab(ModCreativeModeTab.MAIN_TAB.getKey()).build());
        CONCRETE_PILLAR = ModBlocks.registerOxidizingBlock("concrete_pillar", (properties, weatherState, next) -> new ConcretePillarBlock(properties, weatherState, next, true), Set.of(new ResourceLocation("pantographsandwires", "block/concrete_post")), false, builder -> (BlockBuilder)((BlockBuilder)builder.initialProperties(() -> Blocks.f_50470_).transform(TagGen.pickaxeOnly())).item().tab(ModCreativeModeTab.MAIN_TAB.getKey()).build());
        REGISTRATION_ARM = PantographsAndWires.REGISTRATE.block("registration_arm", RegistrationArmBlock::new).register();
        TENSIONING_DEVICE = ((BlockBuilder)((BlockBuilder)((BlockBuilder)PantographsAndWires.REGISTRATE.block("tensioning_device", TensioningDeviceBlock::new).initialProperties(() -> Blocks.f_50470_).transform(TagGen.pickaxeOnly())).onRegister(CreateRegistrate.blockModel(() -> RotatedBlockModel::new))).item().tab(ModCreativeModeTab.MAIN_TAB.getKey()).properties(p -> p.m_41487_(16)).build()).register();
        CANTILEVER_BRACKET = ModBlocks.registerOxidizingBlock("cantilever_bracket", CantileverBracketBlock::new, Set.of(new ResourceLocation("pantographsandwires", "block/metal")), true, builder -> (BlockBuilder)((BlockBuilder)builder.initialProperties(SharedProperties::softMetal).transform(TagGen.pickaxeOnly())).item().tab(ModCreativeModeTab.MAIN_TAB.getKey()).build());
        CANTILEVER_BRACKET_VERTICAL = ModBlocks.registerOxidizingBlock("cantilever_bracket_vertical", CantileverBracketVerticalBlock::new, Set.of(new ResourceLocation("pantographsandwires", "block/metal")), true, builder -> (BlockBuilder)builder.initialProperties(SharedProperties::softMetal).transform(TagGen.pickaxeOnly()));
        CANTILEVER_BRACKET_AT_POST = ModBlocks.registerOxidizingBlock("cantilever_bracket_at_post", CantileverBracketPostConnectionBlock::new, Set.of(new ResourceLocation("pantographsandwires", "block/metal")), true, builder -> (BlockBuilder)builder.initialProperties(SharedProperties::softMetal).transform(TagGen.pickaxeOnly()));
        POWER_LINE_BRACKET = ModBlocks.registerOxidizingBlock("power_line_bracket", PowerLineBracketBlock::new, Set.of(new ResourceLocation("pantographsandwires", "block/metal")), true, builder -> (BlockBuilder)((BlockBuilder)builder.initialProperties(SharedProperties::softMetal).transform(TagGen.pickaxeOnly())).item().tab(ModCreativeModeTab.MAIN_TAB.getKey()).build());
        V_INSULATOR_BROWN = ((BlockBuilder)((BlockBuilder)((BlockBuilder)PantographsAndWires.REGISTRATE.block("v_insulator_brown", VInsulatorBlock::new).initialProperties(SharedProperties::softMetal).transform(TagGen.pickaxeOnly())).onRegister(CreateRegistrate.blockModel(() -> RotatedBlockModel::new))).item().tab(ModCreativeModeTab.MAIN_TAB.getKey()).build()).register();
        V_INSULATOR_GREEN = ((BlockBuilder)((BlockBuilder)((BlockBuilder)PantographsAndWires.REGISTRATE.block("v_insulator_green", VInsulatorBlock::new).initialProperties(SharedProperties::softMetal).transform(TagGen.pickaxeOnly())).onRegister(CreateRegistrate.blockModel(() -> RotatedBlockModel::new))).addLayer(() -> () -> RenderType.m_110466_()).item().tab(ModCreativeModeTab.MAIN_TAB.getKey()).build()).register();
        INSULATOR_BROWN = ((BlockBuilder)((BlockBuilder)((BlockBuilder)PantographsAndWires.REGISTRATE.block("insulator_brown", InsulatorBlock::new).initialProperties(SharedProperties::softMetal).transform(TagGen.pickaxeOnly())).onRegister(CreateRegistrate.blockModel(() -> RotatedBlockModel::new))).item().tab(ModCreativeModeTab.MAIN_TAB.getKey()).build()).register();
        INSULATOR_GREEN = ((BlockBuilder)((BlockBuilder)((BlockBuilder)PantographsAndWires.REGISTRATE.block("insulator_green", InsulatorBlock::new).initialProperties(SharedProperties::softMetal).transform(TagGen.pickaxeOnly())).onRegister(CreateRegistrate.blockModel(() -> RotatedBlockModel::new))).addLayer(() -> () -> RenderType.m_110466_()).item().tab(ModCreativeModeTab.MAIN_TAB.getKey()).build()).register();
        U_INSULATOR_GREEN = ((BlockBuilder)((BlockBuilder)((BlockBuilder)PantographsAndWires.REGISTRATE.block("u_insulator_green", UInsulatorBlock::new).initialProperties(SharedProperties::softMetal).transform(TagGen.pickaxeOnly())).onRegister(CreateRegistrate.blockModel(() -> RotatedBlockModel::new))).addLayer(() -> () -> RenderType.m_110466_()).item().tab(ModCreativeModeTab.MAIN_TAB.getKey()).build()).register();
        U_INSULATOR_BROWN = ((BlockBuilder)((BlockBuilder)((BlockBuilder)PantographsAndWires.REGISTRATE.block("u_insulator_brown", UInsulatorBlock::new).initialProperties(SharedProperties::softMetal).transform(TagGen.pickaxeOnly())).onRegister(CreateRegistrate.blockModel(() -> RotatedBlockModel::new))).item().tab(ModCreativeModeTab.MAIN_TAB.getKey()).build()).register();
        GRAPHITE_BLOCK = ((BlockBuilder)((BlockBuilder)PantographsAndWires.REGISTRATE.block("graphite_block", Block::new).initialProperties(SharedProperties::softMetal).transform(TagGen.pickaxeOnly())).item().tab(ModCreativeModeTab.MAIN_TAB.getKey()).build()).register();
        COAL_COKE_BLOCK = ((BlockBuilder)((ItemBuilder)((BlockBuilder)PantographsAndWires.REGISTRATE.block("coal_coke_block", Block::new).initialProperties(() -> Blocks.f_152550_).transform(TagGen.pickaxeOnly())).item(FuelBlockItem::new).onRegister(item -> item.setBurnTime(32000))).tab(ModCreativeModeTab.MAIN_TAB.getKey()).build()).register();
        CANTILEVERS = new HashMap<EInsulatorType, BlockEntry<? extends AbstractCantileverBlock>>();
        CANTILEVER_BLOCK_ENTITY_BLOCKS = new ArrayList<NonNullSupplier<? extends Block>>();
        CANTILEVER_ITEMS = new HashMap<EInsulatorType, ItemEntry<CantileverBlockItem<CantileverBlock>>>();
    }

    @FunctionalInterface
    private static interface IOxidizingBlockFactory<T extends Block> {
        public T create(BlockBehaviour.Properties var1, IWeatheringBlock.WeatherState var2, Supplier<T> var3);
    }
}

