/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.registry;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import de.mrjulsen.mcdragonlib.client.model.ModelContext;
import de.mrjulsen.mcdragonlib.client.model.mesh.BasicMesh;
import de.mrjulsen.mcdragonlib.client.model.mesh.DLModel;
import de.mrjulsen.mcdragonlib.client.model.mesh.Mesh;
import de.mrjulsen.paw.block.RegistrationArmBlock;
import de.mrjulsen.paw.config.ModServerConfig;
import de.mrjulsen.paw.data.WireHitResult;
import de.mrjulsen.paw.registry.ModBlocks;
import de.mrjulsen.paw.registry.ModWireRegistry;
import de.mrjulsen.wires.decoration.IWireDecoration;
import de.mrjulsen.wires.decoration.WireDecorationRenderer;
import de.mrjulsen.wires.graph.registry.DLRegistryObject;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector3f;

public class RegistrationArmWireDecoration
implements IWireDecoration<RegistrationArmWireDecoration> {
    public static final float RADIUS = 0.5f;
    public static final String NBT_ITEM = "Item";
    public static final String NBT_DROPPER_ID = "DropperId";
    public static final String NBT_MIRRORED = "Mirrored";
    public static final String NBT_VARIANT = "Variant";
    private final Renderer renderer = new Renderer(this);
    private ItemStack stack;
    private boolean mirrored;
    private RegistrationArmBlock.State variant;
    private UUID dropperId;

    public RegistrationArmWireDecoration() {
    }

    public RegistrationArmWireDecoration(ItemStack stack, boolean mirrored, RegistrationArmBlock.State variant, UUID dropperId) {
        this();
        this.stack = stack;
        this.mirrored = mirrored;
        this.variant = variant;
        this.dropperId = dropperId;
    }

    @Override
    public DLRegistryObject<IWireDecoration<?>> getRegistryType() {
        return ModWireRegistry.CATENARY_HEADSPAN_REGISTRATION_ARM;
    }

    @Override
    public WireDecorationRenderer<RegistrationArmWireDecoration> getRenderer() {
        return this.renderer;
    }

    @Override
    public void onBreak(Level level, Vector3f position, Optional<Player> player) {
        if (!player.isPresent() || !player.get().m_7500_() && !player.get().m_5833_() || ((Boolean)ModServerConfig.DROP_WIRE_ITEMS_IN_CREATIVE.get()).booleanValue()) {
            ItemEntity itementity = new ItemEntity(level, (double)position.x(), (double)position.y(), (double)position.z(), this.stack);
            itementity.m_32060_();
            level.m_7967_((Entity)itementity);
        }
    }

    @Override
    public InteractionResult use(Level level, Player player, InteractionHand hand, WireHitResult hit) {
        return InteractionResult.PASS;
    }

    public boolean isMirrored() {
        return this.mirrored;
    }

    public RegistrationArmBlock.State getVariant() {
        return this.variant;
    }

    public ItemStack getItem() {
        return this.stack;
    }

    public UUID getDropperId() {
        return this.dropperId;
    }

    public CompoundTag serializeNbt() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_(NBT_ITEM, (Tag)this.stack.m_41739_(new CompoundTag()));
        nbt.m_128379_(NBT_MIRRORED, this.mirrored);
        nbt.m_128344_(NBT_VARIANT, this.variant == null ? (byte)0 : this.variant.getId());
        nbt.m_128362_(NBT_DROPPER_ID, this.dropperId);
        return nbt;
    }

    public void deserializeNbt(CompoundTag nbt) {
        this.stack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_(NBT_ITEM));
        this.mirrored = nbt.m_128471_(NBT_MIRRORED);
        this.variant = RegistrationArmBlock.State.getById(nbt.m_128445_(NBT_VARIANT));
        this.dropperId = nbt.m_128342_(NBT_DROPPER_ID);
    }

    @Override
    public float getRadius(IWireDecoration<?> element) {
        return element != null && element instanceof RegistrationArmWireDecoration ? 0.5f : 0.0f;
    }

    private static class Renderer
    extends WireDecorationRenderer<RegistrationArmWireDecoration> {
        private final Supplier<DLModel> model = Suppliers.memoize(() -> new DLModel(){

            protected Mesh getMesh(DLModel.ModelType type, BakedModel originalModel, BlockState state, RandomSource random, ModelContext context) {
                BasicMesh mesh = BasicMesh.fromBlock((BlockState)((BlockState)((BlockState)ModBlocks.REGISTRATION_ARM.getDefaultState().m_61124_((Property)RegistrationArmBlock.MIRRORED, (Comparable)Boolean.valueOf(((RegistrationArmWireDecoration)((Renderer)this).decoration).mirrored))).m_61124_(RegistrationArmBlock.REGISTRATION_ARM, (Comparable)((Object)((RegistrationArmWireDecoration)((Renderer)this).decoration).variant))), (RandomSource)random);
                mesh.getFaces().forEach(x -> x.setRenderType(RenderType.m_110463_()));
                mesh.translate(new Vector3f(-0.5f));
                mesh.rotate(Axis.f_252436_.m_252977_(90.0f), new Vector3f(0.0f));
                return mesh;
            }
        });

        public Renderer(RegistrationArmWireDecoration decoratin) {
            super(decoratin);
        }

        @Override
        public void render(PoseStack poseStack, VertexConsumer consumer, Vector3f pos, Vector3f direction, int light) {
            this.model.get().render(poseStack.m_85850_(), consumer, DLModel.ModelType.BLOCK, ModBlocks.REGISTRATION_ARM.getDefaultState(), ModelContext.EMPTY, 1.0f, 1.0f, 1.0f, light, OverlayTexture.f_118083_);
        }
    }
}

