/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.util;

import de.mrjulsen.mcdragonlib.client.model.mesh.ITransformable;
import de.mrjulsen.mcdragonlib.client.model.mesh.IVertexElement;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class DLBoundingBox
implements ITransformable<DLBoundingBox> {
    private final List<VertexElement> vertices = new ArrayList<VertexElement>(8);
    private final Vector3f center = new Vector3f();
    private final Vector3f axisX = new Vector3f(1.0f, 0.0f, 0.0f);
    private final Vector3f axisY = new Vector3f(0.0f, 1.0f, 0.0f);
    private final Vector3f axisZ = new Vector3f(0.0f, 0.0f, 1.0f);
    private final Vector3f halfSizes = new Vector3f(0.5f, 0.5f, 0.5f);
    private boolean dirty = true;

    public DLBoundingBox() {
        this.addDefaultCube();
        this.markDirty();
    }

    public DLBoundingBox(Vector3f min, Vector3f max) {
        this.createFromAABB(min, max);
        this.markDirty();
    }

    public DLBoundingBox(AABB aabb) {
        this(new Vector3f((float)aabb.f_82288_, (float)aabb.f_82289_, (float)aabb.f_82290_), new Vector3f((float)aabb.f_82291_, (float)aabb.f_82292_, (float)aabb.f_82293_));
    }

    private void addDefaultCube() {
        this.vertices.clear();
        this.vertices.add(new VertexElement(new Vector3f(-0.5f, -0.5f, -0.5f)));
        this.vertices.add(new VertexElement(new Vector3f(0.5f, -0.5f, -0.5f)));
        this.vertices.add(new VertexElement(new Vector3f(0.5f, 0.5f, -0.5f)));
        this.vertices.add(new VertexElement(new Vector3f(-0.5f, 0.5f, -0.5f)));
        this.vertices.add(new VertexElement(new Vector3f(-0.5f, -0.5f, 0.5f)));
        this.vertices.add(new VertexElement(new Vector3f(0.5f, -0.5f, 0.5f)));
        this.vertices.add(new VertexElement(new Vector3f(0.5f, 0.5f, 0.5f)));
        this.vertices.add(new VertexElement(new Vector3f(-0.5f, 0.5f, 0.5f)));
    }

    private void createFromAABB(Vector3f min, Vector3f max) {
        this.vertices.clear();
        this.vertices.add(new VertexElement(new Vector3f(min.x, min.y, min.z)));
        this.vertices.add(new VertexElement(new Vector3f(max.x, min.y, min.z)));
        this.vertices.add(new VertexElement(new Vector3f(max.x, max.y, min.z)));
        this.vertices.add(new VertexElement(new Vector3f(min.x, max.y, min.z)));
        this.vertices.add(new VertexElement(new Vector3f(min.x, min.y, max.z)));
        this.vertices.add(new VertexElement(new Vector3f(max.x, min.y, max.z)));
        this.vertices.add(new VertexElement(new Vector3f(max.x, max.y, max.z)));
        this.vertices.add(new VertexElement(new Vector3f(min.x, max.y, max.z)));
    }

    public static DLBoundingBox fromVoxelShape(VoxelShape shape) {
        DLBoundingBox box = new DLBoundingBox();
        List boxes = shape.m_83299_();
        if (boxes.isEmpty()) {
            return box;
        }
        float minX = Float.POSITIVE_INFINITY;
        float minY = Float.POSITIVE_INFINITY;
        float minZ = Float.POSITIVE_INFINITY;
        float maxX = Float.NEGATIVE_INFINITY;
        float maxY = Float.NEGATIVE_INFINITY;
        float maxZ = Float.NEGATIVE_INFINITY;
        for (AABB a : boxes) {
            minX = Math.min(minX, (float)a.f_82288_);
            minY = Math.min(minY, (float)a.f_82289_);
            minZ = Math.min(minZ, (float)a.f_82290_);
            maxX = Math.max(maxX, (float)a.f_82291_);
            maxY = Math.max(maxY, (float)a.f_82292_);
            maxZ = Math.max(maxZ, (float)a.f_82293_);
        }
        box.createFromAABB(new Vector3f(minX, minY, minZ), new Vector3f(maxX, maxY, maxZ));
        box.markDirty();
        return box;
    }

    public List<? extends VertexElement> getTransformableElements() {
        return this.vertices;
    }

    private void recomputeIfNeeded() {
        if (!this.dirty) {
            return;
        }
        this.dirty = false;
        this.center.set(0.0f, 0.0f, 0.0f);
        for (VertexElement v : this.vertices) {
            this.center.add((Vector3fc)v.getPos());
        }
        this.center.div((float)this.vertices.size());
        if (this.vertices.size() >= 8) {
            Vector3f v0 = this.vertices.get(0).getPos();
            Vector3f v1 = this.vertices.get(1).getPos();
            Vector3f v3 = this.vertices.get(3).getPos();
            Vector3f v4 = this.vertices.get(4).getPos();
            Vector3f ax = new Vector3f((Vector3fc)v1).sub((Vector3fc)v0);
            Vector3f ay = new Vector3f((Vector3fc)v3).sub((Vector3fc)v0);
            Vector3f az = new Vector3f((Vector3fc)v4).sub((Vector3fc)v0);
            if (ax.lengthSquared() > 1.0E-6f && ay.lengthSquared() > 1.0E-6f && az.lengthSquared() > 1.0E-6f) {
                this.axisX.set((Vector3fc)ax).normalize();
                this.axisY.set((Vector3fc)ay).normalize();
                this.axisZ.set((Vector3fc)az).normalize();
                this.axisZ.set((Vector3fc)this.axisX).cross((Vector3fc)this.axisY).normalize();
                this.axisY.set((Vector3fc)this.axisZ).cross((Vector3fc)this.axisX).normalize();
                float hx = Math.abs(new Vector3f((Vector3fc)v1).sub((Vector3fc)v0).dot((Vector3fc)this.axisX)) * 0.5f;
                float hy = Math.abs(new Vector3f((Vector3fc)v3).sub((Vector3fc)v0).dot((Vector3fc)this.axisY)) * 0.5f;
                float hz = Math.abs(new Vector3f((Vector3fc)v4).sub((Vector3fc)v0).dot((Vector3fc)this.axisZ)) * 0.5f;
                this.halfSizes.set(hx, hy, hz);
                if (hx <= 0.0f || hy <= 0.0f || hz <= 0.0f) {
                    this.computeAxesFallback();
                }
                return;
            }
        }
        this.computeAxesFallback();
    }

    private void computeAxesFallback() {
        float cxx = 0.0f;
        float cxy = 0.0f;
        float cxz = 0.0f;
        float cyy = 0.0f;
        float cyz = 0.0f;
        float czz = 0.0f;
        for (VertexElement v : this.vertices) {
            Vector3f p = new Vector3f((Vector3fc)v.getPos()).sub((Vector3fc)this.center);
            cxx += p.x * p.x;
            cxy += p.x * p.y;
            cxz += p.x * p.z;
            cyy += p.y * p.y;
            cyz += p.y * p.z;
            czz += p.z * p.z;
        }
        Vector3f candidateX = new Vector3f(cxx, cxy, cxz);
        if (candidateX.lengthSquared() < 1.0E-6f) {
            candidateX.set(1.0f, 0.0f, 0.0f);
        }
        this.axisX.set((Vector3fc)candidateX).normalize();
        Vector3f tmp = new Vector3f(0.0f, 1.0f, 0.0f);
        if (Math.abs(this.axisX.dot((Vector3fc)tmp)) > 0.99f) {
            tmp.set(1.0f, 0.0f, 0.0f);
        }
        this.axisY.set((Vector3fc)tmp).sub((Vector3fc)new Vector3f((Vector3fc)this.axisX).mul(this.axisX.dot((Vector3fc)tmp))).normalize();
        this.axisZ.set((Vector3fc)this.axisX).cross((Vector3fc)this.axisY).normalize();
        float maxX = 0.0f;
        float maxY = 0.0f;
        float maxZ = 0.0f;
        for (VertexElement v : this.vertices) {
            Vector3f d = new Vector3f((Vector3fc)v.getPos()).sub((Vector3fc)this.center);
            maxX = Math.max(maxX, Math.abs(d.dot((Vector3fc)this.axisX)));
            maxY = Math.max(maxY, Math.abs(d.dot((Vector3fc)this.axisY)));
            maxZ = Math.max(maxZ, Math.abs(d.dot((Vector3fc)this.axisZ)));
        }
        this.halfSizes.set(maxX, maxY, maxZ);
        if (this.halfSizes.x <= 0.0f) {
            this.halfSizes.x = 0.001f;
        }
        if (this.halfSizes.y <= 0.0f) {
            this.halfSizes.y = 0.001f;
        }
        if (this.halfSizes.z <= 0.0f) {
            this.halfSizes.z = 0.001f;
        }
    }

    private void markDirty() {
        this.dirty = true;
    }

    public void notifyVerticesChanged() {
        this.markDirty();
    }

    public boolean containsPoint(Vector3f worldPoint) {
        this.recomputeIfNeeded();
        Vector3f d = new Vector3f((Vector3fc)worldPoint).sub((Vector3fc)this.center);
        float lx = d.dot((Vector3fc)this.axisX) / this.halfSizes.x;
        float ly = d.dot((Vector3fc)this.axisY) / this.halfSizes.y;
        float lz = d.dot((Vector3fc)this.axisZ) / this.halfSizes.z;
        return Math.abs(lx) <= 1.000001f && Math.abs(ly) <= 1.000001f && Math.abs(lz) <= 1.000001f;
    }

    public boolean intersects(DLBoundingBox other) {
        AABB b;
        AABB a = this.getBoundingBox();
        if (!a.m_82381_(b = other.getBoundingBox())) {
            return false;
        }
        for (VertexElement v : this.vertices) {
            if (!other.containsPoint(v.getPos())) continue;
            return true;
        }
        for (VertexElement v : other.vertices) {
            if (!this.containsPoint(v.getPos())) continue;
            return true;
        }
        for (int i = 0; i < 8; ++i) {
            VertexElement v;
            v = this.vertices.get(i).getPos();
            if (!other.containsPoint((Vector3f)v)) continue;
            return true;
        }
        return false;
    }

    public boolean intersects(AABB aabb) {
        if (!this.getBoundingBox().m_82381_(aabb)) {
            return false;
        }
        Vector3f[] corners = new Vector3f[]{new Vector3f((float)aabb.f_82288_, (float)aabb.f_82289_, (float)aabb.f_82290_), new Vector3f((float)aabb.f_82291_, (float)aabb.f_82289_, (float)aabb.f_82290_), new Vector3f((float)aabb.f_82291_, (float)aabb.f_82292_, (float)aabb.f_82290_), new Vector3f((float)aabb.f_82288_, (float)aabb.f_82292_, (float)aabb.f_82290_), new Vector3f((float)aabb.f_82288_, (float)aabb.f_82289_, (float)aabb.f_82293_), new Vector3f((float)aabb.f_82291_, (float)aabb.f_82289_, (float)aabb.f_82293_), new Vector3f((float)aabb.f_82291_, (float)aabb.f_82292_, (float)aabb.f_82293_), new Vector3f((float)aabb.f_82288_, (float)aabb.f_82292_, (float)aabb.f_82293_)};
        for (Vector3f c : corners) {
            if (!this.containsPoint(c)) continue;
            return true;
        }
        for (VertexElement v : this.vertices) {
            Vector3f p = v.getPos();
            if (!((double)p.x >= aabb.f_82288_) || !((double)p.x <= aabb.f_82291_) || !((double)p.y >= aabb.f_82289_) || !((double)p.y <= aabb.f_82292_) || !((double)p.z >= aabb.f_82290_) || !((double)p.z <= aabb.f_82293_)) continue;
            return true;
        }
        return false;
    }

    public VoxelShape pixelate() {
        return this.pixelate(0.0625f);
    }

    public VoxelShape pixelate(float gridSize) {
        this.recomputeIfNeeded();
        AABB worldAabb = this.getBoundingBox();
        int minX = DLBoundingBox.floorDiv((float)worldAabb.f_82288_, gridSize);
        int minY = DLBoundingBox.floorDiv((float)worldAabb.f_82289_, gridSize);
        int minZ = DLBoundingBox.floorDiv((float)worldAabb.f_82290_, gridSize);
        int maxX = DLBoundingBox.floorDivCeil((float)worldAabb.f_82291_, gridSize);
        int maxY = DLBoundingBox.floorDivCeil((float)worldAabb.f_82292_, gridSize);
        int maxZ = DLBoundingBox.floorDivCeil((float)worldAabb.f_82293_, gridSize);
        VoxelShape result = Shapes.m_83040_();
        for (int x = minX; x < maxX; ++x) {
            for (int y = minY; y < maxY; ++y) {
                for (int z = minZ; z < maxZ; ++z) {
                    float vx0 = (float)x * gridSize;
                    float vy0 = (float)y * gridSize;
                    float vz0 = (float)z * gridSize;
                    float vx1 = vx0 + gridSize;
                    float vy1 = vy0 + gridSize;
                    float vz1 = vz0 + gridSize;
                    boolean intersects = false;
                    Vector3f[] voxelCorners = new Vector3f[]{new Vector3f(vx0, vy0, vz0), new Vector3f(vx1, vy0, vz0), new Vector3f(vx1, vy1, vz0), new Vector3f(vx0, vy1, vz0), new Vector3f(vx0, vy0, vz1), new Vector3f(vx1, vy0, vz1), new Vector3f(vx1, vy1, vz1), new Vector3f(vx0, vy1, vz1)};
                    for (Vector3f corner : voxelCorners) {
                        if (!this.containsPoint(corner)) continue;
                        intersects = true;
                        break;
                    }
                    if (!intersects) {
                        for (VertexElement v : this.vertices) {
                            Vector3f p = v.getPos();
                            if (!(p.x >= vx0) || !(p.x <= vx1) || !(p.y >= vy0) || !(p.y <= vy1) || !(p.z >= vz0) || !(p.z <= vz1)) continue;
                            intersects = true;
                            break;
                        }
                    }
                    if (!intersects) continue;
                    AABB voxelAabb = new AABB((double)vx0, (double)vy0, (double)vz0, (double)vx1, (double)vy1, (double)vz1);
                    result = Shapes.m_83110_((VoxelShape)result, (VoxelShape)Shapes.m_83064_((AABB)voxelAabb));
                }
            }
        }
        return result;
    }

    public VoxelShape toVoxelShape() {
        return this.pixelate(0.0625f);
    }

    public AABB getBoundingBox() {
        float minX = Float.POSITIVE_INFINITY;
        float minY = Float.POSITIVE_INFINITY;
        float minZ = Float.POSITIVE_INFINITY;
        float maxX = Float.NEGATIVE_INFINITY;
        float maxY = Float.NEGATIVE_INFINITY;
        float maxZ = Float.NEGATIVE_INFINITY;
        for (VertexElement v : this.vertices) {
            Vector3f p = v.getPos();
            minX = Math.min(minX, p.x);
            minY = Math.min(minY, p.y);
            minZ = Math.min(minZ, p.z);
            maxX = Math.max(maxX, p.x);
            maxY = Math.max(maxY, p.y);
            maxZ = Math.max(maxZ, p.z);
        }
        return new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    private static int floorDiv(float v, float grid) {
        return (int)Math.floor(v / grid);
    }

    private static int floorDivCeil(float v, float grid) {
        return (int)Math.ceil(v / grid);
    }

    public static DLBoundingBox fromAABB(AABB aabb) {
        return new DLBoundingBox(aabb);
    }

    public void rotate(Quaternionf rotation) {
        Vector3f pivot = this.center();
        this.rotate(rotation, pivot);
        this.notifyVerticesChanged();
    }

    public static List<DLBoundingBox> listFromVoxelShape(VoxelShape shape) {
        ArrayList<DLBoundingBox> out = new ArrayList<DLBoundingBox>();
        List boxes = shape.m_83299_();
        for (AABB a : boxes) {
            out.add(new DLBoundingBox(a));
        }
        return out;
    }

    public void translate(Vector3f delta) {
        super.translate(delta);
        this.notifyVerticesChanged();
    }

    public void scale(Vector3f factor, Vector3f pivot) {
        super.scale(factor, pivot);
        this.notifyVerticesChanged();
    }

    public void rotate(Quaternionf rotation, Vector3f pivot) {
        super.rotate(rotation, pivot);
        this.notifyVerticesChanged();
    }

    public void transform(Matrix4f matrix) {
        super.transform(matrix);
        this.notifyVerticesChanged();
    }

    public static class VertexElement
    implements IVertexElement {
        private final Vector3f pos;

        public VertexElement(Vector3f pos) {
            this.pos = pos;
        }

        public Vector3f getPos() {
            return this.pos;
        }
    }
}

